#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "nuke.h"

main()
{
    FILE    *fp, *fopen();
    int     nukf, x, n, numnukes;
    struct nukstr *sp;
    struct nukstr all[2000];
    char    *sprintf(), buf[80];

    if ((fp=fopen("nuke.ascii", "r")) == (FILE *)0){
        fprintf(stderr,"Cannot open nuke.ascii!\n");
        exit(-1);
    }

    fscanf(fp,"%d",&numnukes);

    sp = all;
    for(x=0;x<numnukes;x++,sp++)
        read_nuke(sp, fp);
    fclose(fp);

    unlink(sprintf(buf,"%s/nuke",DATADIR));
    nukf = open(sprintf(buf,"%s/nuke",DATADIR), O_WRONLY|O_CREAT, 0);
    n=write(nukf, all, numnukes*sizeof(struct nukstr));
    close(nukf);

    printf("Writing %s/nuke\n",DATADIR);
    printf("wrote %d bytes out of %d!\n",n,numnukes*sizeof(struct nukstr));
}

read_nuke(np, fp, cnum)
struct nukstr *np;
FILE *fp;
int  cnum;
{
    int x, y;
    float f;
    long l;
    char c;

    fscanf(fp,"%d ",&x);
    np->nuk_x = (coord)x;
    fscanf(fp,"%d ",&x);
    np->nuk_y = (coord)x;
    fscanf(fp,"%d ",&x);
    np->nuk_own = (natid)x;
    fscanf(fp,"%d ",&x);
    np->nuk_n=(char)x;
    fscanf(fp,"%d ",&x);
    np->nuk_uid=(short)x;
    fscanf(fp,"%d ",&x);
    np->nuk_ship=(short)x;
    fscanf(fp,"%d ",&x);
    np->nuk_trade=(short)x;

    for(y=0;y<N_MAXNUKE;y++){
        fscanf(fp,"%d ",&x);
        np->nuk_types[y]=(char)x;
        }
}
