#!/bin/awk -f
#
#	A deity tool to parse a dump file and generate edit commands
#	to fix the work.  So
#		dump * | fixwork >fixwork.out
#		exec fixwork.out
#

BEGIN {
  sects=0;
  begin=0;
}

{

  if (begin==1) {
    for (i=1;i<=NF;i++) header[i]=$i;
    nheader=NF;
    begin=2;
    break;
  }

  if (NF != nheader) {
    begin=0;
  }

  if (begin==2) {
    for (i=1;i<=nheader;i++) {
      val[header[i]] = $i;
    }
    if (val["own"]>0 && val["work"]<100) {
      printf("edit land %s,%s\nw 100\n\n",val["x"],val["y"]);
    }
  }

}

/ *DUMP SECTOR/ { begin=1; }

