#include "/users/sys/empire/EMP/h/gamesdef.h"
#include "/users/sys/empire/EMP/h/misc.h"
#include "/users/sys/empire/EMP/h/sect.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <math.h>
#include <stdio.h>
#include <X11/Box.h>
#include <X11/Form.h>
#include <X11/Composite.h>
#include <X11/Command.h>
#include <X11/Shell.h>
#ifdef	sys5
#include <string.h>
#else
#include <strings.h>
#endif	sys5
#include "Graph.h"
#include <X11/Xlib.h>

Widget thegraph,
       toplevel;

char    *sectfil=EMPPATH(data/sector);
struct  sctstr sects[WORLD_Y*WORLD_X/2];


#define XSIZE WORLD_X 
#define YSIZE WORLD_Y 

int uimage[WORLD_X][WORLD_Y];

#define BOX_SIZE 8

get_sect_file()
{
        int     sectf;

        sectf = open(sectfil, 0);
        if (sectf < 0) {
                perror(sectfil);
                exit(1);
        }
        read(sectf, sects, sizeof(sects));
        close(sectf);
}

void quitit(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
       exit(1);
   }

void ClearIt(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
    int i,j;

    for(i=0;i<XSIZE;i++){
	for(j=0;j<YSIZE;j++){
	   uimage[i][j] = 0;
	}
    }
    displaypicture(uimage,thegraph,XSIZE,YSIZE,BOX_SIZE);
     
   }

static void dofer(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
        int     x, y;
        struct sctstr *sp = sects;

        UnFillColorMap(thegraph);
	MiniralFillColorMap(thegraph);
        for (y = 0; y < WORLD_Y; y++) {
                for (x = 0; x < WORLD_X; x++) {
                        if (((x ^ y) & 1)){
                                continue;
                        } else {
			    uimage[x][y] = ((sp->sct_gmin/5)+3);
			    sp++;
			} 
		}
	}
    displaypicture(uimage,thegraph,XSIZE,YSIZE,BOX_SIZE);
  }

static void doalt(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
        int     x, y;
        struct sctstr *sp = sects;

        UnFillColorMap(thegraph);
	ElevationFillColorMap(thegraph);
        for (y = 0; y < WORLD_Y; y++) {
                for (x = 0; x < WORLD_X; x++) {
                        if (((x ^ y) & 1)){
                                continue;
                        } else {
			    uimage[x][y] = ((sp->sct_elev+120)/10)+1;
			    sp++;
			} 
		}
	}
    displaypicture(uimage,thegraph,XSIZE,YSIZE,BOX_SIZE);
  }

static void donat(wid,cdat,rdat)
    Widget   wid;
    caddr_t  cdat,rdat;
   {
        int     x, y;
        struct sctstr *sp = sects;

	UnFillColorMap(thegraph);
	NationFillColorMap(thegraph);
        for (y = 0; y < WORLD_Y; y++) {
                for (x = 0; x < WORLD_X; x++) {
                        if (((x ^ y) & 1)){
                                continue;
                        } else {
			    uimage[x][y] = sp->sct_own+10;
			    if(sp->sct_own == 0) {
				if (sp->sct_type == SCT_WATER ) {
				    uimage[x][y] = 2;
				}}
			    sp++;
			} 
		}
	}
    displaypicture(uimage,thegraph,XSIZE,YSIZE,BOX_SIZE);
  }


main(argc,argv)
   int argc;
   char *argv[];

   {
   
    Widget  box,
	    Quit,
	    Clear,
	    natb,
	    elevb,elevc,
	    TITLE;

    Arg     args[10];
    int     i,j;
	    
    int     pict[XSIZE][YSIZE];
    XtTranslations trans;


    static XtCallbackRec quiter[][2]= {{{quitit,NULL},{NULL,NULL}},
				       {{dofer,NULL},{NULL,NULL}},
				       {{doalt,NULL},{NULL,NULL}},
				       {{donat,NULL},{NULL,NULL}},
				       {{ClearIt,NULL},{NULL,NULL}}};

    toplevel = XtInitialize(argv[0],"FOURIER",NULL,0,&argc,argv);
    XtSetArg(args[0],XtNborderWidth,0);
    box = XtCreateManagedWidget("FOURIER",formWidgetClass,toplevel,args,1);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Empire Diety Utility");
    TITLE = XtCreateManagedWidget("label",labelWidgetClass,box,args,1);


    XtSetArg(args[0],XtNlabel,(XtArgVal) "Clear");
    XtSetArg(args[1],XtNfromHoriz,TITLE);
    XtSetArg(args[2],XtNcallback,quiter[4]);
    Clear = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Elevations");
    XtSetArg(args[1],XtNfromHoriz,Clear);
    XtSetArg(args[2],XtNcallback,quiter[2]);
    elevb = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Fertility");
    XtSetArg(args[1],XtNfromHoriz,elevb);
    XtSetArg(args[2],XtNcallback,quiter[1]);
    elevc = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Nations");
    XtSetArg(args[1],XtNfromHoriz,elevc);
    XtSetArg(args[2],XtNcallback,quiter[3]);
    natb = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNlabel,(XtArgVal) "Quit");
    XtSetArg(args[1],XtNfromHoriz,natb);
    XtSetArg(args[2],XtNcallback,quiter[0]);
    Quit = XtCreateManagedWidget("label",commandWidgetClass,box,args,3);

    XtSetArg(args[0],XtNheight,YSIZE*BOX_SIZE);
    XtSetArg(args[1],XtNwidth,XSIZE*BOX_SIZE);
    XtSetArg(args[4],XtNfromVert,TITLE);
    
    thegraph = XtCreateManagedWidget("hello",graphWidgetClass,box,args,5);

    XtRealizeWidget(toplevel);

    ClearIt(thegraph,NULL,NULL);
    get_sect_file();

    XtMainLoop();
}
