static char *RCSid = "$Header: empmod.c,v 1.1 89/12/14 13:26:37 jay Exp $";

/*
 * empmod.c
 *
 * Command/function mapping for empire.  Named empmod for historical
 * reasons -- empire used to be broken into seven modules
 * on the venerable pdp 11 so it could fit in 64k I/D space.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "com.h"
#include "nat.h"
#include "tm.h"
#include "file.h"

extern	int  add();
extern	int assa();
extern	int atta();
extern	int boar();
extern	int bomb();
extern	int buil();
extern	int chan();
extern	int coas();
extern	int coll();
extern	int comm();
extern	int cons();
extern	int coun();
extern	int decl();
extern	int deli();
extern	int show();
extern	int desi();
extern	int diss();
extern	int drop();
extern	int enli();
extern	int fire();
extern	int flee();
extern	int  fly();
extern	int info();
extern	int ledg();
extern	int load();
extern	int look();
extern	int  map();
extern	int mine();
extern  int move();
extern	int nati();
extern	int navi();
extern  int head(), news();
extern	int nuke();
extern	int offe();
extern	int offs();
extern	int para();
extern	int path();
extern	int powe();
extern	int rada();
extern	int  rea();
extern	int real();
extern	int reco();
extern	int repa();
extern	int rout();
extern	int sona();

extern	int  spy();
extern	int tele();
extern	int tend();
extern	int torp();
extern	int trad();
extern  int tran();
extern	int trea();
extern	int turn();
extern	int vers();
/*
 * new commands
 */
extern	int buy();
extern	int mult();
extern	int repo();
extern	int fina();
extern	int laun();
extern	int new();
extern	int shoo();
extern	int thre();
extern	int dist();
extern	int sct();
extern	int plan();
extern	int arm();
extern	int hard();
extern	int upgr();
extern	int surv();
extern	int capi();
extern	int orig();
extern	int mark();
extern	int conv();
extern  int leve();
extern	int cuto();
extern	int prod();
extern	int  wai();
extern	int carg();
extern	int terr();
extern	int sate();
extern	int give();
extern	int edit();
extern	int wipe();
extern	int dump();
extern	int expl();
extern	int reso();
extern	int scra();
extern	int rela();
extern	int brea();
extern	int upda();
extern	int hidd();
#if	defined(BMAP) || defined(AUTONAV)
extern	int bmap();
#endif
#ifdef	AUTONAV
extern	int orde();
extern	int qorde();
#endif	AUTONAV
#ifdef	REJECTS
extern	int reje();
extern	int acce();
#endif	REJECTS
#ifdef	SCUTTLE
extern	int scut();
#endif	SCUTTLE
#ifdef	GRIND
extern	int grin();
#endif	GRIND
#ifdef	SAIL
extern	int sail();	/* Forsman's hacks */
extern	int foll();	/**/
extern	int mobq();	/**/
#endif	SAIL
#ifdef	SHIPNAMES
extern	int name();
#endif	SHIPNAMES
#ifdef	RANGEEDIT
extern	int range();
#endif	RANGEEDIT
#ifdef	DEMANDUPDATE
extern	int zdon();
#endif	DEMANDUPDATE

/*
 * Undeclared functions
 */
extern	int quit();
extern	int cens();
extern	int demo();
extern	int sell();
extern	int shi();
extern	int wing();
extern	int execute();
extern	int explain();
extern	int  set();

#define	SCT	bit(EF_SECTOR)
#define SHP	bit(EF_SHIP)
#define PLN	bit(EF_PLANE)

struct  comstr  coms[]  = {
/* command form                       cost lck    addr  permit */
#ifdef	REJECTS
"accept  [as-COUNTRY]",			0, 0,	 acce,	NORM,
#endif	REJECTS
"add <NAT> <NAME> <REP> <STATUS> <c|w|i>",0,SCT, add,  GOD,
"announce {message}",                   1, 0,    tele,  NORM,
"arm <PLANE> <NUKETYPE> <NUMBER>",      3, SCT,   arm,  NORM+MONEY,
"assault <to-SECT> <from-SHIP> <NUMBER>",3,SCT|SHP,assa,NORM+MONEY,
"attack <SECT> <move-in-afterwards?>",   3, SCT,  atta,  NORM+MONEY+CAP,
#if	defined(BMAP) || defined(AUTONAV)
"bmap <SECTS>",                         0, 0,    bmap,  SANCT,
#endif
"board <to-SHIP> <from-SHIP>",          3, SHP,  boar,  NORM+MONEY,
"bomb <bomber-PLANES> <fighter-PLANES> <pin|strat|nuke> <ap-SECT> <PATH>",2,SCT|SHP,bomb,NORM,
"break {sanctuary}",                    1, 0,    brea,  SANCT,
"build <s|n|b|p> <SECTS> <type|dir> <tech>",1,SHP|SCT,buil,NORM+MONEY+CAP,
"buy <COMM> [<NAT> <NUM> <SECT>]",      1,SCT,    buy,  NORM+MONEY+CAP,
"bye {log-off}",                        0, 0,    quit,  VIS,
"capitol <SECT>",                       1, 0,    capi,  NORM,
"cargo <SHIPS>",                        0, 0,    carg,  NORM,
"census <SECTS>",                       0, 0,    cens,  SANCT,
"change <country|representative> <NAME>",0,0,    chan,  SANCT,
"coastwatch <SECTS>",                   1, 0,    coas,  NORM,
"collect <LOAN> <SECT>",                2, 0,    coll,  NORM+CAP,
"commodity <SECTS>",                    0, 0,    comm,  SANCT,
"consider <loan|treaty> <LOAN/TREATY> <acc|decl|post>",1,0,cons,NORM+CAP,
"convert <SECTS> <NUM>",                2, 0,    conv,  NORM+CAP,
"country <NATS>",                       0, 0,    coun,  GOD,
"cutoff <SECTS>",                       0, 0,    cuto,  NORM,
"declare <all|neut|hos|war> <NAT>",     2, 0,    decl,  NORM,
"deliver <COMM> <SECTS> <DIR> <[+|-]thresh>",1,SCT,deli,NORM,
"demobilize <SECTS> <NUM> <active-reserve?>",1,SCT,demo,NORM+MONEY,
"designate <SECTS> <type>",             1, SCT,  desi,  NORM,
"dissolve <really dissove?>",           0, SCT|SHP,diss,GOD,
"distribute <COMMODITY> <SECTS> <PATH>",1, SCT,  dist,  NORM,
"drop <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH> <COMM>",1,SCT,drop,NORM,
"dump <SECTS>",	                        0, 0,    dump,  SANCT,
"edit <country|land|ship|plane|nuke> ...",0,0,	 edit,  GOD,
"enlist <SECTS> <NUM>",                 2, SCT,  enli,  NORM+MONEY+CAP,
"execute <INPUT FILE>",                 0, 0,   execute,SANCT,
"explore <c|m> <SECT> <NUM> <PATH>",    1, SCT,  expl,  NORM+CAP,
"financial",                            1, 0,    fina,  NORM+MONEY,
"fire <target-SECT | SHIP> <from-SECT | SHIP> [GUNS]",1,SCT|SHP,fire,NORM+MONEY,
"fleetadd <FLEET> <SHIPS>",             1, SHP,  flee,  NORM,
"fly <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH> <COM>",2,SCT|SHP,fly,NORM,
#ifdef	SAIL
"follow <leader> <SHIPS>",		1, SHP,  foll,  NORM,
#endif	SAIL
"give <COMM> <SECT> <NUM>",	        0, 0,	 give,  GOD,
#ifdef	GRIND
"grind <SECT> <NUM>",			1, 0,	 grin,	NORM,
#endif	GRIND
"harden <PLANES> <NUM>",                2, SCT,  hard,  NORM+MONEY,
"headlines [days]",                     0, 0,    head,  VIS,
"hidden <SECTS>",	                0, 0,    hidd,  GOD,
"info <topic>",                         0, 0,    info,  VIS,
"launch <PLANES>",                      3, SCT|SHP,laun,NORM+MONEY,
"ledger <LOANS>",                       0, 0,    ledg,  NORM,
"level <SECTS>",                        0, 0,    leve,  NORM,
"list of commands",                     0, 0,    explain,VIS,
"load <SHIPS> <NUM|PLANE> <COMM|\"plane\">",1, SHP|SCT,load,NORM,
"lookout <SHIPS>",                      1, 0,    look,  NORM,
"market [COMM]",                        0, 0,    mark,  NORM,
"map <SECTS>",                          0, 0,    map,   SANCT,
"mine <SHIPS>",                         2, SCT|SHP,mine,NORM+MONEY,
"move <c|m|s|g|p|i|o|b|f|r|u> <SECT> <NUM> <PATH>",1,SCT,move,NORM+CAP,
#ifdef	SAIL
"mquota <SHIPS> <value>",		2, SHP,  mobq,  NORM,
#endif	SAIL
"mult [COUNTRY]",                       1, 0,    mult,  NORM,
#ifdef	SHIPNAMES
"name <SHIPS> <NAME>",			0, SHP,	 name,	NORM,
#endif	SHIPNAMES
"nation",                               0, 0,    nati,  SANCT,
"navigate <SHIPS> <PATH>",              1, SHP,  navi,  NORM,
"newcap <NAT>",                         0, SCT,   new,  GOD,
"newspaper [days]",                     0, 0,    news,  VIS,
"nuke <NUKES>",                         0, 0,    nuke,  NORM+CAP,
"offer <loan|treaty> <NAT> [<NUM> <DAYS> <IRATE>]",1,0,offe,NORM,
"offset <SECT|NAT>",                    0, 0,    offs,  GOD,
#ifdef	AUTONAV
"order <SHIPS> [<c|s|r|d <SECT> [<COMM> [<SECT> [<COMM>]]]]",1,SHP,orde,NORM+CAP,
#endif	AUTONAV
"origin <SECT>",                        1, 0,    orig,  NORM,
"paradrop <cargo-PLANES> <fighter-PLANES> <ap-SECT> <PATH>",3,SCT,para,NORM,
"path <SECT>",                          0, 0,    path,  NORM,
"plane <SECTS>",                        0, 0,    plan,  NORM,
"power [\"new\"]",                      0, 0,    powe,  NORM,
"production <SECTS>",                   0, 0,    prod,  NORM,
#ifdef	AUTONAV
"qorder <SHIPS>",			0, 0,   qorde,	NORM,
#endif	AUTONAV
#ifdef	SAIL
"qsail <SHIPS>",			0, 0,    sail,  NORM,
#endif	SAIL
"quit",                                 0, 0,    quit,  VIS,
"radar <SHIPS | SECTS>",                1, 0,    rada,  NORM,
#ifdef	RANGEEDIT
"range <PLANES> <range>",		1, 0,   range,  NORM,
#endif	RANGEEDIT
"read",                                 0, 0,    rea,   VIS,
"realm <number> [<SECTS>]",             0, 0,    real,  SANCT,
"recon <spy-PLANES> <fighter-PLANES> <ap-SECT> <PATH>",3,0,reco,NORM,
"relations  [as-COUNTRY]",		0, 0,	 rela,	SANCT,
#ifdef	REJECTS
"reject <announcements|mail|treaties> <NAT>",2,0,reje,  NORM,
#endif	REJECTS
"repay <LOAN> <NUM>",                   1, 0,    repa,  NORM,
"report <NATS>",                        0, 0,    repo,  VIS,
"resource <SECTS>",                     0, 0,    reso,  SANCT,
"route <COMM> <SECTS>",                 1, 0,    rout,  NORM+CAP,
#ifdef	SAIL
"sail <SHIPS> <PATH>",			1,SHP,	 sail,  NORM,
#endif	SAIL
"satellite <SECTS>",                    1, 0,    sate,  NORM,
"scrap <TYPE> <SHIPS|PLANES>",          2,SHP,   scra,  NORM+MONEY,
#ifdef	SCUTTLE
"scuttle <TYPE> <SHIPS|PLANES>",	5,SHP|PLN,scut,	NORM+MONEY,
#endif	SCUTTLE
"sect <SECTS>",                         0, 0,    sct,   NORM,
"sell <COMM> <SECTS> <NUM> <NUM>",      1, SCT,  sell,  NORM+MONEY,
"set <TYPE> <LIST> <PRICE>",            1,SHP,   set,   NORM+MONEY,
"ship <SHIPS>",                         0, 0,    shi,   NORM,
"shoot <SECTS> <NUMBER>",               3, SCT,  shoo,  NORM+CAP,
"show <TYPE> <\"build\"|\"cap\">",	0, 0,	 show,	VIS,
"sonar <SHIPS>",		        1, 0,    sona,  NORM,
"spy <SECTS>",				1, SCT,  spy,   NORM+CAP,
"survey <COMM|VAR> <SECTS>",            0, 0,    surv,  NORM+CAP,
"telegram <NAT>",                       1, 0,    tele,  NORM,
"tend <tender-SHIPS> <COMM> <NUM> <dest-SHIPS>",1,SHP,tend,NORM+MONEY,
"territory <SECTS> <NUMBER>",		1, SCT,  terr,  NORM,
"test <c|m|s|g|p|i|o|b|f|r|u> <SECT> <NUM> <PATH>",1,SCT,move,NORM+CAP,
"threshold <COMM> <SECTS> <THRESH>",    1, SCT,  thre,  NORM,
"torpedo <target-SHIP> <submarine-SHIP>",3,SHP,  torp,  NORM+MONEY,
"trade",                                1, SHP,  trad,  NORM,
"transport <\"nuke\"|\"plane\"> <NUKES|PLANES> [nuketype] <PATH>",1,SCT|SHP,tran,NORM+CAP,
"treaty <TREATIES>",                    0, 0,    trea,  NORM,
"turn <\"on\"|\"off\"|\"mess\">",          0, 0,    turn,  GOD,
"unload <SHIPS> <NUM|PLANE> <COMM|\"plane\">",1, SHP|SCT,load,NORM,
#ifdef	SAIL
"unsail <SHIPS>",			1, SHP,  sail,  NORM,
#endif	SAIL
"update",                               0, 0,    upda,  VIS,
"upgrade <SHIPS>",                      1, SHP,  upgr,  NORM+MONEY,
"version",                              0, 0,    vers,  VIS,
"wait",                                 0, 0,     wai,  SANCT,
"wingadd <WING> <PLANES>",              1, PLN,  wing,  NORM,
"wipe <SECTS>",				1, SCT,  wipe,  NORM,
#ifdef	DEMANDUPDATE
"zdone <y|n|c>",			0, 0,    zdon,	NORM,
#endif	DEMANDUPDATE
0,					0, 0,       0,  0,
};

