#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/sect.c,v 1.10 89/09/02 02:38:47 mr-frog Exp $";
#endif

/*
 * sect.c
 *
 * show sectors in map-like format with conditionals.  All sectors
 * matching are shown as caps.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "com.h"
#include "nat.h"
#include "file.h"
#include "map.h"
#include "deity.h"

sct()
{
	extern	char *argp[];
	struct	nstr_sect ns;
	struct	sctstr sect;
	struct	nscstr cond[NS_NCOND];
	struct	range range;
	struct	natstr *np;
	char	map[WORLD_Y][MAPWIDTH(1)];
	int	ncond;
	int     nsect;
	char	*ptr;
	coord	y, yval;
	int	i;

	nsect = 0;
	if (!snxtsct(&ns, argp[1]))
		return RET_SYN;
	np = getnatp(cnum);
	ncond = ns.ncond;
	bcopy((char *)ns.cond, (char *)cond, sizeof(*cond) * ncond);
	ns.ncond = 0;
	xyrelrange(getnatp(cnum), &ns.range, &range);
	border(&range, "    ", "");
	blankfill((char *)map, &ns.range, 1);
	while (nxtsct(&ns, &sect)) {
		if (!owner)
			continue;
		ptr = &map[ns.dy][ns.dx];
		*ptr = dchr[sect.sct_type].d_mnem;
		if (nstr_exec(cond, ncond, (char *)&sect, EF_SECTOR)) {
			++nsect;
			*ptr |= 0x80;
		}
	}
	for (i=0,y=ns.range.ly; i < ns.range.height; y++,i++) {
		yval = yrel(np, y);
		pr(fmt("%3d %s %-3d\n", yval, map[i], yval));
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&range, "    ", "");
	pr(fmt("\n%d sector%s.\n", nsect, splur(nsect)));
	return RET_OK;
}
