#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/subs/RCS/satmap.c,v 1.15 89/09/18 00:07:20 mr-frog Exp $";
#endif

/*
 * satmap.c
 *
 * do a satellite map given an x,y location, effic,
 * and other things.
 *
 * Author Unknown
 */

#include "misc.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "var.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

satmap(x, y, eff, range, flags)
	int     x;
	int     y;
	int     eff;
	int	range;
	int     flags;
{
	char	rad[WORLD_Y][WORLD_X+1];
	int     acc;
	struct	sctstr sect;
	struct	shpstr ship;
	int     count;
	struct	nstr_item ni;
	struct	nstr_sect ns;
	int	rx, ry;
	int	row;
	int	n;

	range *= (eff / 100.0);
	pr(fmt("%s efficiency %d%%, max range %d\n", xyas(x, y, cnum),
		eff, range));
	snxtsct_dist(&ns, x, y, range);
	blankfill((char *)rad, &ns.range, 1);
	if (flags & P_S) {
		pr("Satellite sector report\n");
		prdate();
		sathead();
		acc = (flags & P_I) ? 5 : 50;
	}
	count = 0;
	while (nxtsct(&ns, &sect)) {
		if (flags & P_S) {
			if (sect.sct_type > SCT_RURAL) {
				satdisp(&sect, acc);
				++count;
			}
		}
		if ((flags & P_I) ||
		    sect.sct_type == SCT_WATER ||
		    sect.sct_type == SCT_MOUNT) {
			rad[ns.dy][ns.dx] = dchr[sect.sct_type].d_mnem;
		} else
			rad[ns.dy][ns.dx] = '?';
	}
	if (flags & P_S)
		pr(fmt("  %d sectors\n\n", count));
	count = 0;
	if ((flags & P_S) || (flags & P_I)) {
		snxtitem_dist(&ni, EF_SHIP, x, y, range);
		if (flags & P_S) {
			pr("Satellite ship report\n");
			prdate();
			pr(" own  shp# ship type         sector   eff\n");
		}
		while (nxtitem(&ni, (caddr_t)&ship)) {
			if (ship.shp_own == 0)
				continue;
			if ((mchr[ship.shp_type].m_flags & M_SUB) &&
			    ((flags & (P_S|P_I)) != (P_S|P_I)))
				continue;
			if (flags & P_S) {
				pr(fmt("%4d %4d %-16.16s %s %3d%%\n",
				       ship.shp_own, ship.shp_uid,
				       mchr[ship.shp_type].m_name,
				       xyfmt("%4d,%-4d", ship.shp_x,
				       ship.shp_y, cnum), ship.shp_effic));
				++count;
			}
			if (flags & P_I) {
				/* &~0x20 makes it a cap letter */
				ry = deltay((int)ship.shp_y, (int)ni.range.ly);
				rx = deltax((int)ship.shp_x, (int)ni.range.lx);
				rad[ry][rx] =
				    (*mchr[ship.shp_type].m_name) & ~0x20;
			}
		}
		if (flags & P_S)
			pr(fmt("  %d ships\n\n", count));
	}

	/*
	 * print out the map
	 * We have to make the center a '0' for ve
	 * ve needs a garbage line to terminate the map
	 */
	rad[deltay(y, ns.range.ly)][deltax(x, ns.range.lx)] = '0';

	pr("Satellite radar report\n");
	n = deltay(ns.range.hy, ns.range.ly);
	for (row=0; row < n; row++)
		pr(fmt("%s\n", rad[row]));
	pr("\n(c) 1989 Imaginative Images Inc.\n");
}


sathead()
{
	pr("  sect   type own eff   civ  mil  shl  gun iron  pet  food\n");
}

satdisp(sp, acc)
	struct sctstr *sp;
	int     acc;
{
	int	vec[I_MAX+1];

	if (getvec(VT_ITEM, vec, (caddr_t)sp, EF_SECTOR) < 0)
		return;
	pr(fmt("%s   %c  %3d  %3d %4d %4d %4d %4d  %4d %4d %5d\n",
	       xyfmt("%4d,%-4d", sp->sct_x, sp->sct_y, cnum),
	       dchr[sp->sct_type].d_mnem,
	       sp->sct_own, round((int)sp->sct_effic, acc / 2),
	       round(vec[I_CIVIL], acc), round(vec[I_MILIT], acc),
	       round(vec[I_SHELL], acc), round(vec[I_GUN], acc),
	       round(vec[I_IRON], acc), round(vec[I_PETROL], acc),
	       round(vec[I_FOOD], acc)));
}
