#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/give.c,v 1.13 89/09/02 02:35:54 mr-frog Exp $";
#endif /* not lint */

/*
 * give.c
 *
 * David Muir Sharnoff
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "item.h"
#include "deity.h"
#include "file.h"

/*
 * format: give <commod> <sect> <amt>
 */
give()
{
	extern	char *argp[];
	struct	sctstr sect;
	char	*p;
	int	amt;
	struct	ichrstr *ip;
	int	n;
	coord	x, y;

	if (!(ip = whatitem(argp[1], "which commodity? ")))
		return RET_SYN;
	if (!(p = getstarg(argp[2],"which sector : ")))
		return RET_SYN;
	if (!sarg_xy(p, &x, &y))
		return RET_SYN;
	if (!(p = getstarg(argp[3], "how much : ")) || (*p  == '\0'))
		return RET_SYN;
	if ((amt = atoi(p)) == 0)
		return RET_SYN;
	getsect(x, y, &sect);
	n = getvar(ip->i_vtype, (char *)&sect, EF_SECTOR);
	if (amt + n > 9990 || amt + n < 0) {
		pr(fmt("Sector %s cannot hold that much!\n",
			xyas(sect.sct_x, sect.sct_y, cnum)));
		return RET_FAIL;
	}
	if (putvar(ip->i_vtype, n+amt, (char *)&sect, EF_SECTOR) < 0) {
		pr(fmt("No room to store %s in %s\n", ip->i_name,
				xyas(sect.sct_x, sect.sct_y, cnum)));
		return RET_FAIL;
	}
	putsect(&sect);
	if (sect.sct_own != 0) {
		if (amt >0) {
			nreport(cnum, N_GIFT, sect.sct_own, 1);
			wu(0, sect.sct_own, fmt("%s gave you %d %s in %s\n",
				cname(cnum), amt, ip->i_name, 
				xyas(sect.sct_x, sect.sct_y, sect.sct_own)));
		} else {
			nreport(sect.sct_own, N_TAKE, cnum, 1);
			wu(0, sect.sct_own, fmt("%s stole %d %s from %s\n",
				cname(cnum), -amt, ip->i_name,
				xyas(sect.sct_x, sect.sct_y, sect.sct_own)));
		}
	}
	pr(fmt("%d %s in %s\n", n+amt, ip->i_name,
		xyas(sect.sct_x, sect.sct_y, cnum)));
	return RET_OK;
}
