#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/plane.c,v 1.7 89/06/27 01:38:27 griffith Exp $";
#endif

/*
 * plane.c
 *
 * plane post-read and pre-write
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "plane.h"
#include "ship.h"
#include "xy.h"
#include "file.h"
#include "nat.h"
#include "deity.h"

int
pln_postread(n, ptr)
	int	n;
	s_char	*ptr;
{
	struct	plnstr *pp = (struct plnstr *) ptr;
	struct	shpstr theship;
	s_char	*p;

	if (pp->pln_ship >= 0 && pp->pln_own && pp->pln_effic >= 10) {
		if (!getship(pp->pln_ship, &theship) ||
#if defined (SHIPCHOPPERS) || defined (XLIGHT)
		    (theship.shp_effic < 20)){
#else
		    (theship.shp_effic < 20) ||
		    !(mchr[theship.shp_type].m_flags & (M_FLY|M_MSL))) {
#endif
			p = fmt("%s #%d sunk!\n", plchr[pp->pln_type].pl_name,
				n);
			if ((pp->pln_own == cnum) || god)
				pr(p);
			/* yes, sunk */
			if (pp->pln_own && (pp->pln_own != cnum))
				wu(0, pp->pln_own, p);
			pp->pln_own = 0;
			(void) ef_nbwrite(EF_PLANE, n, ptr);
		} else {
			/* wooof!  Carriers are a pain */
			pp->pln_x = theship.shp_x;
			pp->pln_y = theship.shp_y;
		}
	}
	owner = (god || pp->pln_own == cnum);
	return 1;
}

/*ARGSUSED*/
int
pln_prewrite(n, ptr)
	int	n;
	s_char	*ptr;
{
	struct	plnstr *pp = (struct plnstr *) ptr;

	if (pp->pln_effic < 10)
		pp->pln_own = 0;
	return 1;
}
