#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/player/commands/RCS/sail.c,v 1.1 91/03/19 20:58:47 dhay Exp Locker: dhay $";
#endif /* not lint */

/*
 * sail.c
 *
 * set sail path for leaders
 *
 * Hacked by Robert Forsman <thoth@beach.cis.ufl.edu>
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "ship.h"
#include "path.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"
#include "deity.h"

#ifdef	SAIL

static int
show_sail(nstr)
	struct	nstr_item *nstr;
{
	extern	s_char *argp[];
	register int count=0;
	struct shpstr ship;

	while (nxtitem(nstr, &ship)) {
		if (!owner || ship.shp_own==0)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
					ship.shp_type, nstr->cur));
			continue;
		}
		if (count++==0) {
			if (god)
				pr("own ");
			pr("shp#     ship type       x,y    ");
			pr("mobil mobquota follows path\n");
		}
		if (god)
			pr(fmt("%3d ",ship.shp_own));
		pr(fmt("%4d ", ship.shp_uid));
		pr(fmt("%-16.16s ", mchr[ship.shp_type].m_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", ship.shp_x,
				ship.shp_y, cnum)));
		pr(fmt("%3d  ",ship.shp_mobil));
		pr(fmt("   %3d     ",ship.shp_mobquota));
		pr(fmt("   %3d   ",ship.shp_follow));
		if (ship.shp_path[0]) {
			pr(ship.shp_path);
#ifdef	AUTONAV
		} else if ((ship.shp_autonav & AN_AUTONAV)) {
			pr("Has orders");
#endif	AUTONAV
		}
		pr("\n");
#ifdef	SHIPNAMES
		if (ship.shp_name[0] != 0) {
			if (god)
				pr("    ");
			pr(fmt("       %s\n",ship.shp_name));
		}
#endif	SHIPNAMES
	}
	if (count == 0) {
		if (argp[1])
			pr(fmt("%s: No ships(s)\n", argp[1]));
		else
			pr(fmt("%s: No ships(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d ship%s\n", count, splur(count)));
	return RET_OK;
}

static int
unsail_ship(nstr)
	struct	nstr_item *nstr;
{
	struct shpstr ship;
	int count = 0;

	while (nxtitem(nstr, (s_char *)&ship)) {
		if (!owner || ship.shp_own==0)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
					ship.shp_type, nstr->cur));
			continue;
		}
		if (ship.shp_path[0]) {
			pr(fmt("Ship #%d unsailed\n",ship.shp_uid));
			count++;
			ship.shp_path[0] = 0;
			putship(nstr->cur, &ship);
		}
	}
	return RET_OK;
}

static int
sail_ship(nstr)
	struct	nstr_item *nstr;
{
	extern	s_char *argp[];
	extern	int  aborted;
	s_char	*cp;
	struct shpstr ship;

	while (!aborted && nxtitem(nstr, (s_char *)&ship)) {
		if (!owner || ship.shp_own==0)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
					ship.shp_type, nstr->cur));
			continue;
		}
#ifdef	AUTONAV
		if ((ship.shp_autonav & AN_AUTONAV) &&
				!(ship.shp_autonav & AN_STANDBY)) {
			pr(fmt("Ship #%d has other orders!\n",
				ship.shp_uid));
			continue;
		}
#endif	AUTONAV

		pr(fmt("Ship #%d at %s ", ship.shp_uid,
			xyas(ship.shp_x,ship.shp_y,ship.shp_own)));
		cp = getpath(argp[2],ship.shp_x,ship.shp_y,0,0,0);
		if (!aborted) {
			bzero(ship.shp_path, sizeof(ship.shp_path));
			strncpy(ship.shp_path, cp, sizeof(ship.shp_path)-2);
			putship(nstr->cur, &ship);
		}
	}
	return RET_OK;
}

sail()
{
	extern	s_char *argp[];
	s_char	*cp;
	struct	nstr_item nstr;

	if (!snxtitem(&nstr, EF_SHIP, argp[1]))
		return RET_SYN;
	cp = argp[2];
	if ( (*argp[0]=='q')/*qsail command*/ || (cp && *cp=='q') ) {
		return(show_sail(&nstr));
	} else if ( *argp[0]=='u' /*unsail command*/ || (cp && *cp=='-')) {
		return(unsail_ship(&nstr));
	} else
		return(sail_ship(&nstr));
}
#endif	SAIL
