#ifndef lint
static char *RCSid = "$Header: rea.c,v 1.8 90/03/19 11:06:29 mr-frog Exp $";
#endif

/*
 * rea.c
 *
 * read from telegram file
 * modified to use stdio -- no sense in having
 * too many syscalls
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "deity.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/file.h>

rea()
{
	extern s_char *argp[];
	extern	s_char *telnames[];
	register s_char *p;
	register s_char *mbox;
	struct	telstr tgm;
	FILE   *telfp;
	int     teles;
	int     size;
	int     nbytes;
	s_char    buf[4096];
	int     lasttype;
	int     lastcnum;
	time_t  lastdate;
	int     header;
	int	filelen;
#ifdef WIRE
	s_char	kind[80];
#endif /* WIRE */
#ifdef MERC
	natid	nat;
	int	n;
	int	num;
#endif

#ifdef WIRE
        bzero(kind,80);
        if (*argp[0] == 'w') {
           sprintf(kind,"announcement");
           if (god && argp[1] != 0) {
                if ((n = natarg(argp[1], "")) < 0)
                        return RET_SYN;
                num = n; }
           else {
                num = cnum;  }
          mbox = wirebox(num); }
        else {
           sprintf(kind,"telegram");
           if (god && argp[1] != 0) {
                if ((n = natarg(argp[1], "")) < 0)
                        return RET_SYN;
                num = n; }
           else {
                num = cnum;  }
          mbox = mailbox(num); }
#else
#ifdef MERC
        if (god && argp[1] != 0) {
                if ((n = natarg(argp[1], "")) < 0)
                        return RET_SYN;
                num = n;
        } else
                num = cnum;
        mbox = mailbox(num);
#else
	mbox = mailbox(cnum);
#endif
#endif /* WIRE */
	if ((telfp = fopen(mbox, "r+")) == 0) {
		logerror("telegram file %s", mbox);
		return RET_FAIL;
	}
	teles = 0;
	fseek(telfp, 0L, 0);
	size = fsize(fileno(telfp));
more:
	lastdate = 0;
	lastcnum = -1;
	lasttype = -1;
	while (fread((s_char *) &tgm, sizeof(tgm), 1, telfp) == 1) {
		if (tgm.tel_length < 0) {
			logerror("bad telegram file header in %s", mbox);
			break;
		}
		header = 0;
		if (tgm.tel_type != lasttype || tgm.tel_from != lastcnum)
			header++;
		if (abs((int)(tgm.tel_date - (long)lastdate)) > 60)
			header++;
		if (header) {
			pr("> ");
			lastcnum = tgm.tel_from;
			lasttype = tgm.tel_type;
			pr(fmt("%s ", telnames[tgm.tel_type]));
			if ((tgm.tel_type == TEL_NORM) ||
			    (tgm.tel_type == TEL_ANNOUNCE)) {
				pr(fmt("from %s, (#%d)",
				       cname(tgm.tel_from),
				       tgm.tel_from));
			}
#ifdef GODNAMES
			if (tgm.tel_type == TEL_BULLETIN){
				pr(fmt("from %s, (#%d)", cname(tgm.tel_from), tgm.tel_from));
			}
#endif /* GODNAMES */
			pr(fmt("  dated %s", ctime(&tgm.tel_date)));
			lastdate = tgm.tel_date;
		}
		while (tgm.tel_length > 0) {
			nbytes = tgm.tel_length;
			if (nbytes > sizeof(buf)-1)
				nbytes = sizeof(buf)-1;
			(void) fread(buf, sizeof(s_char), nbytes, telfp);
			buf[nbytes] = 0;
			pr(buf);
			tgm.tel_length -= nbytes;
		}
		pr("\n");
		teles++;
	}
	p=NULL;
#ifdef MERC
	if (teles > 0 && cnum == num) { /* } */
#else
	if (teles > 0) {
#endif
		if (teles == 1) {
			if (chance(0.25))
				p = "Forget this one? ";
			else
				p = "Shall I burn it? ";
		} else {
			if (chance(0.25))
				p = "Into the shredder, boss? ";
			else
				p = "Can I throw away these old love letters? ";
		}
#ifdef MERC
		if(god)
			p = getstarg(argp[2], p);
		else
			p = getstarg(argp[1], p);
#else
		p = getstarg(argp[1], p);
#endif
		if (p && *p == 'y') {
			if (!file_lock(fileno(telfp))) {
				fclose(telfp);
				return RET_SYS;
			}
			if ((filelen = fsize(fileno(telfp))) > size) {
				pr("Wait a sec!  A new telegram has arrived...\n");
				/* force stdio to re-read tel file */
				(void) fflush(telfp);
				(void) fseek(telfp, (long)size, L_SET);
				size = filelen;
				(void) file_unlock(fileno(telfp));
				goto more;
			}
#ifdef sys5
                        /* I don't have ftruncate, so here's my stand in */
                        {
                                FILE *holdf;
                                holdf=fopen(mbox,"w+"); /* I hope this kills */
                                rewind(telfp);
                                fclose(holdf);
                        }
#else
			ftruncate(fileno(telfp), 0);
#endif /* sys5 */
			(void) file_unlock(fileno(telfp));
		}
	}
	if (teles <= 0) {
#ifdef WIRE
#ifdef MERC
		if(cnum == num)
			pr(fmt("No %ss for you at the moment...\n",kind));
		else
                        pr(fmt("No %ss for %s at the moment...\n", kind,
			       cname(num)));
#else
		pr(fmt("No %ss for you at the moment...\n",kind));
#endif
#else
#ifdef MERC
		if(cnum == num)
			pr("No telegrams for you at the moment...\n");
		else
                        pr(fmt("No telegrams for %s at the moment...\n",
			       cname(num)));
#else
		pr("No telegrams for you at the moment...\n");
#endif
#endif /* WIRE */
	}
/*	else
		NAT_DELTA(nat_tgms, cnum, -teles); */
	(void) fclose(telfp);
	return RET_OK;
}
