#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/payo.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * payo.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

#ifdef TRADESHIPS
payo()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	nships;
	struct	nstr_item ni;
	struct	natstr *natp;
	struct	shpstr ship;
	struct	mchrstr *mp;
	int	vec[I_MAX+1];
	int	dist;
	float	cash=0.0;
        extern  int   trade_1_dist;     /* less than this gets no money */
        extern  int   trade_2_dist;     /* less than this gets trade_1 money */
        extern  int   trade_3_dist;     /* less than this gets trade_2 money */
        extern  float trade_1;          /* return on trade_1 distance */
        extern  float trade_2;          /* return on trade_2 distance */
        extern  float trade_3;          /* return on trade_3 distance */
        extern  float trade_ally_bonus; /* 20% bonus for trading with allies */
        extern  float trade_ally_cut;   /* 10% bonus for ally you trade with */


	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;

	nships = 0;
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (!owner || ship.shp_own == 0)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
				ship.shp_type, ni.cur));
			continue;
		}
		mp = &mchr[ship.shp_type];

		if (!(mp->m_flags & M_TRADE))
			continue;

		if (nships++ == 0) {
			if (god)
				pr("own ");
			pr("shp#     ship type       x,y    $$\n");
		}
		if (god)
			pr(fmt("%3d ", ship.shp_own));
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", mchr[ship.shp_type].m_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", ship.shp_x,
			ship.shp_y, cnum)));

		getsect(ship.shp_x,ship.shp_y,&sect);
		natp = getnatp(sect.sct_own);

		dist = mapdist(ship.shp_x, ship.shp_y,
			ship.shp_orig_x, ship.shp_orig_y);

		if (dist < trade_1_dist)
			cash = 0;
		else if (dist < trade_2_dist)
			cash = (1.0 + trade_1*((float)dist));
		else if (dist < trade_3_dist)
			cash = (1.0 + trade_2*((float)dist));
		else
			cash = (1.0 + trade_3*((float)dist));

		cash *= mp->m_cost;
		cash *= (((float)ship.shp_effic) / 100.0);

		if (sect.sct_own != ship.shp_own)
			cash *= (1.0 + trade_ally_bonus);
		pr(fmt("$%6.2f\n",cash));
	}
	if (nships == 0) {
		if (argp[1])
			pr(fmt("%s: No ships(s)\n", argp[1]));
		else
			pr(fmt("%s: No ships(s)\n", ""));
		return RET_FAIL;
	}
	if (nships == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr(fmt("%s: No ship(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d ship%s\n", nships, splur(nships)));
	return RET_OK;
}
#endif /* TRADESHIPS */
