/*
 * misc.h
 *
 * defines which don't really belong anywhere,
 * but have to go somewhere!
 *
 * $Revision: 1.4 $ $Date: 89/06/01 14:18:30 $
 */

#include <sys/types.h>

#ifdef hpux
#include <string.h>
#else
#include <strings.h>
#endif

#include "options.h"

#define MAXNOC		20

#define WORLD_X		64
#define WORLD_Y		64

typedef u_char natid;		/* also change NSC_NATID in nsc.h */
typedef	short coord;		/* also change NSC_COORD in nsc.h */
typedef char s_char;		/* change to signed char for aix */

/*
 * watch it; your compiler might not like this.
 * If you think this is bogus, look at /usr/include/struct.h
 */
#define	OFFSET(stype, oset) ((int)(&(((struct stype *)0)->oset)))
#define	SETOFF(sinst, oset) ((char *) (sinst) + (oset))

#ifndef bit
#define	bit(x)		(1<<(x))
#endif

#define minutes(x)	(60*(x))
#define hours(x)	(60*60*(x))
#define days(x)		(60*60*24*(x))

typedef void (*voidfunc)();

	/* return codes from command routines */
#define	RET_OK		0   /* command completed sucessfully */
#define	RET_FAIL	1   /* command completed unsucessfully [?] */
#define	RET_SYN		2   /* syntax error in command */
#define	RET_SYS		3   /* system error (missing file, etc) */

/*
 * references to library functions which aren't related to any
 * particular object, and are of general interest
 */
extern	long random();

extern	double dmax();
extern	double dmin();

extern	char *fmt(/* char * */);
extern	char *copy();
extern	char *numstr();
extern	char *esplur();
extern	char *splur();
extern	char *iesplur();
extern	char *plur();
extern	char *getstarg();
extern	char *getstring();

/*
 * frequently used libc functions
 */

extern	char *malloc();
extern	char *calloc();

extern	char *ctime();
extern	char *strncpy();
extern	char *strcpy();
#ifndef NeXT
extern	char *index();
extern	char *rindex();
#endif /* NeXT */

extern	time_t time();
extern	double atof();
