#include <stdio.h>
#include "dumpstr.h"

/* ____________________________________________________________________
**|                                                                    |
**| sample - Sample program to illustrate use of ParseDumpLine().      |
**|                                                                    |
**| 1. Type 'make' to compile this program together with parsedump.c   |
**| 2. Run empire                                                      |
**| 3. Use 'sample' to filter 'dump', 'vdump', 'pdump', or 'sdump'     |
**|    output (e.g., "vdump * | sample").                              |
**|____________________________________________________________________|
*/

main(argc,argv)
int argc;
char *argv[];
{
    char buf[1024]; /* this should be fairly big */
    FILE *infile;

    if (!argv[1] || !*argv[1]) infile = stdin;
    else {
	if (!(infile=fopen(argv[1],"r"))) {
	    fprintf(stderr,"can't open \"%s\"\n",argv[1]);
	    exit(1);
	}
    }

    while (fgets(buf,1024,infile)) {

	char *ptr = (char *)ParseDumpLine(buf);
	if (ptr) switch (*ptr) {

	case LAND: {
	    _sctstr *s = (_sctstr *)ptr;
	    printf("%c @%d,%d %d%% mob=%d owner=%d distpath=%s\n",
		   s->des, s->x, s->y, s->effic, s->mobil, s->owner, 
		   s->dist_path);
	    break;
	}

	case SHIP: {
	    _shpstr *s = (_shpstr *)ptr;
	    printf("(%s) %s #%d @%d,%d %d%% mob=%d owner=%d civ=%d mil=%d\n",
		   s->class, s->type, s->id, s->x, s->y, s->effic, s->mobil,
		   s->owner, s->amt.c, s->amt.m);
	    break;
	}

	case SPY: {
	    _spystr *s = (_spystr *)ptr;
	    printf("%s #%d @%d,%d %d%% mob=%d owner=%d age=%d\n",
		   s->type, s->id, s->x, s->y, s->effic, s->mobil, s->owner,
		   s->age);
	    break;
	}

	case ARMY: {
	    _armstr *s = (_armstr *)ptr;
	    printf("%s #%d @%d,%d %d%% mob=%d owner=%d\n",
		   s->type, s->id, s->x, s->y, s->effic, s->mobil, s->owner);
	    break;
	}

	case PLANE: {
	    _plnstr *s = (_plnstr *)ptr;
	    printf("%s #%d @%d,%d %d%% mob=%d owner=%d\n",
		   s->type, s->id, s->x, s->y, s->effic, s->mobil, s->owner);
	    break;
	}

	}
    }
}
