.TH Command VDUMP
.SY "vdump <SHIPS|VEHICLES>"
The `\*Qvdump\*U' command outputs all available information on
some or all of the ships, tanks, trains, balloons, and shuttles 
that you own. 
`\*QVdump\*U' gathers all of the information that you normally obtain
using `ship', `cargo', `order', et al, and outputs it in a concise,
easy-to-parse format.  Each vehicle's information 
is printed on one very long line, with fields separated by single spaces.
.s1
This command is designed to be used for input to an empire tool
such as \*Qve\*U.
.s1
In the syntax of the `vdump' command:
.NF

<SHIPS|VEHICLES>   is the list of vehicles for which you want
                   information (see \*Qinfo syntax\*U).

.FI
A typical usage might be:
.s1
.EX vdump 1/2/3
.NF
Mon Aug 24 09:35:54 1992
   DUMP VEHICLES
own class id type name x y eff mob tech fleet convoy planes tanks alt_depth
orbit air destx desty autonav standby aboard c_amt m_amt u_amt s_amt g_amt p
_amt i_amg d_amt b_amt f_amt o_amt l_amt h_amt r_amt v_amt
9 "ship" 1 "destroyer" "" -85 11 100 72 109 B _ 0 0 0 "" 0 -85 11 0 1 -1 0 5
0 0 39 4 19 0 0 0 33 0 0 0 0 0
4 "ship" 2 "ore ship" "" 30 4 100 72 86 c _ 0 0 0 "" 0 30 4 0 0 -1 30 5 0 0 
0 25 0 591 0 167 0 0 0 0 0
7 "ship" 3 "torpedo boat" "" -31 -1 63 72 3500 _ _ 0 0 0 "" 0 -31 -1 0 0 -1 
0 10 0 17 6 20 0 0 0 15 0 0 0 0 0
    3 vehicles
.FI
.s1
(Although there appear to be more, there are actually only seven lines 
of output: 3 header lines, 3 data lines, and a summary line.)
The first few lines of output consist of the current time and date,
a title line explaining what is being dumped, and a header line
that identifies each of the fields for the data lines that will
follow.  All subsequent lines that do not begin with whitespace
contain vehicle data, one line per vehicle.
.s1
The rules for parsing the field label header are data lines are simple.
Whitespace in the field label header separates the data labels.
Whitespace in the data lines separates the data fields.
.s1
All numeric value fields begin with a digit if positive, or a
minus sign followed by digits if negative.  Any field that starts 
with a double quote defines a string; such fields end with another 
double quote.  A double quote followed immediately by another double
quote defines an empty (null) string.  All single-character fields
and will contain an underscore if the character is to be interpreted 
as a blank.
.s1
.NF
  field label  type      description
  ___________  ________  ________________________________________________

  own          number    vehicle owner's country number (reported to 
                         DEITYs only)

  class        string    vehicle class ("tank", "ship", etc)

  id           number    vehicle id

  type         string    vehicle type ("battleship", "airship", etc)

  name         string    vehicle name ("USS Arizona", etc)

  x y          numbers   current coordinates

  eff          number    current efficiency

  mob          number    current mobility

  tech         number    vehicle's tech level

  fleet        char      fleet id

  convoy       char      confoy id

  planes       number    number of aircraft/missiles aboard
  
  tanks        number    number of tanks aboard

  alt_depth    number    normally zero, except for:
                          balloons:   0=land, 1=low, 2=high altitude
                          submarines: 0=surface, 1=periscope, 2=deep
                          shuttles:   altitude

  orbit        string    shuttle orbit info (e.g., "18j/72")   

  air          number    amount of air/gas remaining

  destx desty  numbers   destination sector if under orders

  autonav      number    0/1 flag showing if vehicle is on orders

  standby      number    0/1 flag showing if vehicle is on standby

  aboard       number    -1 if vehicle is NOT being transported aboard 
                         another vehicle; otherwise, this is the ID of
                         the vehicle doing the transporting

  c_amt ...    number    amount of commodity 'c' (civs) aboard, etc
.FI
.s3
See also : dump, pdump, sdump, rdump, odump
