.TH Command TRACK
.SY "track <SHIPS|VEHICLES|SECTS> [on|off|all|ident|hostile]"
Normally, when an aircraft flies through a ship or sector's radar
coverage area, the radar site owner receives a telegram stating
when, where, and with what radar contact was made.  The default condition 
of any newly-created radar site is to report all contacts, which can 
rapidly lead to massive numbers of telegrams
if there is a lot of flight activity in the area.  By restricting
reports to only those contacts that are identifiable or hostile, 
you can reduce contact telegrams to only those of selective importance.
.s3
The `\*Qtrack\*U' command lets you adjust the aircraft radar tracking
ability of your individual ships, vehicles, and radar stations.  By
using `\*Qtrack\*U', you can individually turn sites on or off, or
cause them to report all contacts, only positively identifiable contacts,
or only hostile identifiable contacts.
.s3
`\*QTrack\*U' takes two parameters.  The first parameter can be either
a standard sector specifier (a coordinate, range, radius, or realm), or
a standard ship/vehicle specifier (a ship id, id list, fleet id, ship
name, or '*').  You can generate a report for either land radar sectors
or for vehicle radar, but not a combined report (i.e., if you specify
a sector coordinate or realm, it will report only the sectors themselves,
not any vehicles in that sector).
.s3
The second parameter either sets the tracking mode, or causes the
current modes to be listed:
.NF

     on      turn aircraft tracking on
     off     turn aircraft tracking off
     host    track hostile idents
     iden    track idents
     all     track all aircraft

     .       report station status

.FI
.s3
.EX track * . ?eff=100
veh#                     x,y      eff  rng  tracking
  30       terminator  -13,-41   100%    1  OFF LINE
  31  fishing trawler   43,-1    100%    6  all contacts
 109            oiler   -7,1     100%    1  OFF LINE
 170  assault vehicle   -1,-33   100%    1  OFF LINE
 180  armored carrier    2,-34   100%    1  all contacts
 181  armored carrier   -9,-31   100%    1  all contacts
 514       battleship  -47,9     100%    4  HOSTILE idents only
 559        destroyer  -19,49    100%    1  HOSTILE idents only
    8 vehicles
.s3
See also : radar, satellite
