.TH Command "Sub"
The \*Qsub\*U command is used to control a sub's depth
and report critical information about the state of the ship.
In its simplest form, \*Qsub\*U shows ship status:
.EX sub 3
.NF
sub#       type          x,y   flt  eff depth mil food gun she pet mob   air
   3 submarine           0,2        37% surf    2   18   2   7   7  72  3000
1 sub
.FI
.s1
.in \w'shiptype\0\0'u
.L sub#
each sub's id number
.L type
the type of sub; \*Qsubmarine\*U, \*Qnuclear sub\*U, etc
.L x,y
the sub current location (relative to your capital)
.L flt
the fleet designation letter (set by \*Qfleetadd\*U command)
.L eff
the sub's efficiency
.L depth
the sub's current depth (surface, periscope, or deep)
.L mil
the number of military on board
.L food
the amount of food on board
.L gun
the number of guns aboard
.L she
the number of shells aboard (2 shells make 1 torpedo)
.L pet
the amount of petrol aboard
.L mob
the amount of available mobility
.L air
the amount of oxygen aboard
.in
.s1
By adding a depth specifier, you can control the sub's depth
in the water.  Each change in depth costs 1 unit mobility.
Valid depths are "surface", "periscope", and "deep".  
For example,
.EX sub * p
.NF
submarine #3 submerging to periscope depth in 0,2.
submarine #17 submerging to periscope depth in 20,-12.
submarine #18 submerging to periscope depth in 21,-11.
3 subs
.FI
.s1
Submarines running on the surface are no different from any
other ship.  They can fire guns and torpedos, perform lookouts
and radar, be seen by coastwatch, etc.  A sub must be surfaced
in order to move into a harbor or trade center.
.s1
Subs running at periscope depth are somewhat more limited in their
capabilities.  For example, they can fire torpedos, but cannot fire 
guns, have limited radar, and will not be spotted by coastwatch.  They
cannot board or be boarded, tend or be tended, load or be unloaded.  A 
foreign 'look' will only report the sighting of an unidentified periscope 
in the water.  Sonar, however, will identify the sub and its owner.
.s1
Subs running deep have the same limitations as those at periscope depth,
plus some new ones.  They can fire torpedos, for example, but they have 
very poor aim.  They cannot do a lookout, but do have limited radar 
capability.  Foreign sonar will not identify the sub's owner, and neither
can the sub's sonar positively identify anybody else.  
Deep subs also have the advantage of being
able to navigate through mined waters (they move below the mines).
.s1
Submerged submarines gain efficiency at 1/4 the rate they would
gain in a harbor.  On the surface, they gain efficiency at the same
rate as any other ship (1/3 the harbor rate).
.s1
Sub-hunting aircraft on bombing missions have a 10% chance of not 
being able to locate subs at periscope depth.  If they are lucky enough 
to spot one, bombing accuracy is somewhat reduced, making the submerged
sub a difficult target.  Deep subs are an even more difficult target;
bombers have only a 45% chance of spotting them, and bomb accuracy is
even more severely reduced.
.s1
In the retaliatory action following a torpedo attack, a sub at periscope
depth has only a 5% chance of avoiding depth charges; a sub running
deep has a 50% chance.
.s3
See also : coastwatch, fire, load, lookout, mine, navigate, tend, 
torpedo, show
