.TH Concept "Sector Types"
.NF +0.2i
 GEOLOGIC BASICS      TRANSIT/COMMUNICATIONS      MILITARY/RESEARCH
 .  sea               )  radar installation       t  technical center
 ^  mountain          =  bridge span              r  research center
 s  sanctuary         *  airport/plane factory    l  library/school
 -  wilderness        h  harbor/shipyard          n  nuclear plant
 +  desert                                        v  chemical plant
 #  forest                                        f  fortress
 ,  swamp             INDUSTRIES                  e  enlistment center
                      d  defense plant            
                      i  shell industry           
 DESTRUCTION          m  iron mine                CIVIL/COMMERCIAL
 !  ruin              g  gold mine                b  bank
 \\  wasteland         u  uranium mine             x  trade center
                      o  oil field                p  park
                      j  light manufacturing      c  capitol
                      k  heavy manufacturing      w  warehouse
                      y  lumber mill
                      %  petrol refinery
                      z  tank factory
                      a  agribusiness
.FI
.s3
.s1
.ce
GEOLOGIC BASICS
.s3
The geologic sector types represent the pristine, natural regions
that initially make up the planet.  While many of these areas can
be colonized, redesignated, and developed for other purposes, their
geologic types forever underlie their developed designations.
(For example, if you designate a bank in a wilderness, you get 
exactly that -- the sector remembers that underneath it all, it
is still wilderness terrain.  You can later redesignate the 
bank back into wilderness or into anything else that can be built
on wilderness -- but you could not redesignate the bank to be a
forest, since forest represents a different basic geologic sector.
.s3
SEA - Sea sectors form natural barriers that can only be crossed 
by ships (made in harbors, below), planes, or bridges (also below).
You can not designate anything to be sea nor can sea be designated 
to be anything else.
.s1
MOUNTAIN - Mountain sectors form another natural barrier that cannot
be redesignated; however, they can be occupied and moved through 
(at great expense in terms of mobility units).
.s1
SANCTUARY - Sanctuary sectors are created when a new nation is created.
They are inviolate in that no one can fire at them or attack them.
This protection ends when the new country first moves out of the sanctuary
(called \*Qbreaking sanctuary\*U); the sector then becomes a capital.
NOTE: in games with multiple sanctuaries per country ALL sanctuaries
become capitals when any one does!  Once your sanctuaries are gone,
they are gone forever -- you cannot create new ones.
.s1
WILDERNESS - Much of the world is wilderness at the beginning of 
the game.  Wilderness has no particular attributes; you can move 
into it if unoccupied, thereby making it your territory, but will 
probably want to designate it as something else once you own it.
A notable feature of pristine wilderness is that fertility slowly
increases over time, until eventually the wildflowers grow into
might oaks and the sector becomes a forest.
.s1
DESERT - Desert is similar to wilderness, except that it can be
home to only a limited variety of sector types.
.s1
FOREST - Forest is essentially a vastly overgrown wilderness.
In its pristine state, forest fertility slowly increases over time.
Movement through forests is difficult, although road and rail 
improvements can alleviate this problem.  Also, only a limited
variety of sector types can be developed in forest, with the most
notably useful being the lumber mill.  Through its production of
wood materials, the lumber mill slowly reduces the forest fertility
until it is eventually reclassified as a wilderness.
.s1
SWAMP - Swamps represent any shallow water sector -- swamps,
coral reefs, marshland, etc.  They possibly may be inhabited, and 
cannot be navigated by ships.
.s3
.ce
TRANSIT AND COMMUNICATIONS
.s1
RADAR - Radar stations can scan the surrounding
area (up to 6 units away for 100% efficiency) and generate
a radar plot identifying sector types at distances up to 1/3
their range and ships up to their full range.
.s1
BRIDGE SPAN - A bridge span is the suspended part of a bridge that
crosses water sectors.  They are built and supported by infrastructure
bridge heads in almost any sector, and are much like highways except
for three things:
.br
(1) Bridge spans provide food through fishing,
(the fertility can be thought of as fish-count).
.br
(2) Bridge spans must maintain at least 20% efficiency or else they
collapse.
.br
(3) If the bridge head supporting a particular bridge span is 
lost (through inefficiency) or destroyed, the bridge will collapse.
.s3
AIRFIELD - Airplanes can only be built in airports and most can
take off and land only at airports (though some can take off
and land in other sectors and yet others can take off and land 
on aircraft carriers -- see `ship-types' for details) 
Airfields also provide facilities to construct, load, and
unload balloons and space shuttles.
.s1
HARBOR - Harbors combine shipyard facilities and docks.
Construction materials are converted into ships
and the ships can be loaded and unloaded in the harbor,
(see \*Qinfo load\*U).
No ships are constructed until the \*Qbuild\*U command is given,
(see \*Qinfo build\*U).
Harbors also provide facilities to construct, load, and
unload balloons.
.s1
.ce
CIVIL AND COMMERCIAL
.s3
BANK - Banks are used for smelting and storing gold bars.  
They include a smelter to refine gold dust into gold bars.
While the bars are stored in the bank the busy little bankers 
invest them and return a profit on their use.
Banks are of the Fort Knox variety; they are more impervious to shelling
than any other sector and military in them fight twice as hard
against attack as those in industries.
Banks are also particularly adept at moving gold bars around;
bars are moved and stored in groups of four thus fewer mobility units
are required to move a gold bar from a bank than anywhere else.
.s3
TRADE CENTER - Trade centers are your own personal
international supermarkets.  They are where you put items 
up for sale for specific buyers, and also where you buy items 
that visiting sellers have to offer.  Almost all items, ranging 
from single bushels of food to the latest high-tech military
hardware, change hands in trade centers.  (Ships are often the 
only exception, and can be traded while at sea.)
.s1
PARK - Parks are provided to increase the happiness of the populous.
Parks require construction materials to provide maintenance 
services and add to a nation's \*Qhappiness\*U level.
The conversion of \*Qraw\*U materials takes place automatically
at a rate dependent on the efficiency of the sector,
the presence of the required materials, and the number of workers in
the sector.
.s1
CAPITAL - Capitals are the source of bureaucracy time units (BTU's).
They accrue in proportion to the efficiency
of the capital and the number of civilians at work in it.
If a country has a 100% efficient capital with 100
civilians in it BTU's will accrue at the rate of 4 per hour,
(assuming half-hour time units).
Most commands use up BTU's,
(see \*Qlist of commands\*U for numbers of BTU's used per command).
A nation may only have one active capital at a time
(although many sectors may be designated as capitals).
If an active capital is captured by an attack a new one
must be designated by the victim in order to be able to collect BTU's.
The capture of a capital will result in the loss of money from
the victim nation (loss of tax records, federal reserves, etc).
Capitals are twice as efficient at defending
against attack as other sectors (except fortresses).
Use the capital command to make a capital the active one.
.s1
WAREHOUSE - Warehouses are used to store shells,
guns, iron, gold dust, food, oil, light construction materials, and
heavy construction materials.  Moving the above out of a 
warehouse only takes one tenth the mobility cost it normally would.
Note: warehouses are often used as distribution centers.
.s1
.ce
INDUSTRIES
.s3
DEFENSE - In defense plants construction materials are turned into guns.
The conversion of \*Qraw\*U materials into guns
takes place automatically at a rate dependent on
the efficiency of the sector,
the presence of the required materials,
the technology level of the country,
and the number of workers in the sector.
See \*Qinfo products\*U for information on the materials required to
produce guns.
.s1
SHELL INDUSTRY - These sectors are similar to defense
plant sectors except they turn construction materials into
shells.
The conversion of \*Qraw\*U materials takes place automatically
at a rate dependent on the efficiency of the sector,
the presence of the required materials,
the technology level of the country,
and the number of workers in the sector.
See \*Qinfo products\*U for information on the materials required.
One shell is used each time you fire,
(except for submarines which use three shells to make one torpedo).
.s1
IRON MINE - Mines produce iron ore by digging it out of the ground.
The rate at which it is produced is dependent on three factors;
the efficiency of the mine,
the number of civilians working in the mine,
and the mineral sample for the sector (\*Qmin\*U on the census report).
Iron is a \*Qrenewable\*U resource; i.e. digging up iron does not
deplete the mineral content of the sector.
.s1
GOLD MINE - Gold mines are similar to ordinary
mines, (above), except that they produce gold dust.
The rate at which it is extracted is dependent on three factors;
the efficiency of the sector,
the size of the labor force in the sector,
and the gold sample for the sector (\*Qgmin\*U on the census report).
The raw gold dust can be transported to any sector but if it is left
in a bank sector it will be refined into bars automatically .
Gold is a non-renewable resource; i.e. extracting the gold depletes
the gold content of the sector.
.s1
URANIUM MINE - Uranium mines are very similar to gold
mines, (above), except that they produce radioactive materials.
The rate at which it is extracted is dependent on three factors;
the efficiency of the sector,
the size of the labor force in the sector,
and the uranium content of the sector
(\*Quran\*U on the census report).
Uranium is a non-renewable resource; i.e. extracting it depletes
the content of the sector.
.s1
OIL - Oil fields produce oil by sucking it out of the ground.
The extraction of oil takes place automatically
at a rate dependent on the efficiency of the sector,
the oil content of the sector (\*Qoil\*U on the census report),
the technology level of the country,
and the number of workers in the sector.
Oil is a \*Qnon-renewable\*U resource; i.e. extracting oil
depletes the oil content of the sector.
.s1
LIGHT - Light manufacturing plants produce light construction materials
from iron.
This production takes place automatically
at a rate dependent on the efficiency of the sector,
the iron in the sector,
the technology level of the country,
and the number of workers in the sector.
.s1
HEAVY - Heavy manufacturing plants produce heavy construction materials
from iron.
This production takes place automatically
at a rate dependent on the efficiency of the sector,
the iron in the sector,
the technology level of the country,
and the number of workers in the sector.
.s1
LUMBER - Lumber industry sectors represent the logging operations, mills,
and lumber yards which to produce wood materials.  Lumber mills can be 
constructed only in forests, and production takes place automatically at a 
rate dependent on the efficiency of the sector, the sector's fertility,
the country's technology level, and the number of workers in the sector.
.s1 
REFINERY - Refineries produce petroleum by processing oil.  
This production takes place automatically
at a rate dependent on the efficiency of the sector,
the number of workers in the sector, 
and  the technology level of the country.
.s1
TANK FACTORY - These are factories that produce tanks and 
armored vehicles.  You use the \*Qbuild\*U command to construct
specific types of vehicles from available construction materials.
.s1
AGRIBUSINESS - These sectors are large farms and provide food.
Agribusiness sectors produce as much as five times as much food
as other sectors.
The harvesting takes place automatically
at a rate dependent on the efficiency of the sector,
the fertility of the sector (\*Qfert\*U in the census),
the education level of the country,
and the number of workers in the sector.
See \*Qinfo products\*U for details.
.s3
.ce
MILITARY AND RESEARCH
.s3
TECHNOLOGY - Technical centers are bastions
of \*Qpure\*U technology research,
which is to say universities with massive defense department grants.
They turn construction materials
into technological advances thereby raising the technology
level of the country (which affects gun ranges, pollution, etc.).
The conversion of \*Qraw\*U materials takes place automatically
at a rate dependent on the efficiency of the sector,
the presence of the required materials,
the education level of the country,
and the number of workers in the sector.
.s1
RESEARCH - The research lab is a bastion of \*Qpure\*U medical research,
which is to say it is a large university
with massive March-of-Dimes funding.
The research lab turns construction materials into medical
discoveries which raise the research level of the country and
help retard the spread of disease, (usually caused by the pollution
from technical centers).  Research also greatly contributes in the
fight against disease by improving the ability of chemical plants
to produce plague vaccine.
The conversion of \*Qraw\*U materials takes place automatically
at a rate dependent on the efficiency of the sector,
the presence of the required materials,
the education level of the country,
and the number of workers in the sector.
.s1
LIBRARY/SCHOOL - The library/school sector is the foundation
of a country's educational structure.
They use up construction materials to produce units of education
which raise the educational
level of the country (which affects the efficiency of research and
technology sectors).
The conversion of \*Qraw\*U materials takes place automatically
at a rate dependent on the efficiency of the sector,
the presence of the required materials,
and the number of workers in the sector.
.s1
NUCLEAR - The nuclear lab is a bastion of applied technology,
which is to say it is an immense underground building filled with
evil geniuses playing Adventure on huge computers.
The nuclear lab turns construction materials into nuclear weapons.
No devices are constructed until the \*Qbuild\*U command is given,
(see \*Qinfo build\*U).
.s1
CHEMICAL PLANT - The chemical plant turns research into reality by
distilling ordinary food and petroleum products into vaccine,
which represents a wide range of miracle drugs ranging from 
lifesaving medicines to powerful toxins used in chemical warheads.
The conversion of \*Qraw\*U materials into vaccine takes place 
automatically at a rate dependant on the efficiency of the sector, 
the presense of the required materials, the research level of
the country, and the number of workers in the sector.
.s1
FORTRESS - Fortress sectors have many special characteristics;
you can fire guns from fortresses,
whenever an attack is launched from a fort or on
a fort the military in the fort are stronger than military
in any other type of sector by an amount proportional to
the efficiency of the fort. e.g. 100 military in a wilderness
attacking a 100% efficient fort that has 25 military
gives even odds; see \*Qinfo attack\*U for details.
.s1
ENLISTMENT - The enlistment sector is the boot camp of Empire.
It converts civilians into military, once the efficiency level
has been raised to 60%.
Unlike the other production sectors,
it uses only military as a workforce,
and converts civilians in the sector into military.
.s3
.ce
DESTRUCTION
.s3
WASTELAND - This is the result of the explosion of a nuclear device.
Depending on the game configuration, wastelands may be uninhabitable
for anywhere from just a few updates to forever.  Wasteland may, 
in time, revert back to a useful pristine geologic sector type.
.s1
RUIN - A ruin is a sector that has been reduced to rubble.
You cannot intentionally designate a ruin; the designation
comes automatically if a sector ever sustains damage that
exceeds 3 times its current efficiency.  Ruins produce nothing,
and are of little use.  Continued damage will cause a ruin's
efficiency to INCREASE; as a ruin becomes more "efficient",
it takes longer and longer to dismantle and convert into
something more useful.
.s3
See also : designate, ruins
