.TH Concept Altitude and Orbit
.s3
Yes, Virginia, there is an atmosphere.  And, as in the real world,
if you loft things up into it, and if you put them high enough, they 
will stay there.
.s3
Through some strange, unknown physical anomaly, the toroidal form 
of the empire world has long been known to have gravitational 
characteristics similar to a sphere.  While many a student has 
scratched his head trying to comprehend the wierd physical nature of 
the planet, early astronomers and aeronautical engineers were quick 
to realize that space flight would be a snap, and learned to exploit
its simple (mostly integer) laws.
.s3
\*QAltitude\*U in Empire is represented by integer values ranging
from 0 to 127, where each step represents roughly 10000 feet, 2 miles,
or 3 km -- however you prefer to think of it.  The atmosphere (in 
which falling things have a tendency to burn up) extends up to 
altitude 32; useful gravitational effects extend up to altitude 127.
Beyond 127 lies the great, black, endless, scary void called "space".
.s3
Normal Empire aircraft are generally restricted to flight at altitudes 
up to 5 or so; by including "^" values in flight paths, you can cause 
planes to change altitude (see `\*Qinfo flightpath\*U').
.s3
Higher altitudes are the realm of space vehicles -- satellites and 
shuttles.  With sufficient angular velocity (speed), and neglecting
atmospheric friction, any vehicle placed at a specific given high 
altitude will tend to remain at that altitude for a very long period 
of time.  These velocity/altitude combinations are called `\*Qorbits\*U'.
.s3
By strange coincidence, at the maximum altitude of 127, the velocity 
necessary to remain in orbit exactly matches the rotational surface 
velocity of the planet itself.  Thus, any vehicle placed at altitude
127 will forever remain in a fixed position over a specific spot 
on the planet.  Also, by another strange coincidence, atmospheric
friction forces become negligable at this point, and the orbit will
never decay.  In other words, a vehicle placed at altitude 127 will
stay over the same sector forever.
.s3
At lower altitudes, in order to maintain position, angular velocity
must be increased.  After a lifetime spent throwing things from very high
places, the famous physicist "Sid" Euphemism derived his First Law
of Things That Go Fast and Do Not Fall:
.NF

    "Any object will stay aloft of its own accord if: At the edge 
    of Scary Space (127), it has a velocity is 0 sector per update;
    At the edge of Our Atmosphere (32), it has a velocity of ETU 
    sectors per update.  All points betwixt and between are linear."

.FI
Many years passed, and people turned their attention away from
physical laws and toward strange works of music, fancy architecture,
ornate clothing, and writing bedtime stories.  Sid's Law remained 
undisputed, but also untested, until the early 17th century, when
at the age of 4, the child genius Little "Al" Kielbasa postulated 
the existance of atmospheric friction and its effect on objects
moving in accordance with Sid's Law:
.NF

    "The air and other stuff way up high, where Sid said stuff would
    fly forever, it hits the flying stuff like wind and makes it slow 
    down kinda fast."

.FI
A few years later, after learning how to count, Al refined his postulate
into his now-famous Law of Degrading Orbits:
.NF

    "At the edge of the atmosphere (32), an orbiting body will fall
    ETU/2 altitude levels per update.  Near the edge of space (126),
    an orbiting body will fall 1 altitude level per update.  The 
    distance fallen at altitude levels in between varies linearly
    between 1 and ETU/2.  A body in the geosynchronous orbit at the 
    edge of space (127), will lose no altitude forever.  Of course,
    really light things may be exceptions to this rule."

.FI
Orbits in Empire are expressed as "<velocity><direction>/<altitude>".
The <velocity> and <direction> indicate the ground distance and 
direction that the vehicle will move at the next update.  
The <altitude> indicates, obviously, the altitude.
.s3
See also : build, planes, satellite, nuke-types,
