.TH Command NAME
.SY "name <CLASS> <ID> <NAME>"
The name command lets you assign names to your ships, tanks, balloons,
trains, and spies.  Explicit or wildcarded names can subsequently be 
used in place of ship, vehicle, and spy ID number arguments in future
commands.  For example, to get a report of ships whose names start with
"Big", you could specify:
.NF

[21:255] Command : ship Big* n
shp#   ship type        name         x,y   sct  eff civ mil pet mob tech
   1 cargo ship       Big Mama     -10,2    h  100%   1   0  47  72
   3 cargo ship       Big Hummer   -10,2    h  100%   1   0  49  72
2 ships

.FI
The syntax for assigning names is pretty straightforward.
For the <CLASS> argument, you must specify the type of object being
named, i.e., "ship", "tank", "balloon", "train", or "spy".
.s3
The <ID> argument is the ship, vehicle, or spy id, or a "*" to select
all items you own of that particular object class, or a sector or
sector range to select all items you own of that class that are within
a specific region.  The <ID> can also be the current name of the object,
if it already has a name.  You can also optionally add additional 
constraints such as "?convoy=A" to additionally refine your selection.
.s3
The <NAME> is any string of up to 11 characters in length.  If the
name string has embedded blanks (for example, "USS Royal"), the entire
string should be enclosed in double quotes.  To remove a name from an 
object, name it "~" (tilde).
.s3
.NF
[##:##] Command: name ship 1 Subsucker
[##:##] Command: name spy 4 "James Bond"
[##:##] Command: name ship Subsucker ~
.FI
