.TH Command HUNT
.SY "hunt <SPIES> <SECTORS> [none|capture|kill]"
The `hunt' command instructs your military to intensively search
specified sectors for foreign spies and report who they are able
to find, and then, if you wish, attempt to capture or erradicate 
the vermin.  Search cost is 0.1 mobility per mil involved in the
search.
.s3
The <SPIES> argument specifies exactly who you are looking for.
You can use the wildcard "*" to search for all spies, or a spy's
name or id, or a slash-separated list of selected spy ids.  
Conditionals can be used to restrict the search to spies owned
by a specific country.
.s3
The <SECTORS> argument specifies where to conduct the search.
You must own all the sectors involved, and they must contain
some military.  Half of the military in each sector take
part in the search; the chance of success of finding spies in 
a sector increases as more military become involved in the search.
.s3
Spies use their ingenuity to try to blend in with the populace.
The odds of finding a spy in a highly civilian-populated sector can
be much less than finding him in a sparsely-populated sector.
Specifically, the odds of a spy being found depend on number
of military conducting the search, civilian population density, 
sector efficiency, and the level of military intelligence compared
to the spy's own cunning:
.NF

     odds = ( (10*mil) / (civs+1) )
              * (sector.effic/100)
              * ( (sector.edu+20) / (spy.edu+20) )

.FI
.s3
An optional third argument lets you specify what action to take 
when a spy is found.  Actions are `capture', `kill', or `none';
leaving the argument unspecified is equivalent to `none'.
.s3
Once he has been found, the odds of capturing a spy are 
directly proportional to the number of mil involved in the search:
.NF

     odds = (mil/150) * (sector.effic/100)
     if odds > 0.95, odds = 0.95

.FI
When a spy is captured, his mobility and happiness are reset to 
zero.  The spy undergoes a $100 brainwashing program, and comes
out loyal to your country with an efficiency level of 10%.
The retraining program has about a 10% suicide rate.
.s3
Killing a spy is an easier, cheaper, and often more effective 
way to purge foreign agents from your territory.
A successful kill costs only $5 in mop-up expense and paperwork,
and the odds of killing a spy are twice as good as capturing a spy:
.NF

     odds = (mil/75) * (sector.effic/100)
     if odds > 0.95, odds = 0.95

.FI
.s3
See also : spy












