.TH Concept Happiness
The happiness level of an Empire country is determined by
the presence of park sectors in the following way.
Whenever a park sector is updated and there are the proper amounts
of raw materials (usually light construction materials and money --
see \*Qinfo products\*U for exact figures),
those materials are turned into \*Qhappy strollers\*U.
The ratio of happy strollers to population can be found in the
\*Qversion\*U command.
.s3
The happiness level is actually a moving average,
with the past happiness being weighted somewhat more
than the current production.
One large production of happiness will not cause the happiness level
to jump by a large amount.
Rather, it will affect the happiness level for days to come.
If no happiness is produced,
then within a few days to a week,
the country's happiness will have dropped close to zero.
.s3
To predict happiness production, the following equations can 
be used:
.NF

             {       old_edu_level+10 }
             { 1.5 - ---------------- } * happystrollers_produced
hap_yield =  {       old_edu_level+20 }
             ----------------------------------------------------
                          (population + 1) / hap_pop


                 (old_hap_level * hap_avg) + (hap_yield * etus)
new_hap_level =  ----------------------------------------------
                                (hap_avg + etus)


The following values can be found using the `version' command:

  `etus'    is the number of etus per update.

  `hap_pop' is a population per happystroller ratio.
            A typical value is 5000.

  'hap_avg' defines the time interval over which happiness is
            averaged.  A typical value is 48 time units.

.FI
.s3
Happiness is required for countries which have any sort of technology
or education at all, with greater levels being required as
the expectation (and tech/edu levels) of the populace increases.
A country with an unhappy population can expect a decrease in the
\*Qwork\*U of some sectors.
.s3
The \*Qnation\*U command will display, among other things, your current
happiness level.
.s3
See also : education, innards, nation, products, research, technology
