.TH Concept Flightpath
All commands which fly airplanes require that you specify a flightpath.
In its simplest form, a flightpath is simply a string of standard 
empire movement directions (g, y, u, j, n, and b) terminated by an `h'.
.s1
To make specification less tedious, time consuming, and prone to error,
flightpath legs can also be autorouted by specifying waypoint and/or
destination sector coordinates.  
.s1
The flightpath string can consist of one or more normal empire path 
directions, waypoint sector coordinates, route display (?) 
and delete (d) options, nops (;), autorouter terrain restriction 
specifiers ([sectortypes]), backtrack-to-home orders (.), and 
altitude changes (^<digit>).
.NF

    <directions>   standard movement directions

    <x>,<y>        autoroute to waypoint

    ^<alt>         change altitude to <alt>

    h              END OF FLIGHT

    [<secttypes>]  set autoroute terrain restrictions

    .              fly back to starting point (backtrack)

    ?              show flightpath string so far

    *              strafe, or drop bomb/payload

    @<routename>   fly named route

    d<count>       delete last <count> chars from flightpath

    ;              no-op (can be used along with blanks to 
                   separate commands)

.FI
.s1
SPECIFYING THE FLIGHTPATH
.s3
You can specify some or all of the path on the command line, and
you will be continually prompted to add to the path until
you eventually specify an `h'.  The prompt shows you current
path length, location, and altitude.  Any or all of these can be 
concatenated together to form routing orders.  For example:
.NF

.EX fly 170 . -97,-15
No escorts...

<0: -97,-15 @ 1> yg^4          <-- move 'yg', then climb to alt 4

<2: -100,-16 @ 4> -95,-15      <-- autoroute to -95,-15
-100,-16 to -95,-15: jjn

<5: -95,-15 @ 4> g^3gnjj       <-- move 'g', climb to 3, move 'gnjj'

<10: -94,-14 @ 3> ?            <-- show accumulated path, current
Path so far:  yg4jjng3gnjj         location and altitude, and
Currently at: -94,-14              autoroute terrain rules ([]
Current alt:  3                    means all terrain is valid)
Terrain:      []

<10: -94,-14 @ 3> d2           <-- delete last two moves ('jj')

<8: -98,-14 @ 3> -95,-11;uu    <-- autoroute to -95,-11, move 'uu'
-98,-14 to -95,-11: nnn

<13: -93,-13 @ 3> .            <-- return home the way we came
(bbyyyyjjyggjn)                    (altitude changes are ignored)

<26: -97,-15 @ 3> [.]99,-9     <-- autoroute over water to 99,-9
Autorouting restricted to [.] terrain.
-97,-15 to 99,-9: bbbbnb

<32: 99,-9 @ 3> h              <-- END OF FLIGHT

Ending sector is 99,-9
range to final destination is 32

.FI
.s1
The entire above example could be concatenated into one command
(albeit an extreme example) which could then be supplied either 
on the command line as part of the fly command, or to the fly 
command's prompt.
.NF

<0: 2,-32> yg;^4;-95,-15; g^3gnjj; ? d2;-95,-11;uu.;[.]99,-9h
.FI
.s3
You can easily see that, although semicolon delimiters are 
required only when concatenation would otherwise run together 
strings of digits, their liberal use can greatly help make
the flightpath more easily understandable.
.s1
ALTITUDE CHANGES
.s3
Flightpaths can include altitude changes, noted by a `^'
followed immediately by a single digit new altitude.  Each step in 
altitude represents approximately 10,000 feet, 3000 meters, 2 miles, 
or whatever analogy seems appropriate to you.  (Aircraft altitudes
are roughly on the same scale as shuttle and satellite altitudes,
which generally to fly in the vicinity of altitude 100.)
Increases in altitude (climbs) consume time and mobility (but, 
surprisingly, not petrol).  Each step up in altitude is equivalent 
to moving one sector.  Decreases in altitude (descents) are free.
.s3
When the aircraft group at the assembly point at the start of a flight,
they are always at altitude 1.  If you neglect to include altitude
changes in your flight path, the planes will remain at altitude 1 for
the duration of the flight.  The important things to remember are that 
each aircraft has a maximum altitude ceiling (which helps determine which 
aircraft are able to take part in intercept flights), that flak becomes 
substantially weaker at higher altitudes, and that bombing and 
reconnaisance precision decreases with altitude.
.s3
Be aware that altitude often affects the outcome of 
the flight.  Some examples: strafing can be accomplished only
at altitude 1; although bombers are less susceptible to flak at
high altitudes, their aim becomes poorer; low tech interceptors
can't reach high altitude bombers.
.s1
IMPORTANT NOTE
.s3
Unlike some version of Empire, flight paths here always 
specify the COMPLETE FLIGHT of the aircraft from takeoff to landing.  
Any points enroute at which you want to paradrop, bomb, strafe,
etc. must be specified WITHIN THE FLIGHTPATH by using an asterisk `*'.
You can often put multiple asterisks in the 
flightpath, causing the remaining bomb load (or whatever) to be 
evenly divided among the remaining asterisk-marked drop zones.
.s3
See also: fly, bomb, recon, strafe, sweep, paradrop, drop, plane-types
