.TH Concept Education
.sp
The education level of an Empire country is determined by
the output of library/school sectors in the following way.
Whenever a library/school sector is updated
and there are the proper amounts of raw materials
(usually light construction materials and money --
see \*Qinfo products\*U for exact figures),
those materials are turned into \*Qclasses of graduates\*U.
The number of classes of graduates per population unit can be found
by executing the \*Qversion\*U command.
.s3
Education is actually a moving average,
with previous education production being much more heavily weighted
than current production.
This implies that a large production of education today
will not result in a large jump in education levels.
.s3
To predict education production, the following equations can 
be used:
.NF

               graduates_produced
edu_yield =   --------------------
              population / edu_pop


                 (old_edu_level * edu_avg) + (edu_yield * etus)
new_edu_level =  ----------------------------------------------
                               (edu_avg + etus)
            

The following values can be found using the `version' command:

  `etus'    is the number of etus per update.

  `edu_pop' is a population per graduate ratio.
            A typical value is 4000.

  `edu_avg' defines the time interval over which education is 
            averaged.  A typical value is 196 time units.

.FI
.s3
Education is important for both technology and research production.
.s3
The \*Qnation\*U command will display, among other things,
your current education level.
.s3
See also : happiness, innards, nation, products, research, technology
