.TH Command DUMP
.SY "dump [type] <SECTOR|ID#> [filters]"
The `\*Qdump\*U' command outputs all available information on
some or all of the sectors, ships, planes, and vehicles that you own. 
`\*QDump\*U' gathers all of the information that you normally obtain
using `census', `commodity', `level', et al, and outputs it in a concise,
easy-to-parse format.  All information for each sector or vehicle is 
printed on one very long line, with fields separated by single spaces.
This command is designed to be used for input to an empire tool
such as \*Qve\*U.
.s3
`\*QDump\*U' can also be used to produce easy-to-parse radar and 
satellite map information.
.s1
In the syntax of the `dump' command:
.NF

[type]         is the dump type -- one of the following:

               "sector"      dump complete sector information
               "vehicle"     dump info about ships & other vehicles
               "ship"        dump ship information
               "tank"        dump tank information
               "shuttle"     dump space shuttle information
               "train"       dump train information
               "balloon"     dump balloon information
               "spy"         dump spy information
               "plane"       dump aircraft information
               "radar"       dump radar information
               "satellite"   dump satellite map information
	       "map"         dump economic map information
	       "geo"         dump geographic map information

               If the [type] specifier is omitted, the command
               produces standard-version-compatible sector dump
               information.

<SECTOR|ID#>   is the sector, range, realm, or ship/plane/vehicle ID#
               for which you want information (see \*Qinfo syntax\*U).

[filters]      is an optional list of one or more filter characters.
               (These are used ONLY for masking radar and satellite
               map information.)

.FI
A typical usage might be:
.s1
.EX dump -80,-18
.NF
Mon Aug 24 10:14:08 1992
   DUMP SECTOR
own x y des sdes eff mob * min gold fert ocontent uran work avail terr 
civ mil uw food shell gun pet iron dust bar oil lcm hcm rad u_del f_del
 s_del g_del p_del i_del d_del b_del o_del l_del h_del r_del u_cut f_cu
t s_cut g_cut p_cut i_cut d_cut b_cut o_cut l_cut h_cut r_cut dist_path
 dist_x dist_y u_dist f_dist s_dist g_dist p_dist i_dist d_dist b_dist 
o_dist l_dist h_dist r_dist
7 -80 -18 * _ 100 127 . 0 0 94 36 0 100 632 0 940 415 990 200 15 12 31 
0 0 0 1 100 66 0 . . . . . . . . . . . . 0 0 0 0 0 0 0 0 0 0 0 0 b -81 
-17 990 200 15 12 0 0 0 0 1 100 0 0
    1 sector
.FI
.s1
(Although there appear to be more, there are actually only five lines 
of output: 3 header lines, 1 data line, and a summary line.)
The first few lines of output consist of the current time and date,
a title line explaining what is being dumped, and a header line
that identifies each of the fields for the data lines that will
follow.  All subsequent lines that do not begin with whitespace
contain vehicle data, one line per vehicle.
.s1
The rules for parsing the field label header are data lines are simple.
Whitespace in the field label header separates the data labels.
Whitespace in the data lines separates the data fields.
.s1
All numeric value fields begin with a digit if positive, or a
minus sign followed by digits if negative.  Any field that starts 
with a double quote defines a string; such fields end with another 
double quote.  A double quote followed immediately by another double
quote defines an empty (null) string.  All single-character fields
and will contain an underscore if the character is to be interpreted 
as a blank.
.s1
NOTE: Although the "dist_path" field is a string, for backward
compatibility reasons it is NOT surrounded by quote.  As it can
never contain whitespace, this should not present a problem.
.s1
.NF
  field label  type      description
  ___________  ________  ________________________________________________

  own          number    sector owner's country number (reported to 
                         DEITYs only)

  x y          numbers   sector's coordinates

  des          char      sector type ('a', 'h', etc)

  sdes         char      new sector type (if changing designation)

  eff          number    current efficiency

  mob          number    current mobility

  *            char      '*' = occupied, '_' = fully owned

  min          number    mineral resource content

  gold         number    gold resource content

  fert         number    fertility

  ocontent     number    oil resource content

  uran         number    uranium resource content

  work         number    workforce percentage

  avail        number    workforce available

  terr         number    territory id

  civ mil ...  number    number of civs, mil, etc         

  u_del ...    number    delivery thresholds (for uws, etc)

  u_cut ...    number    delivery cutoff level (for uws, etc)

  dist_path    string    distribution path
                         (WARNING: This string is UNQOUTED!)

  dist_x       numbers   distribution target sector
  dist_y

  u_dist ...   number    distribution level (for uws, etc)  

.FI
.s3
See also : pdump, vdump, sdump, rdump, odump
