/*
 * ship.h
 *
 * things having to do with ships
 *
 * from PSL Empire, 1985
 * $Revision: 1.2 $ $Date: 93/07/14 10:08:28 $
 */

#include "nsc.h"
#include "class.h"
#include "equip.h"

/* bit masks for the autonav mode flags */

#define AN_AUTONAV   0x01
#define AN_STANDBY   0x02

/* list of orders to perform for each ship */

#define ORDER_CANCEL 1
#define ORDER_STOP   2
#define ORDER_RESUME 3
#define ORDER_P      4
#define ORDER_ETA    5


/* shp_flags bits */
#define SFB_PAINTED 0  /* camouflage - painted */
#define SFB_COVERED 1  /* camouflage - covered */
#define SFB_RTOFF   2  /* radar tracking turned off */
#define SFB_RTIDENT 3  /* radar trace identifiable aircraft only */
#define SFB_RTENEMY 4  /* radar trace hostile aircraft only */

/* shp_flags masks */
#define SF_PAINTED  bit(SFB_PAINTED)
#define SF_COVERED  bit(SFB_COVERED)
#define SF_RTOFF    bit(SFB_RTOFF)
#define SF_RTIDENT  bit(SFB_RTIDENT)
#define SF_RTENEMY  bit(SFB_RTENEMY)

#define MAXSHPV	12
#define	MAXMCHV 12

struct	shpstr {
	coord	shp_x;		/* x location in abs coords */
	coord	shp_y;		/* y location in abs coords */
	natid   shp_own;	/* owner's country num */
	char    shp_type;	/* ship type */
	char    shp_effic;	/* 0% to 100% */
	char    shp_mobil;	/* mobility units */
	short	shp_sell;	/* pointer to trade file */
	short	shp_tech;	/* tech level ship was built at */
	short	shp_uid;	/* unit id (ship #) */
	char    shp_fleet;	/* group membership */
	char	shp_name[NS_NSIZE]; /* ship name */
	char	shp_convoy;     /* convoy membership */
	char    shp_nplane;	/* number of planes on board */
	char    shp_ntank;      /* number of tanks/vehicles on board */
	char	shp_depth;	/* submarine depth: 0, 1, or 2 */
	u_char	shp_flags;	/* flags (must be same size as sct_flags) */
	short	shp_air;	/* submarine air remaining */
	coord	shp_destx;	/* autonav x-coords */
	coord	shp_desty;	/* autonav y-coords */
	u_char	shp_autonav;	/* autonav flags */
	short	shp_aboard;	/* id of ship carrying this vehicle (or -1) */
	char	shp_odom;	/* fuel usage odometer */
	char    shp_nv;		/* current number of variables */
	u_char	shp_orbit;	/* orbit direction */
	u_char	shp_nmiss;      /* number of missiles aboard */
	u_char	shp_spare2;
	u_char	shp_spare3;
	u_char	shp_vtype[MAXSHPV];
	u_short	shp_vamt[MAXSHPV];
};

struct	mchrstr {
    int		m_class;        /* vehicle classification */
    int		m_lcm;		/* units of lcm to build */
    int		m_hcm;		/* units of hcm to build */
    int		m_wood;		/* units of wood to build */
    int		m_armor;	/* how well armored it is */
    int		m_speed;	/* how fast it can go */
    int		m_visib;	/* how well it can be seen */
    int		m_vrnge;	/* how well it can see */
    int		m_frnge;	/* how far it can fire */
    int		m_glim;		/* how many guns it can fire */
    char 	*m_name;	/* full name of type of ship */
    int		m_tech;		/* tech required to build */
    int		m_cost;		/* how much it costs to build */
    int		m_flags;	/* what special things can this ship do */
    int		m_mpg;		/* miles per gallon factor */
    short	m_maxair;	/* max amt of air sub can hold */
    short	m_maxtnks;	/* max tanks/vehicles it can carry */
    short	m_maxplns;	/* max planes it can carry */
    short       m_maxmiss;      /* max missiles it can carry (NYI) */
    char	*m_terrain;	/* terrain restriction string */
    int         m_maxvol;       /* max cargo volume */
    int         m_maxwt;        /* max cargo weight */
    short       m_equip;        /* how equipped (for planes, etc) */
    u_char 	m_nv;		/* number of variables it can hold */
    u_char 	m_vtype[MAXMCHV];
    u_short 	m_vamt[MAXMCHV];
};

#define M_FOOD	  bit(0)	/* catch that fish! */
#define M_TORP	  bit(1)	/* fire torpedoes */
#define M_DCH	  bit(2)	/* drop depth charges on subs */
#define M_FLY	  bit(3)	/* launch and recover planes/vtol/heli */
#define M_MSL	  bit(4)	/* launch missiles */
#define M_OIL	  bit(5)	/* drill for oil */
#define M_SONAR	  bit(6)	/* locate submarines */
#define M_MINE	  bit(7)	/* drop mines */
#define M_SWEEP	  bit(8)	/* clean up the mines */
#define M_SUB	  bit(9)	/* a submarine */
#define M_SPY	  bit(10)	/* gather intelligence info */
#define M_LAND	  bit(11)	/* allows full landing ability */
#define M_ATV     bit(12)   	/* atv capability */
#define M_VTOL    bit(13)   	/* launch and recover vtol/heli */
#define M_HELI	  bit(14)   	/* launch and recover helicopters only */
#define M_TAC	  bit(15)   	/* transport disassembled aircraft/missiles */
#define M_SALVAGE 0x10000   	/* recovery vessel */
#define M_NUCLEAR 0x20000	/* nuclear (uses rads instead of petrol) */
#define M_GOLD    0x40000	/* dredge gold */
#define M_IRON    0x80000	/* dredge iron */
#define M_URAN    0x100000	/* dredge uranium */
#define M_OILER	  0x200000	/* can tend petrol to other ships */
#define M_SAT     0x400000	/* launch and recover satellites */
#define M_FLAK	  0x800000	/* can fire flak */
#define M_TAAC    0x1000000     /* can transport already-assembled aircraft */
#define M_RADAR   0x2000000     /* has radar */

#define getship(n, p) \
	ef_nbread(EF_SHIP, n, (caddr_t)p)
#define putship(n, p) \
	ef_nbwrite(EF_SHIP, n, (caddr_t)p)
#define seekship(n) \
        ef_seek(EF_SHIP, n)
#define getshipp(n) \
	(struct shpstr *) ef_ptr(EF_SHIP, n)

extern  struct mchrstr mchr[];
extern	int shp_maxno;

double seagun();
char *eta();

