/*
 * sect.h
 *
 * things having to do with sectors
 *
 * from PSL Empire, 1985
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:22 $
 */

/* sector types (must agree with order in dchr, empglb.c) */
#define SCT_WATER	0
#define SCT_MOUNT	1
#define SCT_SANCT	2
#define SCT_WASTE	3
#define SCT_RUIN	4
#define SCT_DESERT	5
#define SCT_FOREST	6
#define SCT_ARCTIC	7
#define SCT_SWAMP	8
#define SCT_RURAL	9
#define SCT_CAPIT	10
#define SCT_HARBR	11
#define SCT_WAREH	12
#define SCT_TRADE	13
#define SCT_AIRPT	14
#define SCT_FORTR	15
#define SCT_NUKE	16
#define SCT_RADAR	17
#define SCT_ENLIST	18
#define SCT_TANK	19
#define SCT_URAN	20
#define SCT_PARK	21
#define SCT_ARMSF	22
#define SCT_AMMOF	23
#define SCT_MINE	24
#define SCT_GMINE	25
#define SCT_AGRI	26
#define SCT_OIL		27
#define SCT_LIGHT	28
#define SCT_HEAVY	29
#define SCT_TECH	30
#define SCT_RSRCH	31
#define SCT_LIBR	32
#define SCT_BANK	33
#define SCT_REFINE	34
#define SCT_CHEM	35
#define SCT_MILL	36
#define SCT_BSPAN	37
#ifdef POWERPLANTS
#define SCT_POWER       38
#ifdef HIGHWAYSECTORS
#define SCT_HIWAY	39
#define SCT_BHEAD	40
#define	SCT_MAXDEF	40	/* highest sector type in header files */
#else
#define SCT_MAXDEF	38
#endif
#else
#ifdef HIGHWAYSECTORS
#define SCT_HIWAY	38
#define SCT_BHEAD	39
#define	SCT_MAXDEF	39	/* highest sector type in header files */
#else
#define SCT_MAXDEF	37
#endif
#endif

/*
**  Underlying geographic terrain types
*/

#define GEO_MASK	7	/* bit mask covering the following values: */
#define	GEO_RURAL	0
#define GEO_DESERT	1
#define GEO_FOREST	2
#define GEO_ARCTIC	3
#define GEO_WATER	4
#define GEO_SWAMP	5
#define GEO_MOUNT	6
#define GEO_MAXDEF	6

/*
**  MAXSCTV defines number of "things" a sector can contain.
**  Each "point" of MAXSCTV costs 32k for 128x128; e.g., MAXSCTV=20
**  uses 655Kb disk space for the commodities alone!
*/

#define	MAXSCTV 24

typedef struct sctstr {
	coord	sct_x;		/* x coord of sector */
	coord	sct_y;		/* y coord of sector */
	natid	sct_own;	/* owner's country num */
	u_char	sct_type;	/* sector type */
	u_char	sct_effic;	/* 0% to 100% */
	u_char	sct_mobil;	/* mobility units */
	u_char	sct_loyal;	/* updates until civilans "converted" */
	u_char	sct_terr;	/* territory id # of sector */
	u_char	sct_geo;	/* geographic (raw) sector type */
	long	sct_distpath;	/* sector distribution deliver path */
	short	sct_elev;	/* elevation/depth */
	short	sct_avail;	/* available workforce for "other things" */
	u_short	sct_flags;	/* misc flags */
        u_char  sct_spare1;
        u_char  sct_spare2;
        u_char  sct_spare3;
	u_char	sct_roadimp;	/* road improvements, 0-100 */
	u_char	sct_railimp;	/* rail improvements, 0-100 */
	u_char	sct_harden;	/* bunker strength, 0-255 */
	u_char	sct_work;	/* pct of civ actually working */
	u_char	sct_newtype;	/* for changing designations */
	u_char	sct_min;	/* ease of mining ore */
	u_char	sct_gmin;	/* amount of gold ore */
	u_char	sct_fertil;	/* fertility of soil */
	u_char	sct_oil;	/* oil content */
	u_char	sct_uran;	/* uranium ore content */
	natid	sct_oldown;	/* old owner of sector (for liberation) */
        u_char  sct_powersrc;   /* dir (0-6) pointing to power source  */
	u_char	sct_nv;		/* current number of variables */
	u_char	sct_vtype[MAXSCTV];
	u_short	sct_vamt[MAXSCTV];
} _sctstr;

/* sct_flag bits */
#define SB_BHEAD    0	/* sect has intrinsic bridge head */
#define SB_PHOLD    1   /* production on hold */
#define SB_ENUKE    2   /* nuclear energy producer */
#define SB_RTOFF    3   /* radar tracking turned off */
#define SB_RTIDENT  4   /* radar tracks identifiable aircraft only */
#define SB_RTENEMY  5   /* radar tracks hostile aircraft only */
#define SB_STARVE   6   /* sector may suffer starvation next update */
#define SB_RADAR    7   /* sector has intrinsic radar */
#define SB_NAMED    8   /* sector has a name */

/* sct_flag masks */
#define S_BHEAD   bit(SB_BHEAD)
#define S_PHOLD   bit(SB_PHOLD)
#define S_ENUKE   bit(SB_ENUKE)
#define S_RTOFF   bit(SB_RTOFF)
#define S_RTIDENT bit(SB_RTIDENT)
#define S_RTENEMY bit(SB_RTENEMY)
#define S_STARVE  bit(SB_STARVE)
#define S_RADAR   bit(SB_RADAR)
#define S_NAMED   bit(SB_NAMED)

typedef struct dchrstr	{
	int	d_mnem;		/* map symbol */
	int	d_prd;		/* product vtype */
	int	d_mcst;		/* movement cost (no improved highways) */
	int	d_mmcst;	/* movement cost (100% improved highways) */
	int	d_pkg;		/* type of packaging in these sects */
	int	d_ostr;		/* offensive strength */
	int	d_dstr;		/* defensive strength */
	int	d_value;	/* resale ("collect") value */
        int     d_poweff;       /* max effic at 0% power */
        int     d_powmax;       /* power req'd at 100% eff */
        int     d_descost;      /* dollar cost to designate */
	double	d_effcost;	/* dollar cost per point of eff gain */
	char	*d_name;	/* full name of sector type */
	int	d_flg;		/* misc flags */
} _dchrstr;

/* d_pkg */
#define	NPKG	0		/* no special packaging */
#define	WPKG	1		/* "warehouse" packaging */
#define	UPKG	2		/* "urban" packaging */
#define	BPKG	3		/* "bank" packaging */

/* d_flg */
#define NAVMASK	  0x03		/* bits 0-1: navigability mask: */
#define	NAVOK	  1		/*    navigable at any efficiency */
#define	NAV_02	  2		/*    requires 2% effic to navigate */
#define	NAV_60	  3		/*    requires 60% effic to navigate */
#define D_GOD	  (1<<2)	/* only a deity can redesignate */
#define D_MKT	  (1<<3)	/* sector is a trading post */
#define D_FLY	  (1<<4)	/* sector is an airfield */
#define D_RAD	  (1<<5)	/* sector is a radar post */
#define D_STD     (1<<6)	/* sect type defines a geographic standard */
#define D_NOLAND  (1<<7)	/* mil can't land there (beachless) */
#define D_NOHEAD  (1<<8)	/* can't build a bridgehead there */
#define D_NOLOAD  (1<<9)	/* can't load/unload there */
#define D_FGROW	  (1<<10)	/* fert grows if sector is idle */
#define D_POWER   (1<<11)       /* sector is a power source */
#define D_GEOBIT  12		/* start bit position for geo build bits: */
#define D_GEOMASK (((1<<(GEO_MAXDEF+1))-1)<<D_GEOBIT) /* mask for following: */
#define	D_RURAL	  ((1<<GEO_RURAL )<<D_GEOBIT) 	      /*  can be in rural */
#define D_DESERT  ((1<<GEO_DESERT)<<D_GEOBIT) 	      /*  can be in desert */
#define D_FOREST  ((1<<GEO_FOREST)<<D_GEOBIT) 	      /*  can be in forest */
#define D_ARCTIC  ((1<<GEO_ARCTIC)<<D_GEOBIT) 	      /*  can be in arctic */
#define D_WATER	  ((1<<GEO_WATER )<<D_GEOBIT) 	      /*  can be in water */
#define D_SWAMP	  ((1<<GEO_SWAMP )<<D_GEOBIT) 	      /*  can be in swamp */
#define D_MOUNT	  ((1<<GEO_MOUNT )<<D_GEOBIT) 	      /*  can be in mntn */

/* d_mnem - Descriptive characters */
#define	DCH_WATER	'.'
#define	DCH_MOUNT	'^'
#define	DCH_WASTE	'\\'
#define DCH_RUIN        '!'
#define DCH_DESERT	'+'
#define DCH_FOREST	'#'
#define DCH_SWAMP	','
#define	DCH_RURAL	'-'
#define	DCH_AIRPT	'*'
#define	DCH_RADAR	')'
#define DCH_ARCTIC	':'
#define	DCH_BSPAN	'='
#define	DCH_REFINE	'%'

#define	DCH_AGRI	'a'
#define	DCH_BANK	'b'
#define	DCH_CAPIT	'c'
#define	DCH_ARMSF	'd'
#define DCH_ENLIST	'e'
#define	DCH_FORTR	'f'
#define	DCH_GMINE	'g'
#define	DCH_HARBR	'h'
#define	DCH_AMMOF	'i'
#define	DCH_LIGHT	'j'
#define	DCH_HEAVY	'k'
#define	DCH_LIBR	'l'
#define	DCH_MINE	'm'
#define	DCH_NUKE	'n'
#define	DCH_OIL		'o'
#define	DCH_PARK	'p'
#define DCH_POWER       'q'
#define	DCH_RSRCH	'r'
#define	DCH_SANCT	's'
#define	DCH_TECH	't'
#define	DCH_URAN	'u'
#define DCH_CHEM	'v'
#define	DCH_WAREH	'w'
#define DCH_TRADE	'x'
#define DCH_MILL	'y'
#define DCH_TANK	'z'

#define	DCH_HIWAY	'{'
#define	DCH_BHEAD	'}'

#define getsect(x, y, p) \
	ef_nbread(EF_SECTOR, sctoff((int) x, (int) y), (caddr_t)p)
#define putsect(p) \
	ef_nbwrite(EF_SECTOR, sctoff((int) (p)->sct_x, \
		(int) (p)->sct_y), (caddr_t)p)
#define getsectp(x, y) \
	(struct sctstr *) ef_ptr(EF_SECTOR, sctoff((int)x, (int)y))
#define getsectid(id) \
	(struct sctstr *) ef_ptr(EF_SECTOR, id)

/* things relating to sectors */
extern	int sctoff();
extern	double landgun();

extern	int sct_maxno;
extern	struct dchrstr dchr[];
