/*
 * news.h
 *
 * everything having to do with empire news
 *
 * includes struct nwsstr, rptstr
 * defines N, NEWS_PERIOD, NUM_RPTS
 *
 * from PSL Empire, 1985
 * $Revision: 1.3 $ $Date: 93/07/30 11:17:33 $
 */

struct	nwsstr {
	natid	nws_ano;	/* "actor" country # */
	char	nws_vrb;	/* action (verb) */
	natid	nws_vno;	/* "victim" country # */
	char	nws_ntm;	/* number of times */
	long	nws_when;	/* time of action */
};

#define	NUM_RPTS	2	/* number of story alternates */

struct	rptstr {
	int	r_good_will;	/* how "nice" the action is */
	int	r_newspage;	/* which page this item belongs on */
	char	*r_newstory[NUM_RPTS];	/* texts for fmt( */
};

	/* news verbs */
#define	N_WON_SECT	1
#define	N_SCT_LOSE	2
#define	N_SPY_SHOT	3
#define	N_SENT_TEL	4
#define	N_SIGN_TRE	5
#define	N_MAKE_LOAN	6
#define	N_REPAY_LOAN	7
#define	N_MAKE_SALE	8
#define	N_OVFLY_SECT	9
#define	N_SCT_SHELL	10
#define	N_SHP_SHELL	11
#define	N_TOOK_UNOCC	12
#define	N_TORP_SHIP	13
#define	N_FIRE_BACK	14
#define	N_BROKE_SANCT	15
#define	N_SCT_BOMB	16
#define	N_SHP_BOMB	17
#define	N_BOARD_SHIP	18
#define	N_SHP_LOSE	19
#define	N_FLAK		20
#define	N_SEIZE_SECT	21
#define	N_HONOR_TRE	22
#define	N_VIOL_TRE	23
#define	N_DISS_GOV	24
#define	N_HIT_MINE	25
#define	N_DECL_ALLY	26
#define	N_DECL_NEUT	27
#define	N_DECL_WAR	28
#define	N_DIS_ALLY	29
#define	N_DIS_WAR	30
#define	N_OUT_PLAGUE	31
#define	N_DIE_PLAGUE	32
#define	N_NAME_CHNG	33
#define	N_DIE_FAMINE	34
#define	N_RIOT		35
#define	N_DOWN_PLANE	36
#define	N_NUKE		37
#define N_FREEDOM_FIGHT	38
#define N_SHOOT_CIV	39
#define N_LAUNCH	40
#define N_SAT_KILL	41
#define N_GIFT		42
#define N_AIDS		43
#define N_HURTS		44
#define N_TAKE		45
#define N_BOARD_TANK	46
#define N_BOARD_BALLOON 47
#define N_BAL_LOSE	48
#define N_TNK_SHELL	49
#define N_TNK_BOMB	50
#define N_BAL_SHELL	51
#define N_BAL_BOMB	52
#define N_TRN_SHELL     53
#define N_TRN_BOMB      54
#define N_BOARD_TRAIN   55
#define N_TRN_LOSE      56
#define N_ASSAULT_FAIL  57
#define N_WON_SECT_TNK	58
#define N_SCT_LOSE_TNK	59
#define N_WON_SECT_BAL	60
#define N_SCT_LOSE_BAL	61
#define N_BUNKER_BOMB   62
#define N_TNK_LAND      63
#define N_SUB_BOMB      64
#define N_WIN_LOTTO     65
#define N_MSL_HIT_SHIP  66
#define N_CAPTURE_SPY   67
#define N_KILL_SPY	68
#define N_KAMIKAZE	69
#define N_SHP_STRAFE	70
#define N_PLN_STRAFE	71
#define N_TNK_STRAFE	72
#define N_BAL_STRAFE	73
#define N_TRN_STRAFE	74
#define N_POP_STRAFE    75
#define N_DOWN_MISSILE  76
#define N_COUP_SUCCESS  77
#define N_COUP_FAILURE  78
#define N_WON_NEW_LAND  79
#define N_INTERCEPT_MIS 80
#define N_INTERCEPT_NUK 81
#define N_OPEN_TRADE    82
#define N_CLOSE_TRADE   83
#define N_EMBARGO	84
#define N_BURNVILLAGE	85
#define N_CAPLOSS	86
#define N_SHUTLAUN	87
#define N_SHUTFAIL	88
#define N_RUIN		89
#define N_TRIBE_WINS    90
#define N_TRIBE_ATTACKS 91
#define N_TRIBE_LOSES   92
#define	N_SPY_SCALPED	93
#define N_SURRENDER     94
#define N_CHARITY       95
#define N_HILLCRASH     96

#define	N_MAX_VERB	96

#define	N_MAX_PAGE	 3

#define	NEWS_PERIOD	days(10) 

#define getnews(n, p) \
	ef_nbread(EF_NEWS, n, (caddr_t)p)
#define putnews(n, p) \
	ef_nbwrite(EF_NEWS, n, (caddr_t)p)
#define getnewsp(n) \
	(struct nwsstr *) ef_ptr(EF_NEWS, n)

extern	struct rptstr rpt[];
