/*
 * misc.h
 *
 * defines which don't really belong anywhere,
 * but have to go somewhere!
 *
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:17 $
 */

#ifdef hpux
/* #pragma HP_ALIGN HPUX_WORD */
#endif

#include <sys/types.h>

#ifdef hpux
#include <string.h>
#else
#include <strings.h>
#endif

/* ________________________________________________________________
**|                                                                |
**| World size and maximum number of countries                     |
**|________________________________________________________________|
*/

#define MAXNOC		70
#define WORLD_X		200
#define WORLD_Y		100

/* ________________________________________________________________
**|                                                                |
**| Define which features you want compiled into the game;         |
**| comment out the features you don't want to include.            |
**|________________________________________________________________|
*/

#define LEARNTECH		/* gain tech from high tech toys */
#define SPREADPLAGUE		/* plague speads on its own */
#define LIFEBOATS		/* include lifeboats */
#define LOTTERY			/* include POGOLOTTO */
#define SPIES			/* game includes spies */
#define RUINS			/* sectors can be reduced to rubble */
/* #define POWERPLANTS          /* game includes powerplant sectors */
/* #define ARMY 		/* include armies (INCOMPLETE CODE) */
#define DAMAGEWORK		/* work percentage can be damaged */

/* Vehicle options */

#define PLANES			/* game includes planes */
#define NUKES			/* game includes nukes */
#define TANKS			/* game includes tanks */
#define BALLOONS		/* game includes balloons */
#define TRAINS		        /* game includes trains */
#define SHUTTLES		/* game includes space shuttles */
#define SHIPSNEEDPET		/* ships need petrol to move */
#define AUTOLOOKOUT		/* nav/autonav reports same-sector ships */

/* Market/Trade options */

#define TRADECREWLESS		/* limit mil to 1 aboard a traded ship */
#define TRADECENTERS		/* use trade centers instead of telemarket */
#define TRADECENTERISAIRPORT    /* can fly in and out of trade centers */
#define TRADEONLYINCENTERS	/* TRADE works only in trade centers, but: */
#define TRADESHIPSANYWHERE	/* ships can be traded anywhere */
/*#define TELEPORTPLANES	/* teleport plane & nuke sales */
/*#define TRADETANKSANYWHERE	/* tanks can be traded anywhere */
/*#define TRADEBALLOONSANYWHERE	/* balloons can be traded anywhere */
/*#define TRADETRAINSANYWHERE	/* trains can be traded anywhere */
/*#define TRADEPLANESANYWHERE	/* planes can be traded anywhere */
/*#define TRADENUKESANYWHERE	/* nukes can be traded anywhere */

/* Flight options */

#define ASSEMBLEANYWHERE  	/* don't have to own assembly point */
#define DROPANY			/* 'airdrop' drops into anyone's sector */
#define USEALLIEDCARRIERS	/* can land on allied carriers */
#define USEALLIEDAIRPORTS	/* can land in allied airports */
/* #define USENEUTRALCARRIERS	/* can land on neutral carriers */
/* #define USENEUTRALAIRPORTS	/* can land in neutral airports */
/* #define USEHOSTILEAIRPORTS	/* can land in hostile airports */
/* #define USEENEMYAIRPORTS	/* can land in enemy (at war) airports */

/* Intercept mission options */

/* #define ALLIEDENCOUNTERS	/* encounter allied aircraft */
#define NEUTRALENCOUNTERS	/* encounter neutral aircraft */
#define HOSTILEENCOUNTERS	/* encounter hostile aircraft */
#define WARENCOUNTERS		/* encounter at-war aircraft */

/* Deliver/Distribute options */

#define DELIVERPEOPLE		/* 'deliver' works with civs & mil */
#define DISTRIBUTEPEOPLE	/* 'dist' & 'thresh' work with civs & mil */

/* Warfare options */

/* #define ATTACKBTUS		/* attacker pays 0.15 btu/defender loss */
/* #define ASSAULTBTUS		/* assaulter pays 0.15 btu/defender loss */
/* #define COASTWATCHRADAR	/* radar has 3.5x coastwatch range */
/* #define SLOWALTCHANGES	/* aircraft climb/descend rate = 1/sector */
/* #define WILDTARGETS		/* `Fire' target can be range, wildcard, etc */
/* #define LISTTARGETS		/* `Fire' lists cannons & targets considered */
/* #define HIGHWAYSECTORS	/* include highway and bridge head sectors */
#define ANYCANFIRE		/* any sector with guns/shells/mil can fire */
#define BUNKERS                 /* game includes bunkers */
#define NEUTRONBOMBS		/* include neutron bombs in the nuke list */
#define GUNTECH        10	/* (20) tech needed to build guns */
#define SHELLTECH      10	/* (20) tech needed to build shells */
#define MODIFYMOBILITY		/* enable highway & rail improvements */
#define AGAINLIMIT 1		/* leave set to 1 until we find a way to 
				   immediately abort a repeating command */

/* ________________________________________________________________
**|                                                                |
**| The maximum size of the trade center file is set by            |
**| the following define.                                          |
**|________________________________________________________________|
*/

#define MAXTRADECENTERS MAXNOC*25	/* trade center file size limit */

/* ________________________________________________________________ 
**|								   |
**| Miscellaneous						   |
**|________________________________________________________________|
*/

typedef u_char natid;		/* also change NSC_NATID in nsc.h */
typedef	short coord;		/* also change NSC_COORD in nsc.h */

/*
 * watch it; your compiler might not like this.
 * If you think this is bogus, look at /usr/include/struct.h
 */
#define	OFFSET(stype, oset) ((int)(&(((struct stype *)0)->oset)))
#define	SETOFF(sinst, oset) ((char *) (sinst) + (oset))

#ifndef bit
#define	bit(x)		(1<<(x))
#define longbit(x)	(long)(1L<<(x))
#endif

#define minutes(x)	(60*(x))
#define hours(x)	(60*60*(x))
#define days(x)		(60*60*24*(x))

typedef void (*voidfunc)();

	/* return codes from command routines */
#define	RET_OK		0   /* command completed sucessfully */
#define	RET_FAIL	1   /* command completed unsucessfully [?] */
#define	RET_SYN		2   /* syntax error in command */
#define	RET_SYS		3   /* system error (missing file, etc) */

/*
 * references to library functions which aren't related to any
 * particular object, and are of general interest
 */
extern	long random();

extern	double dmax();
extern	double dmin();

extern	char *fmt(/* char * */);
extern  char *ovas();
extern	char *copy();
extern	char *numstr();
extern	char *esplur();
extern	char *splur();
extern	char *iesplur();
extern	char *plur();
extern	char *getstarg();
extern	char *getstring();
extern  char *armysizstr();

/*
 * frequently used libc functions
 */

extern	char *malloc();
extern	char *calloc();

extern	char *ctime();
extern	char *strncpy();
extern	char *strcpy();
extern	char *index();
extern	char *rindex();

extern	time_t time();
extern	double atof();
