/*
    $Header: /usr/local/src/et/work/xemp5.0/x/RCS/pager.c,v 5.1 93/03/14 16:35:44 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:35:44 $
    $Author: etienne $
    $Id: pager.c,v 5.1 93/03/14 16:35:44 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	pager.c,v $
 * Revision 5.1  93/03/14  16:35:44  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:26:31  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:00:52  greyhelm
 * Add RCS logging - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include "xextern.h"
#include "func.h"

#define MAX_FUNC 6

/* #define WARP */

struct s_pager
{
	Strings strings;
	char *header;
	char *left_but, *middle_but, *right_but;
	int buttonIDs[3];
	bool first_entry;
	bool buttonsset;
	WinInfo win1, win2;
	bool scrollbar;
	int scrolllines;
	int width;
	int height;
	int lines;
	int lasty, lastx;
	int maxstr;
	void (* proc) ();
	bool select;

	int nr_funcs;
	int *func_startx;
	char *func_names [MAX_FUNC];
	int func_ids [MAX_FUNC];
};

char *GiveIthString ();
char *GetNextStringFlag ();

Pager InitPager (strings, header)
Strings strings;
char *header;
{
	Pager new;

	new = (Pager) doalloc ((unsigned) sizeof (struct s_pager));
	bzero (new, sizeof (struct s_pager));

	new-> header = header;
	new-> select = False;
	new-> first_entry = True;
	new-> win1 = (WinInfo) 0;
	new-> win2 = (WinInfo) 0;
	new-> scrollbar = False;
	new-> nr_funcs = 0;
	new-> func_startx = (int *) 0;
	new-> scrolllines = 0;
	new-> buttonsset = False;
	new-> strings = strings;
	new-> proc = (void (*)()) 0;
	new-> buttonIDs [0] = SELECT;
	new-> buttonIDs [1] = CANCEL;
	new-> buttonIDs [2] = CANCELALL;

	return new;
}

static int FuncAtBottom (pager, event)
Pager pager;
XEvent *event;
{
	int i, y, x;

	if (EventWindow (event) != pager-> win1)
		return NOFUNC;

	if (pager-> nr_funcs == 0 || pager-> func_startx == (int *) 0)
		return NOFUNC;

	if (event-> type != ButtonPress)
		return NOFUNC;

	x = PixelToCharX (event-> xbutton. x) - 1;
	y = PixelToCharY (event-> xbutton. y);

	if (y != pager-> height - 2)
		return NOFUNC;

	for (i = 0; i < pager-> nr_funcs; i++)
	{
		if (x >= pager-> func_startx [i] && x <
		    (pager-> func_startx [i] + strlen (pager-> func_names [i])))
			return (pager-> func_ids [i]);
	}

	return NOFUNC;
}

void FreePager (pager)
Pager pager;
{
	int i;

	if (pager-> win2 != (WinInfo) 0)
		DestroyWindow (pager-> win2);

	if (pager-> win1 != (WinInfo) 0)
		DestroyWindow (pager-> win1);

	for (i = 0; i < pager-> nr_funcs; i++)
		if (pager-> func_names [i] != (char *) 0)
			free ((char *) pager-> func_names [i]);

	if (pager-> func_startx != (int *) 0)
		free ((char *) pager-> func_startx);

	if (pager-> buttonsset)
	{
		if (pager-> left_but != (char *) 0)
			free ((char *) pager-> left_but);
		if (pager-> middle_but != (char *) 0)
			free ((char *) pager-> middle_but);
		if (pager-> right_but != (char *) 0)
			free ((char *) pager-> right_but);
	}


	free ((char *) pager);
}

void SetPagerSelect (pager)
Pager pager;
{
	pager-> select = True;
}

void SetPagerButtonIDs (pager, left, middle, right)
Pager pager;
int left, middle, right;
{
	pager-> buttonIDs [0] = (left == DEFAULTFUNC)   ? SELECT    : left;
	pager-> buttonIDs [1] = (middle == DEFAULTFUNC) ? CANCEL    : middle;
	pager-> buttonIDs [2] = (right == DEFAULTFUNC)  ? CANCELALL : right;
}

void SetInfoOnPager (pager, proc)
Pager pager;
void (* proc) ();
{
	pager-> proc = proc;
}

void SetPagerButtons (pager, left, middle, right)
Pager pager;
char *left, *middle, *right;
{
	if (right == (char *) 0)
	{
		right = middle;
		middle = (char *) 0;
	}

	pager-> left_but = Str (left);

	if (middle != (char *) 0)
		pager-> middle_but = Str (middle);

	pager-> right_but = Str (right);

	pager-> buttonsset = True;
}

void AddPagerFunc (pager, name, id)
Pager pager;
char *name;
int id;
{
	pager-> func_names [pager-> nr_funcs] = Str (Fmt (" %s ", name));
	pager-> func_ids   [pager-> nr_funcs ++ ] = id;
}

static void ShowPagerFuncs (pager)
Pager pager;
{
	int i;

	if (pager-> nr_funcs > 0)
	{
		for (i = 0; i < pager-> nr_funcs; i++)
			PrintMarked (pager-> win1, 1 + pager-> func_startx [i],
						   pager-> height - 2,
						   pager-> func_names [i],
						   BOLD);
	}
}

void RemapPager (pager)
Pager pager;
{
	char *ptr;
	bool flag;
	int i;

	i = 0;
	InitStringList (pager-> strings);
	while ((ptr = GetNextStringFlag (pager-> strings, &flag)) != (char *) 0)
	{
		if (flag)
			PrintAtPixmapB (pager-> win2, 1, i ++, Fmt ("%-*s", 
						pager-> width, ptr));
		else
			PrintAtPixmapN (pager-> win2, 1, i ++, Fmt ("%-*s", 
						pager-> width, ptr));
	}

	FlushWindow (pager-> win2);
}

void ShowPagerLine (pager, y)
Pager pager;
int y;
{
	if (GiveIthFlag (pager-> strings, y))
		PrintAtPixmapB (pager-> win2, 1, y, Fmt ("%-*s",
			pager-> width, GiveIthString (pager-> strings, y)));
	else
		PrintAtPixmapN (pager-> win2, 1, y, Fmt ("%-*s",
			pager-> width, GiveIthString (pager-> strings, y)));

	FlushWindow (pager-> win2);
}

void MapPagerFromTop (pager, win, x, y)
Pager pager;
WinInfo win;
int x, y;
{
	MapPager (pager, win, x, y, True, False);
}

void MapPagerFromBot (pager, win, x, y)
Pager pager;
WinInfo win;
int x, y;
{
	MapPager (pager, win, x, y, False, False);
}

void ChangePagerString (pager, id, newstr)
Pager pager;
int id;
char * newstr;
{
	if (pager-> proc != (void (*) ()) 0)
		ChangeString (pager-> strings, id, Fmt ("%-*.*s [?]",
			pager-> maxstr, pager-> maxstr, newstr));
	else
		ChangeString (pager-> strings, id, newstr);
}
	
void MapPager (pager, win, x, y, fromtop, towm)
Pager pager;
WinInfo win;
bool fromtop;
bool towm;
{
	int j, tmp, min;
	int space, width, height, i;
	int len;
	int id;
	char * ptr;

	if (StringsSize (pager-> strings) == 0)
		AddString (pager-> strings, "(xemp: empty)");
	pager-> maxstr = MaxStringLen (pager-> strings);
	MakeStringIndex (pager-> strings);

	if (pager-> proc != (void (*) ()) 0)
	{
		/* adjust strings */

		InitStringList (pager-> strings);
		while ((ptr = GetNextStringID (pager-> strings, & id))
								!= (char *) 0)
			ChangeString (pager-> strings, id, Fmt ("%-*.*s [?]",
				pager-> maxstr, pager-> maxstr, ptr));
	}

		/* calculate height of window */

	height = StringsSize (pager-> strings);
	if (height > MAP_HEIGHT - 5)
	{
		pager-> scrollbar = True;
		pager-> scrolllines = height - (MAP_HEIGHT - 5);
		height = MAP_HEIGHT - 5;
	}
	pager-> lines = height;

	if (pager-> header != (char *) 0 && ! towm)
		height ++;
	if (pager-> buttonsset)
		height ++;
	if (pager-> nr_funcs > 0)
		height += 2;

		/* calculate width of window */

	width = MaxStringLen (pager-> strings) + 3;

	if (pager-> scrollbar)
		width ++;

	if (pager-> header != (char *) 0)
	{
		tmp = strlen (pager-> header) + 2;
		if (width < tmp)
			width = tmp;
	}
	if (pager-> nr_funcs > 0)
	{
		tmp = 0;
		for (i = 0; i < pager-> nr_funcs; i++)
			tmp += strlen (pager-> func_names [i]);
		
		tmp += (pager-> nr_funcs - 1) * 2;

		if (width < tmp)
			width = tmp;
	}

	if (pager-> buttonsset)
	{
		min = strlen (pager-> right_but);
		tmp = strlen (pager-> left_but);
		if (tmp > min) min = tmp;

		min += 2;

		if (pager-> middle_but != (char *) 0)
		{
			tmp = strlen (pager-> middle_but);
			if (tmp > min) min = tmp + 2;
			min = min * 3 + 6;
		}
		else
			min = min * 2 + 4;
		
		if (width < min)
			width = min;
	}

	height += 1;

	pager-> width = width;
	pager-> height = height;

		/* open windows */

	if (towm)
		pager-> win1 = OpenWinForWM (
			pager-> header,
			x, y,
			width, height,
			CHARS,
			0);
	else
		pager-> win1 = OpenRelToRoot (
			win,
			x, y,
			width, height,
			CHARS,
			0);

	pager-> win2 = OpenWindow (
		pager-> win1,
		0, 
		((pager-> header == (char *) 0 || towm) ? 0 : 1) +
				    ((pager-> buttonsset) ? 1 : 0),
		(pager-> scrollbar) ? (width - 2) : (width - 1),
		pager-> lines,
		CHARS,
		SUBWINDOW,
		pager-> scrolllines);

	SetDefaultCursor (pager-> win1, CR_MENU);
	SetDefaultCursor (pager-> win2, CR_MENU);

	if (pager-> buttonsset)
	{
		j = width - strlen (pager-> right_but) - 4;
		PrintN (pager-> win1, j, 0,
			Fmt ("[%s]", pager-> right_but));

		if (pager-> middle_but != (char *) 0)
		{
			j = width - strlen (pager-> left_but)
				  - strlen (pager-> right_but)
				  - strlen (pager-> middle_but) - 8;

			j = j / 2 + strlen (pager-> left_but) + 2;

			PrintN (pager-> win1, j + 1, 0,
				Fmt ("[%s]", pager-> middle_but));
		}

		PrintN (pager-> win1, 1, 0,
			Fmt ("[%s]", pager-> left_but));
	}

		/* header */

	if (pager-> header != (char *) 0 && ! towm)
		PrintN (pager-> win1, 1, pager-> buttonsset ? 1 : 0,
				Centered (pager-> header, width - 2));

	if (pager-> nr_funcs > 0) /* set starting coordinates of nr_funcs */
	{
		pager-> func_startx = (int *) doalloc (
					pager-> nr_funcs * sizeof (int));

		space = width - 2;
		i = 0;
		if (pager-> nr_funcs == 1)
			pager-> func_startx [0] = space/2 -
					strlen (pager-> func_names [i])/2;
		else
		{
			pager-> func_startx [0] = 0;
			for (i = 0; i < pager-> nr_funcs; i++)
			{
				len = strlen (pager-> func_names [i]);
				space -= len;
				if (i < pager-> nr_funcs - 1)
					pager-> func_startx [i + 1] = len;
			}

			space /= (pager-> nr_funcs - 1);

			for (i = 1; i < pager-> nr_funcs; i++)
				pager-> func_startx [i] +=
					pager-> func_startx [i - 1] + space;
		}
	}


	pager-> lasty = CharToPixelYB (0);
	pager-> lastx = CharToPixelX  (1);

	ShowPagerFuncs (pager);
			
	if (fromtop)
		SetToTop (pager-> win2);
	else
		SetToBot (pager-> win2);
	RemapPager (pager);
	FlushWindow (pager-> win1);
}

static void SavePagerText (pager)
Pager pager;
{
	char *ptr;
	Strings stripped;

	PrintN (pager-> win1, 0, pager-> height - 2, Fmt ("Filename: %*s",
		pager-> width - 10, ""));

	ptr = GetString (pager-> win1, 10, pager-> height - 2,
			pager-> width - 10, GS_TEXT);

	if (ptr != (char *) 0 && *ptr != '\0')
	{
		stripped = StripStrings (pager-> strings);
		if (WriteStrings (stripped, ptr))
			Message (Fmt ("Text saved in %s", ptr));
		else
			Bell ();
		FreeStrings (stripped);
	}
	else
		Message ("Save canceled");

	ClearLine (pager-> win1, pager-> height - 2);
	ShowPagerFuncs (pager);
	FlushWindow (pager-> win1);
}

void LoadPagerText (pager)
Pager pager;
{
	char *ptr;

	PrintN (pager-> win1, 0, pager-> height - 2, Fmt ("Filename: %*s",
		pager-> width - 10, ""));

	ptr = GetString (pager-> win1, 10, pager-> height - 2,
			pager-> width - 10, GS_TEXT);

	if (ptr != (char *) 0 && *ptr != '\0')
	{
		if (LoadEditStrings (pager-> strings, ptr))
			Message (Fmt ("Text loaded from %s", ptr));
		else
			Bell ();
	}
	else
		Message ("Load canceled");

	ClearLine (pager-> win1, pager-> height - 2);
	ShowPagerFuncs (pager);
	FlushWindow (pager-> win1);
	RemapPager (pager);
}

void RemapPagerToWM (pager)
Pager pager;
{
	Strings strings;

	strings = InitStrings ();
	JoinStrings (strings, pager-> strings);
	InitWMPager (strings, pager-> header);
}

int PagerMenuFunc (pager, ret, pcols)
Pager pager;
int *ret;
int *pcols;
{
	char *ptr;
	XEvent event;
	int cx, cy, oldx, oldy;
	int colwidth, choice;
	int cols;

	colwidth = MaxStringLen (pager-> strings);

	MakeStringIndex (pager-> strings);

	cols = (pcols != (int *) 0 ? *pcols : 1);
	if (cols> 0)
		colwidth = (colwidth + cols - 1)/cols;

	for (;;)
	{
		cx = GetPixmapPosX (pager-> win2, pager-> lastx) - 1;
		cx = (cx / colwidth) * colwidth;
		cy = GetPixmapPosY (pager-> win2, pager-> lasty);

		if (cy >= (pager-> lines + pager-> scrolllines) || cy < 0)
		{
			pager-> lasty = 0;
			pager-> lastx = 0;
			continue;
		}

		ptr = GiveIthString (pager-> strings, cy);

		if (cx >= strlen (ptr))
		{
			pager-> lasty = 0;
			pager-> lastx = 0;
			continue;
		}
		break;
	}

	ptr = Fmt ("%.*s", colwidth, ptr + cx);
	if (! pager-> select)
		PrintAtPixmapB (pager-> win2, 1 + cx, cy, ptr);

	SelectEvents (pager-> win2,
			ButtonPressMask |
			ExposureMask |
			PointerMotionMask |
			KeyPressMask);

	FlushWindow (pager-> win2);

#ifdef WARP
	while (XCheckTypedEvent (display, MotionNotify, &event) == True)
		;
#else
	if (pager-> first_entry)
#endif /* WARP */
		WarpPointer (pager-> win2, pager-> lastx, pager-> lasty);


	pager-> first_entry = False;
	for (;;)
	{
		XNextEvent (display, &event);

		if (StandardEvent (& event))
		{
			if (interrupt)
			{
				interrupt = False;
				* ret = CANCELALL;
				return -1;
			}

			continue;
		}

		if ((choice = FuncAtBottom  (pager, &event)) != NOFUNC)
		{
			if (choice == WRITEFUNC)
			{
				SavePagerText (pager);
				continue;
			}
			else if (choice == READFUNC)
			{
				LoadPagerText (pager);
				MakeStringIndex (pager-> strings);
				continue;
			}
			else if (choice == TOWMFUNC)
			{
				RemapPagerToWM (pager);
				choice = CANCELFUNC;
			}

			pager-> lasty = 0;
			pager-> lastx = 0;
			* ret = choice;
			return -1;
		}
			
		switch ((int) event. type)
		{

		case ButtonPress:
			if (EventWindow (& event) == pager-> win1)
				continue;

			if (EventWindow (& event) != pager-> win2)
			{
				pager-> lasty = 0;
				pager-> lastx = 0;
				* ret = CANCEL;
				return -1;
			}
			else
			{
				if (pager-> proc != (void (*)()) 0 &&
						PixelToCharX (event. xbutton. x)
							> pager-> maxstr)
				{
					(* pager-> proc) (10, 10,
						    GiveIthID (pager-> strings,
							  cy));

					WarpPointer (pager-> win2,
						event. xbutton. x,
						event. xbutton. y);

					continue;
				}

				* ret = pager-> buttonIDs [
						event.xbutton. button - 1];

				pager-> lasty = event. xbutton. y;
				pager-> lastx = event. xbutton. x;

				if (! pager-> select)
				{
					ptr = GiveIthString (pager-> strings,
						cy);
					ptr = Fmt ("%.*s", colwidth, ptr + cx);

					PrintAtPixmapN (pager-> win2,
						1 + cx, cy, ptr);
				}

				choice = GiveIthID (pager-> strings, cy);
				if (pcols != (int *) 0)
					* pcols = cx;
				return choice;
			}

		case MotionNotify:

#ifdef WRAP
			while (XCheckTypedEvent (display, MotionNotify,
							& event) == True)
						;
#endif /* WRAP */

			if (EventWindow (& event) != pager-> win2)
				break;

			oldy = cy;
			oldx = cx;

			cy = GetPixmapPosY (pager-> win2,
					event. xmotion. y);
			cx = GetPixmapPosX (pager-> win2,
					event. xmotion. x) - 1;
			cx = (cx / colwidth) * colwidth;

			if (oldy == cy && oldx == cx)
				break;

			if (cy >= (pager-> lines + pager-> scrolllines) ||
								cy < 0)
			{
				cy = oldy;
				cx = oldx;
				break;
			}

			ptr = GiveIthString (pager-> strings, cy);

			if (cx >= strlen (ptr))
			{
				cy = oldy;
				cx = oldx;
				break;
			}

			if (pager-> select)
				continue;

			ptr = Fmt ("%.*s", colwidth, ptr + cx);
			PrintAtPixmapB (pager-> win2, 1 + cx, cy, ptr);

			ptr = GiveIthString (pager-> strings, oldy);
			ptr = Fmt ("%.*s", colwidth, ptr + oldx);
			PrintAtPixmapN (pager-> win2, 1 + oldx, oldy, ptr);

			FlushWindow (pager-> win2);
			break;
		}
	}
}

/* 
 * int PagerSelect (pager, ret)
 * Pager pager;
 * int * ret;
 * {
 * 	XEvent event;
 * 	int choice;
 * 
 * 	SelectEvents (pager-> win2,
 * 			ButtonPressMask |
 * 			ExposureMask |
 * 			PointerMotionMask |
 * 			KeyPressMask);
 * 	
 * 	FlushWindow (pager-> win2);
 * 	WarpPointer (pager-> win2, pager-> lastx, pager-> lasty);
 * 
 * 	for (;;)
 * 	{
 * 		XNextEvent (display, & event);
 * 
 * 		if (StandardEvent (& event))
 * 		{
 * 			if (interrupt)
 * 			{
 * 				interrupt = False;
 * 				* ret = CANCELALL;
 * 				return -1;
 * 			}
 * 		}
 * 
 * 		if ((choice = FuncAtBottom  (pager, &event)) != NOFUNC)
 * 		{
 * 			if (choice == WRITEFUNC)
 * 			{
 * 				SavePagerText (pager);
 * 				continue;
 * 			} else if (choice == READFUNC)
 * 			{
 * 				LoadPagerText (pager);
 * 				continue;
 * 			}
 * 
 * 			pager-> lasty = 0;
 * 			pager-> lastx = 0;
 * 			* ret = choice;
 * 			return -1;
 * 		}
 * 			
 * 	}
 * }
 */

int PagerMenu (pager)
Pager pager;
{
	int func;
	int i;

	i = PagerMenuFunc (pager, & func, (int *) 0);

	if (func != SELECT)
		return -1;
	else
		return i;
}

int ShowPager (pager)
Pager pager;
{
	XEvent event;
	int func;

#ifndef WARP
	if (pager-> first_entry)
#endif /* WARP */
		WarpPointer (pager-> win2, pager-> lastx, pager-> lasty);
	
	pager-> first_entry = False;

	for (;;) 
	{
		XNextEvent (display, & event);

		if (StandardEvent (& event))
			continue;

		if (event. xany. type != ButtonPress)
			continue;

		if ((func = FuncAtBottom (pager, &event)) != NOFUNC)
		{
			if (func == WRITEFUNC)
			{
				SavePagerText (pager);
				continue;
			} else if (func == READFUNC)
			{
				LoadPagerText (pager);
				continue;
			}
			else if (func == TOWMFUNC)
			{
				RemapPagerToWM (pager);
				return CANCELFUNC;
			}

			return func;
		}

		if (EventWindow (& event) == pager-> win1)
			continue;
		else if (EventWindow (& event) == pager-> win2)
		{
			func =  pager-> buttonIDs [event.xbutton. button - 1];
			if (func == SELECT)
				continue;
			return func;
		} else
			return CANCEL;
	}
}

static void ShowCursor (pager, x, y)
Pager pager;
int x, y;
{
	char *ptr;

	ptr = GiveIthString (pager-> strings, y);
	PrintMarked (pager-> win2, x + 1, y, Fmt ("%c", * (ptr + x)), NORMAL);
	FlushWindow (pager-> win2);
}

static void NoCursor (pager, x, y)
Pager pager;
int x, y;
{
	char *ptr;

	ptr = GiveIthString (pager-> strings, y);
	PrintN (pager-> win2, x + 1, y, Fmt ("%c", * (ptr + x)));
	FlushWindow (pager-> win2);
}

static void ShowLine (pager, y)
Pager pager;
int y;
{
	PrintN (pager-> win2, 1, y, GiveIthString (pager-> strings, y));
	FlushWindow (pager-> win2);
}

bool EditPager (pager)
Pager pager;
{
	XEvent event;
	char buffer [BUFSIZ];
	char *ptr;
	KeySym keysym;
	XComposeStatus comp_status;
	int ret;
	int x, y, nx, ny;
	int choice;
	int width, height;

	width = MaxStringLen (pager-> strings);
	height = StringsSize (pager-> strings);

	x = 0;
	y = 0;

	MakeStringIndex (pager-> strings);
	ShowCursor (pager, x, y);

	SelectEvents (pager-> win2,
		ButtonPressMask |
		ExposureMask |
		KeyPressMask);

	for (;;)
	{
		ptr = GiveIthString (pager-> strings, y);

		XNextEvent (display, & event);

		if (ScrollEvent (& event))
			continue;

		switch (event. xany. type)
		{

		case Expose:
			RefreshEvent (& event);
			continue;

		case ButtonPress:
			if ((choice = FuncAtBottom (pager, &event)) != NOFUNC)
			{
				if (choice == WRITEFUNC)
				{
					SavePagerText (pager);
					continue;
				}
				else if (choice == READFUNC)
				{
					NoCursor (pager, x, y);
					FreeStringIndex (pager-> strings);
					LoadPagerText (pager);
					MakeStringIndex (pager-> strings);
					x = 0;
					y = 0;
					ShowCursor (pager, x, y);
					continue;
				}

				NoCursor (pager, x, y);
				return choice;
			}

			if (EventWindow (& event) == pager-> win2)
			{
				nx = PixelToCharX (event. xbutton. x) - 1;
				ny = PixelToCharY (event. xbutton. y);

				if (nx < 0 || nx >= width ||
				    ny < 0 || ny >= height)
					continue;

				NoCursor (pager, x, y);

				x = nx;
				y = ny;

				ShowCursor (pager, x, y);
				continue;
			}

			break;
			/* other button presses are ingnored */
		
		case KeyPress:
				
			ret = XLookupString ( & (event. xkey),
					    buffer,
					    BUFSIZ - 1,
					    & keysym,
					    & comp_status);

			switch ((int) keysym)
			{

			case XK_Left:
				NoCursor (pager, x, y);
				if (-- x < 0)
				{
					x = width - 1;
					if (y > 0)
						y --;
				}
				ShowCursor (pager, x, y);
				continue;

			case XK_Right:
				NoCursor (pager, x, y);
				if (++ x >= width)
				{
					x = 0;
					if (y < height - 1)
						y ++;
				}
				ShowCursor (pager, x, y);
				continue;

			case XK_Down:
				NoCursor (pager, x, y);
				if (++ y >= height)
					y = 0;
				ShowCursor (pager, x, y);
				continue;

			case XK_Up:
				NoCursor (pager, x, y);
				if (-- y < 0)
					y = height - 1;
				ShowCursor (pager, x, y);
				continue;

			case XK_Delete:
				buffer [0] = '\0';
				strncat (buffer, ptr, x);
				strcat (buffer, ptr + x + 1);
				strcat (buffer, " ");
				strcpy (ptr, buffer);
				ShowLine (pager, y);
				ShowCursor (pager, x, y);
				continue;

			case XK_BackSpace:
				if (x == 0)
					continue;
				*(ptr + (-- x)) = ' ';
				ShowLine (pager, y);
				ShowCursor (pager, x, y);
				continue;

			case XK_Return:
			case XK_Linefeed:
				ShowLine (pager, y);
				x = 0;
				if ((++ y) >= height)
					y = 0;
				ShowCursor (pager, x, y);
				continue;
			}

			if (ret == 0)
				continue;

			if (buffer [0] >= ' ' && buffer [0] <= '~')
			{
				* (ptr + x) = buffer [0];
				if ((++ x) >= width)
				{
					x = 0;
					ShowLine (pager, y);
					if (y < height - 1)
						y ++;
				}
				else
					ShowLine (pager, y);
				ShowCursor (pager, x, y);
				continue;
			}

			break;
		}
	}
}

Strings StringsFromPager (pager)
Pager pager;
{
	return pager-> strings;
}

	/*
	 *	It may not be a scroll-window 
	 */

char *InputPagerLine (pager, y)
Pager pager;
int y;
{
	char *ptr;

	Print (pager-> win2, 1, y, Fmt ("%-80s", ""), NORMAL);
	ptr =  GetString (pager-> win2, 1, y, pager-> width - 4, GS_TEXT);

	return ptr;
}

char * PagerMulti (pager, pfunc)
Pager pager;
int *pfunc;
{
	char *ptr;
	static char buf[256];
	int col, num;
	int y;

	ptr = GiveIdString (pager-> strings, 1);

	num = 0;
	while (ScanWord (& ptr, (char *) 0))
		num++;
	
	for (;;)
	{
		col = num;
		y = PagerMenuFunc (pager, pfunc, &col);

		if (* pfunc != SELECT)
			return (char *) 0;
		
		if (y < 0)
		{
			* pfunc = CANCELALL;
			return (char *) 0;
		}

		ptr = GiveIdString (pager-> strings, y) + col;
		if (ptr == (char *) 0 || ! ScanWord (& ptr, buf))
		{
			Error ("Bad Selection ?");
			continue;
		}

		return buf;
	}
}

typedef struct s_pagerlist * PagerList;

struct s_pagerlist
{
	Pager pager;
	PagerList next;
};

static PagerList first_pager = (PagerList) 0;

void AddPagerToWMList (pager)
Pager pager;
{
	PagerList new;

	new = (PagerList) doalloc ((unsigned) sizeof (struct s_pagerlist));

	MakeStringIndex (pager-> strings);
	new-> pager = pager;
	new-> next = first_pager;
	first_pager = new;
}

static void RemovePagerFromWMList (pager)
Pager pager;
{
	PagerList ptr, prv;

	prv = (PagerList) 0;
	for (ptr = first_pager; ptr != (PagerList) 0; ptr = ptr-> next)
	{
		if (ptr-> pager == pager)
		{
			if (prv == (PagerList) 0)
				first_pager = ptr-> next;
			else
				prv-> next = ptr-> next;

			free ((char *) ptr);
			return;
		}

		prv = ptr;
	}
}

static Pager FindPager (pevent)
XEvent * pevent;
{
	PagerList ptr;
	WinInfo win;

	win = EventWindow (pevent);
	if (win == (WinInfo) 0)
		return (Pager) 0;

	for (ptr = first_pager; ptr != (PagerList) 0; ptr = ptr-> next)
	{
		if (win == ptr-> pager-> win1 ||
		    win == ptr-> pager-> win2)
			return ptr-> pager;
	}

	return (Pager) 0;
}

bool PagerEvent (pevent)
XEvent * pevent;
{
	Pager pager;
	int func, y;

	if (pevent-> type != ButtonPress)
		return False;

	pager = FindPager (pevent);
	if (pager == (Pager) 0)
		return False;
	
	if (EventWindow (pevent) == pager-> win2)
	{
		y = GetPixmapPosY (pager-> win2, pevent-> xbutton. y);
		if (y >= (pager-> lines + pager-> scrolllines) || y < 0)
			return True;

		GotoStr (GiveIthString (pager-> strings, y));
		return True;
	}

	if ((func = FuncAtBottom (pager, pevent)) != NOFUNC)
	{
		if (func == WRITEFUNC)
		{
			SavePagerText (pager);
			return True;
		}

		RemovePagerFromWMList (pager);
		FreeStrings (pager-> strings);
		FreePager (pager);
		return True;
	}

	return False;
}

void InitWMPager (strings, name)
Strings strings;
char * name;
{
	Pager pager;
	
	if (StringsSize (strings) == 0)
	{
		FreeStrings (strings);
		return;
	}

	pager = InitPager (strings, name);
	AddPagerFunc (pager, "Write", WRITEFUNC);
	AddPagerFunc (pager, "Done", DONEFUNC);
	MarkAllStrings (strings);
	MapPager (pager, map_win, 0, 0, True, True);
	AddPagerToWMList (pager);
}

	/* ARGSUSED */
void SetEditPager (pager)
Pager pager;
{
}
