/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/util/RCS/ferry.c,v 5.1 93/03/14 16:52:55 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:52:55 $
    $Author: etienne $
    $Id: ferry.c,v 5.1 93/03/14 16:52:55 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	ferry.c,v $
 * Revision 5.1  93/03/14  16:52:55  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:24:11  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:45:54  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "census.h"
#include "sector.h"
#include "ship.h"
#include "func.h"
#include "ferry.h"


static void ShowFerry ();
static void RunFerry ();
static void DoAllFerries ();

Ferry ferry_head = (Ferry) 0;


#ifdef X_VERSION

void FerButton (win, x, y, str)
WinInfo win;
int x, y;
char * str;
{
	PrintMarked (win, x - 1, y, Fmt (" %s ", str), BOLD);
}

bool FerButPressed (x, sx, len)
int x, sx, len;
{
	return ((x >= (sx - 1)) && (x < sx + len));
}

#else	/* TERMC_VERSION */

void FerButton (win, x, y, str)
WinInfo win;
int x, y;
char * str;
{
	PrintMarked (win, x, y, str, NORMAL);
}

bool FerButPressed (x, sx, len)
int x, sx, len;
{
	return ((x >= sx) && (x <= sx + len - 1));
}

#endif	/* VERSION */


 /*****************************************************************************
 *			Fleet commands (to be moved to ship.c)		      *
 ******************************************************************************
		* 	int FleetMinMob (fleet)		*
		*	int FerryMinMob (ferry)		*
		*	bool FleetEmpty (fleet)			*
		*	bool FleetColocated (fleet)		*
		*	Sector FleetSector (fleet)		*
		************************************************/

Sector FerrySector (ferry)
Ferry ferry;
{
	Ship ship;

	if (ferry-> fleet == '\0')
	{
		ship = NrToShip (ferry-> shipnr);
		return World (ship-> x, ship-> y, S_DESIG);
	}
	else
		return FleetSector (ferry-> fleet);
}

int NrShipsInFerry (ferry)
Ferry ferry;
{
	Ship ptr;
	int nr = 0;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = ptr-> next)
		if (sh_fleet (ptr) == ferry-> fleet)
			nr++;
	
	return nr;
}

static void AbortNavigPath (fleet, shipnr, x, y, flag)
char fleet;
int shipnr;
int x, y;
int flag;
{
	Sector sct;

	(void) WaitForPrompt (flag);
	while (EmpireStatus () != E_COMMAND)
	{
		FeedEmpire ("aborted", flag);
		(void) WaitForPrompt (flag);
	}

	sct = World (x, y, S_DESIG);

	if (fleet == '\0')
		MoveShip (NrToShip (shipnr), sct);
	else
		MoveFleet (shipnr, sct);
}

bool NavigPath (fleet, shipnr, x, y, to)
char fleet;
int shipnr;
int * x, * y;
Sector to;
{
	Sector cur, sct, from;
	char * ptr, * ptr2;
	int flag;
	long scan_res;
	bool done;
	char *path, *newpath;
	int i = 0;
	bool do_lookout;
	Neighb neighb;

	flag = util_mode ? DONT_PRINT : PRINT;
	from = cur = World (*x, *y, S_DESIG);

	path = BestSeaPath (from, to);

	if (path == (char *) 0)
	{
		ShowText (Fmt (
			  "Error: couldn't find a sea-path between %s & %s",
			  CrdStr (from), CrdStr (to)));

		ShowText ("Aborted");

		if (! util_mode)
			DrawSector (from);

		return False;
	}

	if (! util_mode)
	{
		if (! AtScreen (*x, *y)) CenterMap (*x, *y);

		MarkPath (from, path);
	}

	path = Str (path);
	ShowText (Fmt ("Moving from %s to %s via %s", 
			  CrdStr (cur), CrdStr (to), path));

	FeedEmpire (Fmt ("navigate %s", (fleet == '\0') ?
		Fmt ("%d", shipnr) : Fmt ("%c", fleet)), flag);
	
	scan_res = (fleet == '\0') ? 
		ShipNrAbils (shipnr) :
		FleetAbils (fleet);

	done = False;
	for (;;)
	{
		if (path [i] == '\0')
			done = True;

		ptr = ReadEmpire (DONT_PRINT);
		if (flag == PRINT)
			PrintAtEmpire (ptr);

		ptr2 = index (ptr, '&');
		if (ptr2 != (char *) 0)
		{
			if (sscanf (ptr2, "& stays in %d,%d", x, y) == 2)
			{
				ShowText (ptr);
				AbortNavigPath (fleet, shipnr, * x, * y, flag);
				if (! util_mode)
					UnmarkPath (cur, path);

				free (path);
				return False;
			}
		}

		ptr2 = index (ptr, '#');
		if (ptr2 != (char *) 0)
		{
			if (sscanf (ptr2, "#%*d stopped at %d,%d", x, y) == 2)
			{
				ShowText (ptr);
				AbortNavigPath (fleet, shipnr, * x, * y, flag);

				sct = cur;
				cur = World (*x, *y, S_DESIG);
				if (fleet == '\0')
					MoveShip (NrToShip (shipnr), cur);
				else
					MoveFleet (fleet, cur);

				if (! util_mode)
				{
					DrawSector (sct);
					UnmarkPath (cur, path + i);
				}

				free (path);
				return False;
			}
		}

		if (StrEQ (ptr, "Sweep..."))
		{
			ShowText (ptr);
			continue;
		}

		if (StrEQ (ptr, "\007Kawhomp! Mine "))
		{
			ShowText (ptr);
			AbortNavigPath (fleet, shipnr, * x, * y, flag);
			if (! util_mode)
			{
				MarkSector (cur);
				UnmarkPath (cur, path + i);
			}
			free (path);
			return False;
		}

		if (sscanf (ptr, "<%*f:%*f: %d, %d> ", x, y) != 2)
		{
			ShowText (ptr);
			AbortNavigPath (fleet, shipnr, * x, * y, flag);
			if (! util_mode)
			{
				MarkSector (cur);
				UnmarkPath (cur, path + i);
			}

			free (path);
			return False;
		}

		if ((scan_res & M_FISH) == M_FISH ||
						    (scan_res & M_OIL) == M_OIL)
			FScanReso ();

		do_lookout = False;

		sct = cur;

		cur = World (*x, *y, S_DESIG);

		if (fleet == '\0')
			MoveShip (NrToShip (shipnr), cur);
		else
			MoveFleet (fleet, cur);


		if (! util_mode)
		{
			DrawSector (sct);
			UnmarkSector (cur);
		}

		if (done)
		{
			FeedEmpire ("h", flag);
			(void) WaitForPrompt (flag);

			free (path);
			return True;
		}


		(void) UpdateSectorDes (cur, '.', False);

		InitNeighbours (cur, & neighb);
		for (sct = cur; NextNeighbour (&sct, S_DESIG, neighb); )
			if (NO_INFO (sct))
				do_lookout = True;

		if (do_lookout)
		{

			ShowText ("Exploring sea......");
			FeedEmpire ("l", flag);
			(void) WaitForPrompt (flag);
			FeedEmpire (((fleet == '\0') ?
				Fmt ("%d", shipnr) : Fmt ("%c", fleet)), flag);

			if (! util_mode)
			{
				MarkSector (cur); /* kludge */
				UnmarkPath (cur, path + i);
			}

			ScanLookout ();
			InitNeighbours (cur, & neighb);
			while (NextNeighbour (&sct, S_DESIG, neighb))
				(void) UpdateSectorDes (sct, '.', False);

			newpath = BestSeaPath (cur, to);
			if (newpath != (char *) 0)
				if (strcmp (newpath, path + i) != 0)
				{
	ShowText (Fmt ("Ajusted path at %d,%d (was %s now moving via %s)",
					*x, *y, path + i, newpath));
					free (path);
					from = cur;
					path = Str (newpath);
					i = 0;
				}

			if (! util_mode)
			{
				MarkPath (cur, path + i);
				UnmarkSector (cur);
				DrawNeighbours (cur);
			}
		}

		FeedEmpire (Fmt ("%c", path [i ++]), flag);
	}
}

 /*****************************************************************************
 *			Miscellaneous Text Functions 			      *
 ******************************************************************************
		*	char * DirectionName (dir)		*
		*	char * TaskName (task)			*
		*	char * CheckFlSh (ferry)		*
		*	char * CheckCargoSct (sct)		*
		*	char * FerryPos (ferry)			*
		************************************************/

static char * DirectionName (ch)
char ch;
{
	switch (ch)
	{

	case 'n':
		return "North";

	case 'e':
		return "East";
	
	case 's':
		return "South";

	case 'w':
		return "WEST";

	default:
		return Fmt ("Unknown dir (%c)", ch);
	}
}
		
static char * TaskName (i)
int i;
{
	switch (i)
	{

	case TASK_OIL:
		return "Oil";

	case TASK_GOTO:
		return "Goto";

	case TASK_EXPLORE:
		return "Explore";

	case TASK_CARGO:
		return "Cargo";
	
	default:
		return "! ERROR !";
	}
}

static char * NameOfFerry (ferry)
Ferry ferry;
{
	switch (ferry-> task)
	{

	case TASK_GOTO:
		return Fmt ("#%d) Goto %d,%d%s",
			ferry-> id,
			ferry-> ax,
			ferry-> ay,
			ferry-> complet ? " <COMPL>" : "");
	
	case TASK_CARGO:
		return Fmt ("#%d) Cargo %d,%d/%d,%d",
			ferry-> id,
			ferry-> ax,
			ferry-> ay,
			ferry-> bx,
			ferry-> by);

	case TASK_OIL:
		return Fmt ("#%d) Oil seek", ferry-> id);

	case TASK_EXPLORE:
		return Fmt ("#%d) Expl to the %s",
			ferry-> id,
			DirectionName (ferry-> expl_dir));

	default:
		
		return Fmt ("#%d) Unknown task",
			ferry-> id);
	}
}
		
char * HasFerry (fleet, ship)
char fleet;
Ship ship;
{
	Ferry ptr;

	for (ptr = ferry_head; ptr != (Ferry) 0; ptr = ptr-> next)
		if ((ptr-> fleet == fleet && fleet != '\0') ||
				(ship != (Ship) 0 && 
					(sh_fleet (ship) == ptr-> fleet ||
					 ptr-> shipnr == sh_nr (ship))))
			return NameOfFerry (ptr);
	
	return "No Ferry";
}


char * CheckFlSh (ferry)
Ferry ferry;
{
	if (ferry-> fleet == '\0')
	{
		if (NrToShip (ferry-> shipnr) == (Ship) 0)
			return "no such ship#";
		else
			return (char *) 0;
	}
	else
	{
		if (! FleetColocated (ferry-> fleet))
			return "not colocated";
		else if (FleetEmpty (ferry-> fleet))
			return "fleet empty";
		else
			return (char *) 0;
	}
}

char * CheckSector (x, y, task)
int x, y;
int task;
{
	Sector sct;

	sct = World (x, y, S_EXIST);

	if (sct == (Sector) 0)
		return "not known";

	if (task == TASK_GOTO)
	{
		if (KNOW_ALL (sct))
		{
			if (s_nds (sct) != 'h')
				return "No harbour";
			else
				return (char *) 0;
		}
		else if (s_des (sct) != '.')
			return "No sea";

		return (char *) 0;
	}

	if (! s_owned (sct))
		return "not yours";

	if (s_nds (sct) != 'h' && task == TASK_CARGO)	
		return "not an harbour";

	return (char *) 0;
}

char * FerryPos (ferry)
Ferry ferry;
{
	Ship ship;
	Sector sct;

	if (ferry-> fleet == '\0')
	{
		ship = NrToShip (ferry-> shipnr);
		if (ship == (Ship) 0)
			return "??";
		else
			return Fmt ("%d,%d", ship-> x, ship-> y);
	}
	else
	{
		sct = FleetSector (ferry-> fleet);
		if (sct == (Sector) 0)
			return "??";
		else
			return Fmt ("%-3d,%3d", s_xcd (sct), s_ycd (sct));
	}
}

 /*****************************************************************************
 *			Data manipulation for ferries			      *
 ******************************************************************************
		*	Ferry	FindFerry (id)		*
		*	Ferry	NewFerry ()		*
		*	void DeleteFerry (id)		*
		****************************************/
			
static Ferry FindFerry (id)
int id;
{
	Ferry ptr;

	for (ptr = ferry_head; ptr != (Ferry) 0; ptr = ptr-> next)
		if (ptr-> id == id)
			return ptr;

	return (Ferry) 0;
}

static Ferry NewFerry ()
{
	int not_used;
	Ferry ptr, new, prev;

		/*
		 *	Find next ferry# & tail
		 *
		 *	Take the highest number which isn't used.
		 *	I don't think (hope) more than 32767 ferries
		 *	will be used.
		 */

	not_used = 1;
	prev = (Ferry) 0;
	for (ptr = ferry_head; ptr != (Ferry) 0; ptr= ptr-> next)
	{
		if (ptr-> id >= not_used)
			not_used = ptr-> id + 1;
		prev = ptr;
	}

	new = (Ferry) doalloc ((unsigned) sizeof (struct s_ferry));
	new-> next = (Ferry) 0;
	new-> active = True;
	new-> id = not_used;

	if (prev == (Ferry) 0)	/* first */
	{
		ferry_head = new;
		new-> prev = (Ferry) 0;
	}
	else
	{
		prev-> next = new;
		new-> prev = prev;
	}

	return new;
}


void DeleteFerry (id)
int id;
{
	Ferry ptr;

	for (ptr = ferry_head; ptr != (Ferry) 0; ptr = ptr-> next)
		if (ptr-> id == id)
		{
			if (ptr-> next != (Ferry) 0)
				ptr-> next-> prev = ptr-> prev;

			if (ptr-> prev != (Ferry) 0)
				ptr-> prev-> next = ptr-> next;
			else
				ferry_head = ptr-> next;

			free ((char *) ptr);
			return;
		}
}

 /*****************************************************************************
 *			Helpfunctions to select sectors / fleets	      *
 ******************************************************************************
		* 	bool SelectFlSh (win, y, ferry)		*
		*	bool SelSector (win, lin, s, def, x, y)	*
		************************************************/

bool SelectFlSh (win, y, ferry)
WinInfo win;
int y;
Ferry ferry;
{
	char * ques, * ans;
	extern int last_layout;

	if (last_layout == FLEET_MODE)
		ques = Fmt ("Which fleet/ship [%c]: ", curfleet);
	else if (curship != (Ship) 0)
		ques = Fmt ("Which fleet/ship [%d]: ", curship-> nr);
	else 
		ques = "Which fleet/ship: ";

	ans = GetQuest (win, y, ques, 3, "a-zA-Z0-9");

	if (ans == (char *) 0 || interrupt)
	{
		Message ("Add Ferry aborted");
		interrupt = False;
		return False;
	}

	if (* ans == '\0')
	{
		if (curship == (Ship) 0 && curfleet == '\0')
		{
			Message ("No current ship to select");
			Bell ();
			return False;
		}
		else
		{
			if (last_layout == FLEET_MODE)
			{
				ferry-> fleet = curfleet;
				ferry-> shipnr = 0;
			}
			else
			{
				ferry-> fleet = '\0';
				ferry-> shipnr = curship-> nr;
			}

			return True;
		}
	}
	else
	{
		if (* ans >= '0' && * ans <= '9')
		{
			ferry-> fleet = '\0';
			ferry-> shipnr = atoi (ans);
			return True;
		}
		else
		{
			if (* (ans + 1) != '\0')
			{
				Message ("Illegal fleet/ship");
				Bell ();
				return False;
			}
			else
			{
				ferry-> fleet = * ans;
				return True;
			}
		}
	}
}

bool SelSector (win, line, str, def, x, y)
WinInfo win;
int line;
char * str;
bool def;
int * x, * y;
{
	char * ans, * quest;

	if (def)
		quest = Fmt ("%s [%s]: ", str, CrdStr (cursct));
	else
		quest = Fmt ("%s: ", str);

	ans = GetQuest (win, line, quest, 9, GS_SECTOR);

	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Cancelled");
		return False;
	}

	if (* ans == '\0')
	{
		if (def)
		{
			* x = s_xcd (cursct);
			* y = s_ycd (cursct);
			return True;
		}
		else
		{
			Message ("No sector selected");
			return False;
		}
	}
	else
	{
		if (sscanf (ans, "%d,%d", x, y) != 2)
		{
			Message ("Illegal sector specification");
			Bell ();
			return False;
		}
		else
			return True;
	}
}

int FerryMinMob (ferry)
Ferry ferry;
{
	Ship ship;

	if (ferry-> fleet == '\0')
	{
		ship = NrToShip (ferry-> shipnr);
		return ship-> mob;
	}
	else
		return FleetMinMob (ferry-> fleet);
}

 /*****************************************************************************
 *				Status of all ferries			      *
 ******************************************************************************
		* void FerryStat (x, y)		*
		********************************/

void ListComplFerries ()
{
	Strings strings;
	Ferry ferry;
	char * pos;

	strings = InitStrings ();
	AddString (strings, "Ferry# Ship(s)             Position");

	for (ferry = ferry_head; ferry != (Ferry) 0; ferry = ferry-> next)
		if (ferry-> task == TASK_GOTO && ferry-> complet)
		{
			pos = CheckFlSh (ferry);

			if (pos != (char *) 0)
				pos = Fmt ("[ Error: %s ]", pos);
			else
				pos = Fmt ("@ %s", FerryPos (ferry));

			AddString (strings, Fmt ("#%-3d   %-20s %s",
				ferry-> id,
				ferry-> fleet == '\0' ? 	
					Fmt ("Ship #%-4d", ferry-> shipnr) :
					Fmt ("Fleet %c  ", ferry-> fleet),
				pos));
		}

	if (StringsSize (strings) == 1)
	{
		Bell ();
		FreeStrings (strings);
		Message ("No completed ferries");
		return;
	}

#ifdef TERMC_VERSION
	ShowStringsInPager (strings, "Completed goto ferries");
#else /* TERMC_VERSION */
	InitWMPager (strings, "completed goto ferries");
#endif /* TERMC_VERSION */
}

void FerryStat (x, y, towm)
int x, y;
bool towm;
{
	Pager pager;
	Strings strings;
	Ferry ferry;
	Ship ship;
	char * pos, * stat, * task;
	Sector sct;
	int i;
	int func;

	if (ferry_head == (Ferry) 0)
	{
		Message ("No ferries initialized");
		Bell ();
		return;
	}

	/*
	 *	Buttons:   [DONE]  	[RUN]		[CHANGE]
	 *
	 *	Ferry#	Flt/Shp    Pos        Status	Task
	 *
	 *	 1      A       -120,-120       OK 	Cargo (10,10 -> 20,20)
	 *	 2	12	  10,10	        OK	Explore (North-East)
	 *	 3	5	  30,20	        OK	Move to (20,10)
	 *	 4	B	  23,54	        DONE	Move to (15,5)
	 *	 5	A	not colocated   ERROR	Cargo (10,10 -> 20,20)
	 *	 6	B	 empty fleet    ERROR	Move to (23,45)
	 *	 7 	56	no such ship#   ERROR	Explore (East)
	 */

	strings = InitStrings ();

	AddStringID (strings, "Ferry# Ship(s) Position        Status  Task",
									-1);

	for (ferry = ferry_head; ferry != (Ferry) 0; ferry = ferry-> next)
	{
		pos = CheckFlSh (ferry);
		if (pos == (char *) 0)
		{
			stat = "OK";

			if (ferry-> task == TASK_GOTO && ferry-> complet)
				stat = "COMPL";

			if (ferry-> fleet == '\0')
			{
				ship = NrToShip (ferry-> shipnr);
				pos = Fmt ("%6d,%-4d", ship-> x, ship-> y);
			}
			else
			{
				sct = FleetSector (ferry-> fleet);
				pos = Fmt ("%6d,%-4d",  s_xcd (sct),
							s_ycd (sct));
			}
		}
		else
			stat = "ERROR";

		switch (ferry-> task)
		{

		case TASK_CARGO:
			if (ferry-> goto_a)
				task = Fmt ("Cargo (%4d,%-4d -> %4d,%-4d)",
					ferry-> ax, ferry-> ay,
					ferry-> bx, ferry-> by);
			else
				task = Fmt ("Cargo (%4d,%-4d -> %4d,%-4d)",
					ferry-> bx, ferry-> by,
					ferry-> ax, ferry-> ay);
			break;
		
		case TASK_GOTO:
			task = Fmt ("Goto  (%4d,%4d)",
				ferry-> ax, ferry-> ay);
			break;

		case TASK_OIL:
			task = "Oil Seek";
			break;

		case TASK_EXPLORE:
			task = Fmt ("Explore (%s)",
					DirectionName (ferry-> expl_dir));
			break;
		}

	/*
	 *      01234567890123456789012345678901234567890123456789
	 *
	 *	Ferry#  Flt/Shp     Pos         Status  Task
	 *      
	 *	 1..6.. A..7... ..-120,-120..   OK 	Cargo (10,10 -> 20,20)
	 *	 5	A	not colocated   ERROR   Cargo (10,10 -> 20,20)
	 */

		AddStringID (strings, Fmt ("%-6d %-7s %-13s   %5s   %s",
			ferry-> id,
			ferry-> fleet != '\0' ?
				Fmt ("%c (%d)", ferry-> fleet,
						NrShipsInFerry (ferry)) :
				Fmt ("%d", ferry-> shipnr),
			pos,
			stat,
			task), ferry-> id);
	}

	if (towm)
	{
#ifdef X_VERSION
		InitWMPager (strings, "List of all ferries");
		return;
#endif
	}

	pager = InitPager (strings, "List of all ferries");

	AddPagerFunc (pager, "Write", WRITEFUNC);
	AddPagerFunc (pager, "Done", DONEFUNC);
	SetPagerButtons (pager, "Change", "Run", "Done");
	SetPagerButtonIDs (pager, NEWFUNC, RUNFUNC, DONEFUNC);

	MapPagerFromTop (pager, map_win, x, y);

	for (;;)
	{
		i = PagerMenuFunc (pager, & func, (int *) 0);
		if (func == CANCEL || func == CANCELALL ||
					func == DONEFUNC || i < 0)
			break;

		ferry = FindFerry (i);

		if (func == RUNFUNC)
		{
			RaiseWindow (map_win);
			DoFerry (ferry-> id);
			LowerWindow (map_win);
		}
		else if (func == NEWFUNC)
		{
			ShowFerry (ferry, x + 3, y + 3, False);
			break;
		}
	}

	FreePager (pager);
	FreeStrings (strings);
}

 /*****************************************************************************
 *		Show & Edit Oil Ferry					      *
 *****************************************************************************/

static int EditOil (win, ferry, init)
WinInfo win;
Ferry ferry;
bool init;
{
		/*
		 0
		 1		-=[ Ferry Utility : OIL ]=-
		 2
		 3	Ferry# 8
		 4
		 5	Fleet: A	(currently @ -12,23)
		 6	ferry Active/NOT Active
		 7
		 8	Min oil to drill for: 1
		 9
		 10	[DONE] [PREV] [RUN] [NEXT] [DELETE]
		 */

	char * ptr;
	bool first_pass;
	int x, y;
	char * ans;

#ifdef lint
	x = y = 0;
#endif
	ClearWindow (win);

	PrintN (win, 1, 1, Centered ("-=[ Ferry Utility : OIL ]=-", 80));

	PrintN (win, 1, 3, Fmt ("Ferry# %d", ferry-> id));

	first_pass = True;
	y = 0;

	do {
			/* Ship / Fleet */

		if (first_pass || y == 5)
		{
			ClearLine (win, 5);

			if (y == 5 || init)
			{
				if (! SelectFlSh (win, 5, ferry))
				{
					Bell ();

					if (init)
					{
						Message ("Add Ferry cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}
			}

			if ((ptr = CheckFlSh (ferry)) != (char *) 0)
				Bell ();

			PrintN (win, 1, 5, Fmt ("%-30s %-40s",
				ferry-> fleet == '\0' ?
					Fmt ("Ship %d", ferry-> shipnr) :
					Fmt ("Fleet %c", ferry-> fleet),
				ptr == (char *) 0 ?
					Fmt ("[now @ %s]", FerryPos (ferry)) :
					Fmt ("[Warning: %s !]", ptr)));
		}

		if (y == 6 || first_pass)
		{
			if (! init && y == LINE_ACTIVE)
				ferry-> active = ! ferry-> active;

			ClearLine (win, 6);
			PrintN (win, 1, 6, Fmt ("Ferry is %sactive",
				ferry-> active ? "": " NOT"));
		}

		if (first_pass | y == 8)
		{
			ClearLine (win, 8);

			if (y == 8 || init)
			{
				ans = GetQuest (win, 8, 
					"Min oil do drill for [1]: ",
					3, GS_PNUMBER);

				if (ans == (char *) 0 || interrupt)
				{
					interrupt = False;
					Bell ();
					if (init)
					{
						Message ("Add Ferry Cancelled");
						return RET_DONE;
					}
				}

				if (* ans == '\0')
					ferry-> oil_min = 1;
				else
				{
					ferry-> oil_min = atoi (ans);
					if (ferry-> oil_min > MAX_OILCONT)
						ferry-> oil_min = MAX_OILCONT;
				}
			}

			PrintN (win, 1, 8, Fmt ("Minimum oil to drill for: %d",
				ferry-> oil_min));
		}

		if (! first_pass && y == 10)
		{
			if (FerButPressed (x, F_SX_DONE, 4))
				return RET_DONE;
			else if (FerButPressed (x, F_SX_PREV, 4))
				return RET_PREV;
			else if (FerButPressed (x, F_SX_RUN, 3))
			{
				DoFerry (ferry-> id);
				return RET_DONE;
			}
			else if (FerButPressed (x, F_SX_NEXT, 4))
				return RET_NEXT;
			else if (FerButPressed (x, F_SX_DELETE, 6))
				if (Confirm ("Delete this ferry ?", True))
					return RET_DELE;
		}

		if (first_pass)
		{
			FerButton (win, F_SX_DONE,   10, "Done");
			FerButton (win, F_SX_PREV,   10, "Prev");
			FerButton (win, F_SX_RUN,    10, "Run");
			FerButton (win, F_SX_NEXT,   10, "Next");
			FerButton (win, F_SX_DELETE, 10, "Delete");

			if (init)
				init = False;
			
			first_pass = False;
		}

		FlushWindow (win);
	}
	while (SelButtonAtWin (win, & x, & y, (int *) 0));
					
	return RET_DONE;
}

static int EditExplore (win, ferry, init)
WinInfo win;
Ferry ferry;
bool init;
{
		/*
		 0
		 1		-=[ Ferry Utility : Explore ]=-
		 2
		 3	Ferry# 8
		 4
		 5	Fleet: A	(currently @ -12,23)
		 6	Ferry is Active/NOT Active
		 7
		 8	Explore to the south.
		 9
		 10	[DONE] [PREV] [RUN] [NEXT] [DELETE]
		 */

	char * ans, * ptr;
	int x, y;
	bool first_pass;

#ifdef lint
	x = y = 0;
#endif
	ClearWindow (win);

	PrintN (win, 1, 1, Centered ("-=[ Ferry Utility : Explore ]=-", 80));

	PrintN (win, 1, 3, Fmt ("Ferry# %d", ferry-> id));

	first_pass = True;
	y = 0;

	do {
			/* Ship / Fleet */

		if (first_pass || y == 5)
		{
			ClearLine (win, 5);

			if (y == 5 || init)
			{
				if (! SelectFlSh (win, 5, ferry))
				{
					Bell ();

					if (init)
					{
						Message ("Add Ferry cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}
			}

			if ((ptr = CheckFlSh (ferry)) != (char *) 0)
				Bell ();

			PrintN (win, 1, 5, Fmt ("%-30s %-40s",
				ferry-> fleet == '\0' ?
					Fmt ("Ship %d", ferry-> shipnr) :
					Fmt ("Fleet %c", ferry-> fleet),
				ptr == (char *) 0 ?
					Fmt ("[now @ %s]", FerryPos (ferry)) :
					Fmt ("[Warning: %s !]", ptr)));
		}

		if (first_pass || y == 6)
		{
			if (! init && y == 6)
				ferry-> active = ! ferry-> active;

			ClearLine (win, 6);
			PrintN (win, 1, 6, Fmt ("Ferry is %sactive",
				ferry-> active ? "": " NOT"));
		}

		if (first_pass || y == 8)
		{
			ClearLine (win, 8);

			if (y == 8 || init)
			{
				ans = GetQuest (win, 8,
					"Explore to the [nesw]: ", 1, "nesw");
				
				if (ans == (char *) 0 || interrupt ||
								* ans == '\0')
				{
					interrupt = False;

					if (init)
					{
						Message ("Add Ferry Cancelled");
						DeleteFerry (ferry-> id);
						return RET_DONE;
					}
				}
				else
					ferry-> expl_dir = * ans;
			}

			PrintN (win, 1, 8, Fmt ("Explore to the %s.     ",
				DirectionName (ferry-> expl_dir)));
		}

		if (! first_pass && y == 10)
		{
			if (FerButPressed (x, F_SX_DONE, 4))
				return RET_DONE;
			else if (FerButPressed (x, F_SX_PREV, 4))
				return RET_PREV;
			else if (FerButPressed (x, F_SX_RUN, 3))
			{
				DoFerry (ferry-> id);
				return RET_DONE;
			}
			else if (FerButPressed (x, F_SX_NEXT, 4))
				return RET_NEXT;
			else if (FerButPressed (x, F_SX_DELETE, 6))
				if (Confirm ("Delete this ferry ?", True))
					return RET_DELE;
		}

		if (first_pass)
		{
			FerButton (win, F_SX_DONE,   10, "Done");
			FerButton (win, F_SX_PREV,   10, "Prev");
			FerButton (win, F_SX_RUN,    10, "Run");
			FerButton (win, F_SX_NEXT,   10, "Next");
			FerButton (win, F_SX_DELETE, 10, "Delete");

			if (init)
				init = False;
			
			first_pass = False;
		}

		FlushWindow (win);
	}
	while (SelButtonAtWin (win, & x, & y, (int *) 0));

	return RET_DONE;
}

static WinInfo OpenFerryWin (task, x, y)
int task;
{
#ifdef TERMC_VERSION

	return OpenRelToRoot (census_win, x, y, F_MAX_X, 
		task == TASK_CARGO ? LINE_LOW + 1
				   : task == TASK_GOTO ? 14
						       : 12,
		  (task == TASK_CARGO) ? LEFT_BOX | RIGHT_BOX : FULL_BOX, 0);

#else 	/* X_VERSION */

	return OpenRelToRoot (map_win, x, y, F_MAX_X, 
		(task == TASK_CARGO) ? LINE_LOW + 2 :
		  (task == TASK_GOTO) ? 14 : 12, 
		CHARS, 0);

#endif /* VERSION */
}

static int EditFerry (win, ferry, init)
WinInfo win;
Ferry ferry;
bool init;
{
	switch (ferry-> task)
	{

	case TASK_CARGO:
		return EditCargo (win, ferry, init);

	case TASK_EXPLORE:
		return EditExplore (win, ferry, init);
	
	case TASK_GOTO:
		return EditGoto (win, ferry, init);

	case TASK_OIL:
		return EditOil (win, ferry, init);
	}

	/* NOTREACHED */
}

static void ShowFerry (ferry, x, y, init)
Ferry ferry;
int x, y;
bool init;
{
	WinInfo win;
	int stat;
	Ferry last;

	win = OpenFerryWin (ferry-> task, 5, 0);
	SetDefaultCursor (win, CR_MENU);

	do {
		stat = EditFerry (win, ferry, init);
		init = False;
		last = ferry;

		if (stat == RET_NEXT)
		{
			for (ferry = ferry-> next;
			      ferry != (Ferry) 0 && ferry-> task != last-> task;
		 	      ferry = ferry-> next);
			
			if (ferry == (Ferry) 0)
			{
				Message (Fmt ("No next (%s) ferry !",
					TaskName (last-> task)));
				Bell ();
				ferry = last;
			}
		}
		else if (stat == RET_PREV)
		{
			for (ferry = ferry-> prev;
			      ferry != (Ferry) 0 && ferry-> task != last-> task;
		 	      ferry = ferry-> prev);
			
			if (ferry == (Ferry) 0)
			{
				Message (Fmt ("No previous (%s) ferry !",
					TaskName (last-> task)));
				Bell ();
				ferry = last;
			}
		}
		else if (stat == RET_DELE)
		{
			DeleteFerry (last-> id);
			stat = RET_DONE;
			break;
		}

	}
	while (stat != RET_DONE);

	DestroyWindow (win);
}

static char * tasks_names [] =
{
	"Cargo",
	"Goto",
	"Explore",
	"Seek Oil",
	(char *) 0
};

static void AddFerry (x, y)
int x, y;
{
	Strings strings;
	Pager pager;
	Ferry ferry;
	int i;

	strings = InitStrings ();
	AddStringsID (strings, tasks_names, TASK_MAX, 0);
	pager = InitPager (strings, "Which Task ?");
	MapPagerFromTop (pager, map_win, x, y);

	i = PagerMenu (pager);

	if (i < 0 || interrupt)
	{
		interrupt = False;
		FreePager (pager);
		FreeStrings (strings);
		Message ("Add ferry cancelled");
		return;
	}

	ferry = NewFerry ();
	ferry-> task = i;
	if (i == TASK_GOTO)
		ferry-> complet = False;

	ShowFerry (ferry, x + 2, y + 2, True);

	FreePager (pager);
	FreeStrings (strings);
	return;
}

#define FERRY_STAT	0
#define FERRY_LCOM	1
#define FERRY_LALL	2
#define FERRY_ADD	3
#define	FERRY_DEL	4
#define	FERRY_RUN	5

#define FERRY_MAX	6

static char * ferry_commands [] =
{
	"Change/Run of all ferries",
	"List of completed goto ferries",
	"List of all ferries",
	"Add new ferry",
	"Delete all compeleted trips",
	"Run ferries",
	(char *) 0
};

void FerryUtil (x, y)
{
	Strings strings;
	Pager pager;
	Ferry ptr, next;
	int i, nr;

	strings = InitStrings ();
	AddStringsID (strings, ferry_commands, FERRY_MAX, 0);
	pager = InitPager (strings, "Ferry command ?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);

	if (i < 0 || interrupt)
	{
		interrupt = False;
		FreePager (pager);
		FreeStrings (strings);
		return;
	}

	switch (i)
	{

	case FERRY_STAT:
	case FERRY_LALL:
		FerryStat (x + 2, y + 2, i == FERRY_LALL);
		break;

	case FERRY_LCOM:
		ListComplFerries ();
		break;
		
	case FERRY_ADD:
		AddFerry (x + 2, y + 2);
		break;

	case FERRY_DEL:
		ptr = ferry_head;
		nr = 0;

		while (ptr != (Ferry) 0)
		{
			next = ptr-> next;
			if (ptr-> task == TASK_GOTO && ptr-> complet)
			{
				nr ++;
				DeleteFerry (ptr-> id);
			}
			ptr = next;
		}

		if (nr == 0)
		{
			Bell ();
			Message ("No ferries deleted !");
			break;
		}
		else if (nr == 1)
			Message ("One completed ferry deleted");
		else
			Message (Fmt ("%d completed ferries deleted", nr));

		break;
	
	case FERRY_RUN:
		DoAllFerries ();
		break;
	}

	FreePager (pager);
	FreeStrings (strings);
	return;
}

 /*****************************************************************************
 *			Datafile functions				      *
 *****************************************************************************/

void SaveFerries (fp)
FILE *fp ;
{
	Ferry ptr;
	int i;

	for (ptr = ferry_head; ptr != (Ferry) 0; ptr = ptr-> next)
	{
		fprintf (fp, "%d %d %s\n", ptr-> id, ptr-> task,
			ptr-> fleet == '\0' ?
				Fmt ("S%d", ptr-> shipnr) :
				Fmt ("F%c", ptr-> fleet));

		switch (ptr-> task)
		{

		case TASK_CARGO:
			fprintf (fp, "%d %d %d %d %d %d\n",
				ptr-> ax, ptr-> ay,
				ptr-> bx, ptr-> by,
				ptr-> waremob,
				ptr-> goto_a);

			for (i = 1; i < V_MAX; i ++)
				fprintf (fp, "%c %d %d %d %d\n", 
					ItemChar (i),
					ptr-> dir [i],
					ptr-> thr_ship [i],
					ptr-> thr_sct [i],
					ptr-> max_ship [i]);

			break;

		case TASK_GOTO:
			fprintf (fp, "%d %d %d\n",
				ptr-> ax, ptr-> ay, ptr-> complet);

			break;

		case TASK_EXPLORE:
			fprintf (fp, "%c\n", ptr-> expl_dir);
			break;

		case TASK_OIL:
			fprintf (fp, "%d\n", ptr-> oil_min);
			break;

		}
	}

	fprintf (fp, "END OF FERRY LIST\n");
}

void ReadFerries (fp)
FILE * fp;
{
	char buffer [BUFSIZ];
	Ferry ferry;
	int i, nr, err = 0;
	int id, task, shipnr;
	char fleet;

	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (strncmp (buffer, "END OF FERRY LIST", 17) == 0)
			return;

			/*
			 *	Look for F, because you can have
			 *	FS (fleet S)
			 */

		if (index (buffer, 'F') == (char *) 0)
		{
			nr = sscanf (buffer, "%hd %hd S%hd",
							& id, & task, & shipnr);

			fleet = '\0';
		}
		else
		{
			nr = sscanf (buffer, "%hd %hd F%c",
							& id, & task, & fleet);
			shipnr = -1;
		}

		if (nr != 3 ||  fgets (buffer, BUFSIZ, fp) == (char *) 0)
		{
			PrintAtEmpire ("Bad ferry in data file line ignored");
			Bell ();
			continue;
		}

		ferry = NewFerry ();
		ferry-> id = id;
		ferry-> task = task;
		ferry-> shipnr = shipnr;
		ferry-> fleet = fleet;

		switch (task)
		{

		case TASK_CARGO:
			if (sscanf (buffer, "%hd %hd %hd %hd %hd %hd",
				& (ferry-> ax),
				& (ferry-> ay),
				& (ferry-> bx),
				& (ferry-> by),
				& (ferry-> waremob),
				& (ferry-> goto_a)) == 6)
			
			{
				for (i = 1; i < V_MAX; i ++)
				{
					if (fgets (buffer, BUFSIZ, fp)
								== (char *) 0)
					{
						err++;
						break;
					}
					else if (sscanf (buffer,
						        "%*c %hd %hd %hd %hd\n",

						& (ferry-> dir [i]),
						& (ferry-> thr_ship [i]),
						& (ferry-> thr_sct [i]),
						& (ferry-> max_ship [i])) != 4)
					{
						err++;
						break;
					}
				}
			
			}
			else
				err++;
			break;

		case TASK_OIL:
			if (sscanf (buffer, "%hd\n", & (ferry-> oil_min)) != 1)
				err++;
			break;

		case TASK_EXPLORE:
			if (sscanf (buffer, "%c\n", & (ferry-> expl_dir)) != 1)
				err++;
			break;

		case TASK_GOTO:
			if (sscanf (buffer, "%hd %hd %hd",
					& (ferry-> ax),
					& (ferry-> ay),
					& (ferry-> complet)) != 3)
				err++;
			break;
		}
		if (err)
		{
			err = 0;
			PrintAtEmpire ("Bad ferry in data file line ignored");
			Bell ();
			DeleteFerry (id);
		}
	}
}

static void RunFerry (id, dump)
int id;
bool dump;
{
	Ferry ferry;
	char * ptr;
	Ship ship;
	int min_mob;

	ferry = FindFerry (id);

	ClearText ();
	ShowText (Fmt( "Ferry# %d", id));

	if (ferry == (Ferry) 0)
	{
		ShowText ("No such ferry# exists");
		ShowText ("Aborted");
		ShowDone ();
	}

	ShowText (Fmt ("Task: %s", TaskName (ferry-> task)));

	if (! ferry-> active)
	{
		ShowText ("Ferry not active");
		ShowText ("Aborted");
		ShowDone ();
		return;
	}

	if ((ptr = CheckFlSh (ferry)) != (char *) 0)
	{
		ShowText (Fmt ("Error: %s", ptr));
		ShowText ("Aborted");
		ShowDone ();
		return;
	}

	if ((min_mob = FerryMinMob (ferry)) <= 0)
	{
		ShowText ("No more mobility");
		ShowText ("Aborted");
		ShowDone ();
		return;
	}

	ShowText (Fmt ("%s @ %s (mob = %d)",
		ferry-> fleet == '\0' ?
			Fmt ("Ship %d", ferry-> shipnr) :
			Fmt ("Fleet %c", ferry-> fleet),
		FerryPos (ferry),
		min_mob));

	switch (ferry-> task)
	{

	case TASK_GOTO:
		RunGotoFerry (ferry);
		break;

	case TASK_CARGO:
		RunCargoFerry (ferry);
		break;

	case TASK_OIL:
	case TASK_EXPLORE:
		
		ShowText ("Not (yet) implemented");
	}

	ShowDone ();
	if (dump)
		if (ferry-> fleet != '\0')
			RedumpFleet (ferry-> fleet, DONT_PRINT);
		else
		{
			ship = NrToShip (ferry-> shipnr);
			if (ship != (Ship) 0)
				RedumpShip (ship, DONT_PRINT);
		}

	if (! util_mode)
		Census ();
	return;
}

void DoFerry (id)
int id;
{
	UnmarkSector (cursct);
	RaiseAll ();
	OpenTextWindow (10, 10, "Output of ferry");
#ifdef X_VERSION
	ShowText (
		"Place window & press any key to start, press <INTR> to abort");

	Pause ();
	if (! interrupt)
#endif X_VERSION
		RunFerry (id, True);


	CloseTextWindow ();
	LowerAll ();
	MarkSector (cursct);
}


static void RunAllFerries ()
{
	Ferry ptr;

	for (ptr = ferry_head; ptr != (Ferry) 0; ptr = ptr-> next)
	{
		if (util_mode)
			FreeFmts ();

		RunFerry (ptr-> id, False);
		if (interrupt)
			break;
	}

	MarkAllShips ();
	(void) DumpShips ("*", DONT_PRINT);
	CheckMarkedShips ();
}

static void DoAllFerries ()
{
	UnmarkSector (cursct);
	RaiseAll ();
	OpenTextWindow (100, 100, "Output of ferry");
	ShowText ("Place window & press any key to start");
	Pause ();
	RunAllFerries ();
	CloseTextWindow ();
	LowerAll ();
	MarkSector (cursct);
}

void DoFerryUtil (args)
char * args;
{
	int nr;

	if (* args == '\0' || strcmp (args, ":all") == 0 ||
						strcmp (args, ":@") == 0)
		RunAllFerries ();
	else
	{
		while (* args ++ == ':')
		{

			if (! ScanDigit (& args, & nr))
			{
				fprintf (stderr, "bad syntax in ferry opts\n");
				return;
			}

			RunFerry (nr, True);
		}
	}
}

void ChangeFerry (fleet, ship)
char fleet;
Ship ship;
{
	Ferry ptr;


	for (ptr = ferry_head; ptr != (Ferry) 0; ptr = ptr-> next)
		if ((ptr-> fleet == fleet && fleet != '\0') ||
				(ship != (Ship) 0 && 
					(sh_fleet (ship) == ptr-> fleet ||
					 ptr-> shipnr == sh_nr (ship))))
			break;

	if (ptr == (Ferry) 0)
		AddFerry (5, 5);
	else
		ShowFerry (ptr, 5, 5, False);
}


void ListSectorFerries ()
{
	Ship ship;
	Ferry ferry;
	extern int last_layout;
	char civ_dir, mil_dir;
	int civ_cap, mil_cap;
	bool isa, isb;
	int y;

	y = FL_SY_FLEET;

	last_layout = FERRY_LIST;

	ClearWindow (census_win);
	CensusLayTop ();
	DrawHorizontal (census_win, y ++);

	for (ferry = ferry_head; ferry != (Ferry) 0; ferry = ferry-> next)
	{
		if (ferry-> task != TASK_CARGO && ferry-> task != TASK_GOTO)
			continue;

#define MICHIEL_MOD		/* Added Goto ferries in ferry list */
#ifdef MICHIEL_MOD
		if (ferry-> task == TASK_CARGO)
		{
			isa = False;
			isb = False;

			if (ferry-> ax == s_xcd (cursct) &&
			    ferry-> ay == s_ycd (cursct))
				isa = True;

			if (ferry-> bx == s_xcd (cursct) &&
			    ferry-> by == s_ycd (cursct))
				isb = True;

			if (! isa && ! isb)
				continue;

			if (IS_A_TO_B (ferry-> dir [V_MILIT]))
			{
				if (isa)
					mil_dir = 'E';
				else
					mil_dir = 'I';
			}
			else if (IS_B_TO_A (ferry-> dir [V_MILIT]))
			{
				if (isa)
					mil_dir = 'I';
				else
					mil_dir = 'E';
			}
			else
				mil_dir = '-';
				
			if (IS_A_TO_B (ferry-> dir [V_CIVIL]))
			{
				if (isa)
					civ_dir = 'E';
				else
					civ_dir = 'I';
			}
			else if (IS_B_TO_A (ferry-> dir [V_CIVIL]))
			{
				if (isa)
					civ_dir = 'I';
				else
					civ_dir = 'E';
			}
			else
				civ_dir = '*';
		}
		else
		{
			if (ferry-> ax != s_xcd (cursct) ||
			    ferry-> ay != s_ycd (cursct))
				continue;
			
			civ_dir = mil_dir = ' ';
		}

#endif
			
		civ_cap = 0;
		mil_cap = 0;

		if (ferry-> fleet == '\0')
		{
			ship = NrToShip (ferry-> shipnr);
			civ_cap = MaxShipCargo (ship, 'c');
			mil_cap = MaxShipCargo (ship, 'm');
		}
		else
		{
			for (ship = shiplist; ship != (Ship) 0; 
						ship = sh_next (ship))
			if (sh_fleet (ship) == ferry-> fleet)
			{
				civ_cap += MaxShipCargo (ship, 'c');
				mil_cap += MaxShipCargo (ship, 'm');
			}
		}

#ifdef MICHIEL_MOD
		if (ferry-> task == TASK_CARGO)
			PrintN (census_win, 0, y ++,
				Fmt ("#%d: %s (%c%dc, %c%dm)",
					ferry-> id,
					ferry-> fleet == '\0' ?
						Fmt ("sh %d", ferry-> shipnr):
						Fmt ("flt %c", ferry-> fleet),
					civ_dir, civ_cap,
					mil_dir, mil_cap));
		else
			PrintN (census_win, 0, y ++,
				Fmt ("#%d: %s (%dc, %dm)GOTO",
					ferry-> id,
					ferry-> fleet == '\0' ?
						Fmt ("sh %d", ferry-> shipnr):
						Fmt ("flt %c", ferry-> fleet),
					civ_cap, mil_cap));
#endif
	}

	FlushWindow (census_win);
}

void GotoFerry ()
{
	char * ans;
	Ferry ferry;
	int x, y;
	Sector sct;
	int i;
	bool found_ferry = False;

	ans = InputAtMessage ("Ferry# ", 3, GS_PNUMBER);

	if (ans == (char *) 0 || interrupt || * ans == 0)
	{
		interrupt = False;
		ClearMes ();
		return;
	}

	i = atoi (ans);

	for (ferry = ferry_head; ferry != (Ferry) 0; ferry = ferry-> next)
	{
		if (ferry-> id == i)
		{
			(void) sscanf (FerryPos (ferry), "%d,%d", & x, & y);
			sct = World (x, y, S_EXIST);
			if (sct != (Sector) 0)
			{
				found_ferry = True;
				Goto (sct);
			}
		}
	}

	if (! found_ferry)
	{
		Message ("Ferry not found");
		Bell ();
	}
}

void SetXAtButton (x, ch)
int * x;
char ch;
{
	switch (ch)
	{

	case '\033':
		* x = F_SX_DONE;
		break;
	
	case 'N':
		* x = F_SX_NEXT;
		break;
	
	case 'P':
		* x = F_SX_PREV;
		break;
	
	case 'D':
		* x = F_SX_DELETE;
		break;
	
	case 'R':
		* x = F_SX_RUN;
		break;

	default:
		* x = 0;
	}
}
