/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/ship/RCS/tend.c,v 5.1 93/03/14 16:51:44 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:51:44 $
    $Author: etienne $
    $Id: tend.c,v 5.1 93/03/14 16:51:44 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	tend.c,v $
 * Revision 5.1  93/03/14  16:51:44  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:42  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:43:25  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

static int last_amount;
static int last_item;
static Ship last_ship;
static int last_x;
static int last_y;

void BindTend (x, y, args)
int x, y;
char * args;
{
	char buffer [40];
	int amount;
	int i;

	if (last_layout != SHIP_MODE)
	{
		Message ("No current ship !");
		Bell ();
		return;
	}

	if (args == (char *) 0)
	{
		DoTend (x, y, curship, -1, 0);
		return;
	}

	if (sscanf (args, " ( %[^,] , %d )", buffer, & amount) == 2)
		i = CharToItem (buffer [0]);
	else if (sscanf (args, " ( %[^)] )", buffer) == 1)
	{
		i = CharToItem (buffer [0]);
		amount = 0;
	}
	else
	{
		Message ("Illegal binding, usage: Tend (item, #)");
		Bell ();
		return;
	}
	
	if (i < 0)
	{
		Message (Fmt ("Unrecognized item in tend binding (%c)",
			buffer [0]));
		Bell ();
		return;
	}

	DoTend (x, y, curship, i, amount);
}

void RedoTend ()
{
		/*
		 *	I'm not sure about this. Same ship means other
		 *	commodity?
		 */

	if (last_layout == SHIP_MODE)
	{
		if (last_ship == curship)
			DoTend (last_x, last_y, curship, last_item, 0);
		else
			DoTend (last_x, last_y, curship, last_item,
								last_amount);
	}
	else
	{
		Message ("No current ship !");
		Bell ();
	}
}

void Tend (x, y, ship)
int x, y;
Ship ship;
{
	DoTend (x, y, ship, -1, 0);
}

void DoTend (x, y, ship, item, amount)
int x, y;
Ship ship;
int item;
int amount;
{
	char itemchar;
	int atship, max;
	char * ans, * ships;
	Ship ptr;
	int at_ptr, max_ptr;
	int i;

	if (item == -1)
	{
		item = SelectItem (x, y, "Which item to tend ?");
		if (item < 0)
		{
			Message ("Tend cancelled");
			Bell ();
			return;
		}
	}

	SetAgain (RedoTend);
	last_ship = ship;
	last_item = item;
	last_amount = 0;
	last_x = x;
	last_y = y;
	itemchar = ItemChar (item);

	if (amount == 0)
	{
		ans = InputAtMessage (Fmt ("# of %s to transfer: ",
						ItemName (item)), 4, GS_NUMBER);

		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			Message ("Tend cancelled");
			Bell ();
			return;
		}
	}

	amount = atoi (ans);
	if (amount == 0)
	{
		Message ("That won't work !");
		Bell ();
		return;
	}
	last_amount = amount;
	max = MaxShipCargo (ship, itemchar);
	atship = GiveShipQuant (ship, itemchar);
	if (amount < 0)
	{

		if (max == 0)
		{
			Message (Fmt ("%s #%d cannot hold %s !", 
			       ShipName (ship), sh_nr (ship), ItemName (item)));
			Bell ();
			return;
		}
		else if (max == atship)
		{
			Message (Fmt ("%s #%d cannot hold any more %ss !",
			       ShipName (ship), sh_nr (ship), ItemName (item)));
			Bell ();
			return;
		}
	}
	else
	{
		if (atship == 0)
		{
			Message (Fmt ("no %s on %s #%d", ItemName (item),
					ShipName (ship), sh_nr (ship)));
			Bell ();
			return;
		}
	}

	ships = SelectShips (x, y, ST_TEND, "Tend which ships ?");
	if (ships == (char *) 0)
	{
		Message ("Tend cancelled");
		return;
	}

	UnmarkAllShips ();
	MarkShips (ships);


	if (command_state > BUFFER_STATE)
	{
		if (command_state < TEST_STATE)
			FeedCommand (Fmt ("tend %d %c %d %s", sh_nr (ship),
				itemchar, amount, ships), PRINT);

		for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
		{
			if ((amount > 0 && atship == 0) || 
			    (amount < 0 && atship == max))
				break;

			at_ptr = GiveShipQuant (ptr, itemchar);
			max_ptr = MaxShipCargo (ptr, itemchar);

			if (max_ptr == 0)
			{
				Warning (Fmt ("%s #%d cannot hold %s",
					ShipName (ptr),
					sh_nr (ptr),
					ItemName (item)));
				continue;
			}

			if (amount > 0)
			{
				if (at_ptr == max_ptr)
				{
					Message (Fmt (
					      "%s #%d cannot hold any more %s",
						ShipName (ptr),
						sh_nr (ptr),
						ItemName (item)));
					continue;
				}

				i = amount;
				if (i > max_ptr - at_ptr)
				{
					i = max_ptr - at_ptr;

					Warning (Fmt (
					  "Only %d %s tended to %s #%d",
						i,
						ItemName (item),
						ShipName (ptr),
						sh_nr (ptr)));
				}

				if (i > atship)
				{
					Warning (Fmt ("Tender run out of %s",
						ItemName (item)));
					i = atship;
				}

				atship -= i;
				SetShipQuant (ptr, itemchar, at_ptr + i);
			}
			else
			{
				i = amount;

				if (i > at_ptr)
					i = at_ptr;

				if (max > atship + i)
				{
					Warning (Fmt (
					    "Tender can't hold any more %s",
						ItemName (item)));
					i = max - atship;
				}

				SetShipQuant (ptr, itemchar, at_ptr - i);
			}
		}

		SetShipQuant (ship, itemchar, atship);
		CensusShip (ship);
		return;
	}

	FeedEmpire (Fmt ("tend %d %c %d %s", sh_nr (ship),
		itemchar, amount, ships), PRINT);
	(void) WaitForPrompt (PRINT);
	Message (Fmt ("Dumping ships: %d/%s", sh_nr (ship), ships));
	CheckShips (Fmt ("%d/%s", sh_nr (ship), ships));
	Message ("Tend done");
}
