/*
	$Header: /usr/local/src/et/work/xemp5.0/lib/ship/RCS/scuttle.c,v 5.1 93/03/14 16:51:39 etienne Exp Locker: etienne $
	$Date: 93/03/14 16:51:39 $
	$Author: etienne $
	$Id: scuttle.c,v 5.1 93/03/14 16:51:39 etienne Exp Locker: etienne $
	$Locker: etienne $
	$Log:	scuttle.c,v $
 * Revision 5.1  93/03/14  16:51:39  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/12  19:38:45  etienne
 * initial rel.
 * 
*/

#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "ship.h"

void RedoScuttle ()
{
	Ship next;
	char nextfl;

	if (last_layout == SHIP_MODE)
	{
		next = sh_nxtsct (curship);
		ScuttleShip (Fmt ("%d", sh_nr (curship)));
		curship = next;
		if (curship != (Ship) 0)
			CensusShip (curship);
		else
			Census ();
		DrawSector (cursct);
	}
	else if (last_layout == FLEET_MODE)
	{
		nextfl = GiveNextFleetInSct (cursct, curfleet);
		ScuttleShip (FleetId ());
		if (nextfl != ' ' && nextfl != '\0')
		{
			curfleet = '\0';
			Census ();
		}
		else
		{
			curfleet = nextfl;
			CensusFleet (curfleet);
		}
		DrawSector (cursct);
	}
	else
	{
		Message ("No current ship/fleet selected");
		Bell ();
	}
}
	

	/*
	 *	There is no binding to scuttle.
	 *	This routine should only be called with owned ships
	 */

void ScuttleShip (what)
char * what;
{
	Ship ptr, next;
	int i, j;
	int nr;
	char itemchar;

	UnmarkAllShips ();
	MarkShips (what);

	Message (Fmt ("Scuttleping %s", what));

	if (! Confirm (Fmt ("Scuttle %s", what), True))
	{
		Message ("Scuttle ship cancelled");
		return;
	}

	FeedCommand (Fmt ("scuttle ship %s", what), PRINT);
	SetAgain (RedoScuttle);

	ptr = shiplist;
	while (ptr != (Ship) 0)
		if (sh_marked (ptr))
		{
			next = sh_next (ptr);

			for (i = 1; i < V_MAX; i ++)
			{
				itemchar = ItemChar (i);
				j = GiveShipQuant (ptr, itemchar);
				if (j > 0)
					SetQuant (cursct, itemchar,
					      GiveQuant (cursct, itemchar) + j);
			}

			nr ++;

			DeleteShip (ptr);
			ptr = next;
		}
		else
			ptr = sh_next (ptr);
	
	if (nr == 0)
	{
		Message ("No ships scuttled");
		Bell ();
		return;
	}

	Message (Fmt ("%d ships scrapped", nr));
	Census ();
	DrawSector (cursct);
}
