/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/parse/RCS/parser.h,v 5.1 93/03/14 16:50:53 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:53 $
    $Author: etienne $
    $Id: parser.h,v 5.1 93/03/14 16:50:53 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	parser.h,v $
 * Revision 5.1  93/03/14  16:50:53  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:23:02  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:53  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
/*
 * Parser.h
 */

#ifndef _PARSER
#define _PARSER

#include "type.h"

typedef struct _Stack *Stack;
extern char *Str();

#if defined(PARSE_DEBUG)
extern char *Malloc(), *Strdup();

#define doalloc(bytes)		Malloc(bytes, __FILE__, __LINE__, "bytes")
#define dofree(data)		Free(data, __FILE__, __LINE__, "data")
#define strdup(str)		Str(str)
#define Str(str)		Strdup(str)
#else
extern char *doalloc(/* int bytes */);
#define dofree(data)		free(data)
#endif

extern bool parse_error;
extern Strings parse_errors;

#define P_OK		0	/* Normal execution		          */
#define P_ABORTED	1	/* Abort statement encoutered             */
#define P_EMPTY		2	/* Nil program specified	          */
#define P_ERROR		3	/* Program error during execution         */

extern Expression ParseExpression(/* char *line */);
extern double EvaluateExpression(/* Expression expression */);
extern void DestroyExpression(/* Expression *expression */);

extern Program ParseProgram(/* char **lines */);
extern int RunProgram(/* Program program */);
extern void DestroyProgram(/* Program *program */);
#endif
