/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/nuke/RCS/show.c,v 5.1 93/03/14 16:50:20 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:20 $
    $Author: etienne $
    $Id: show.c,v 5.1 93/03/14 16:50:20 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	show.c,v $
 * Revision 5.1  93/03/14  16:50:20  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "nuke.h"

int SelectNukeType (x, y, task)
int x, y, task;
{
	Strings strings;
	Pager pager;
	char * head;
	bool add;
	int found;
	int i;

	found = 0;
	strings = InitStrings ();
	for (i = 0; i < nr_nuke_types; i ++)
	{
		add = False;

		switch (task)
		{

		case NK_BUILD:
			add = nt_tech (i) <= (int) n_tech (nation);
			break;
		}

		if (add)
		{
			if (found == 0)
				if (land_units) {
					AddStringID (strings,
				  	"Nuketype     lcm hcm oil rad ava tech res cost",
				  	-1);
				} else {
					AddStringID (strings,
				  	"Nuketype     lcm hcm oil rad ava tech cost",
				  	-1);
				}
			      if (land_units) {
				AddStringID (strings,
				Fmt ("%-12s %-3d %-3d %-3d %-3d %-3d %-4d %-4d $%d",
					nt_name (i),
					nt_lcm (i), nt_hcm (i), nt_oil (i),
					nt_rad (i), nt_ava (i), nt_tech (i),
					nt_res (i), nt_cost (i)),
				i);
			      } else {
				AddStringID (strings,
				Fmt ("%-12s %-3d %-3d %-3d %-3d %-3d %-4d $%d",
					nt_name (i),
					nt_lcm (i), nt_hcm (i), nt_oil (i),
					nt_rad (i), nt_ava (i), nt_tech (i),
					nt_cost (i)),
				i);
			      }
			found ++;
		}
	}

	if (found == 0)
	{
		switch (task)
		{

		case NK_BUILD:
			Message ("You can't build nukes (yet)");
			Bell ();
			return -1;
		}
	}

	switch (task)
	{

	case NK_BUILD:
		head = "Build which nuke?";
		break;
	}

	pager = InitPager (strings, head);
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreeStrings (strings);
	FreePager (pager);

	return i;
}

int SelectNuke(x, y, stockp)
Stockp stockp;
int x, y;
{
	register int i, k;
	Strings strings;
	Pager pager;
	char * head;
	int quant, ntype[MAX_NUKETYPES];

	strings = InitStrings ();
	AddStringID (strings, "Nuketype     Quantity", -1);

	k = 0;
	for (i = 0; i < nr_nuke_types; i ++)
	{
		quant = sp_nukamt(stockp,i);
		if (quant != 0) 
		{
			AddStringID (strings, Fmt ("%-12s   %-3d", nt_name (i),
					quant), k);
			ntype[k] = i;
			k++;
		}
	}

	head = "Arm with which nuke?";

	pager = InitPager (strings, head);
	MapPagerFromTop (pager, map_win, x, y);
	do	
		i = PagerMenu (pager);
	while ( i < 0);
	FreeStrings (strings);
	FreePager (pager);

	return ntype[i];
}
