/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/nuke/RCS/alloc.c,v 5.1 93/03/14 16:50:14 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:50:14 $
    $Author: etienne $
    $Id: alloc.c,v 5.1 93/03/14 16:50:14 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	alloc.c,v $
 * Revision 5.1  93/03/14  16:50:14  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:49  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:40:08  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "main.h"
#include "nuke.h"

Stockp spl_head = (Stockp) 0;
Stockp spl_tail = (Stockp) 0;

Stockp NewStockPile ()
{
	Nuke new;

	new = (Stockp) doalloc ((unsigned) sizeof (struct s_nuke));
	(void) bzero (new, sizeof (struct s_nuke));

	if (spl_tail == (Stockp) 0)
		spl_tail = spl_head = new;
	else
	{
		set_sp_next (spl_tail, new);
		spl_tail = new;
	}

	return new;
}

void FreeStockPile (stockp)
Stockp stockp;
{
	Stockp ptr, found;

	if (spl_head == (Stockp) 0)
		Panic (__FILE__, "FreeStockPile", "spl_head NULL");

	if (stockp == spl_head)
	{
		if (spl_tail == stockp)
			spl_tail = sp_next (stockp);
		
		spl_head = sp_next (stockp);
	}
	else
	{
		found = (Stockp) 0;
		for (ptr = spl_head; sp_next (ptr) != (Stockp) 0;
				     ptr = sp_next (ptr))
		{
			if (ptr-> next == stockp)
			{
				found = ptr;
				break;
			}
		}
		
		if (found == (Stockp) 0)
			Panic (__FILE__, "FreeStockPile", 
				"stock pile not found");
		
		if (spl_tail == stockp)
			spl_tail = found;

		set_sp_next (found, sp_next (stockp));
	}

	(void) free ((char *) stockp);
}
