/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/misc/RCS/sector.c,v 5.1 93/03/14 16:49:43 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:49:43 $
    $Author: etienne $
    $Id: sector.c,v 5.1 93/03/14 16:49:43 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	sector.c,v $
 * Revision 5.1  93/03/14  16:49:43  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
	/*
	 *	Empire Tool,	file: commodities.c	<900212>
	 *
	 *	doalloc_world ()
	 *		Allacates the world
	 *
	 *	adjacent (sct1, sct2)
	 *		True when the sectors are adjacent
	 */

#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "ship.h"
#include "func.h"
#include "land.h"
#include "version.h"

/* 
 * struct s_sector3 NILSCT3 =  {
 * 	' ', 0, 0, 0, ' ', { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
 * 	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, (char *) 0, 0, 0
 * };
 * 
 * struct s_sector2 NILSCT2 = { 
 * 	0, 0, 0, 0, 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
 * 	(time_t) 0, &NILSCT3
 * };
 * 
 * struct s_sector1 NILSCT = {
 * 	0, 0, UNKNOW_CNUM, ' ', 0, 0, 0, 0, 0, 0, (Ship) 0, 0, &NILSCT2
 * };
 */

char chardirs [] = ".bngjyuh";

void SetSectorTime (sct)
Sector sct;
{
	time_t time ();

	set_time (sct, time ((time_t *) 0));
}

Sector **MallocWorld ()
{
	int x;
	register Sector **ret;

	ret = (Sector **) doalloc ((unsigned) MAX_X * sizeof (Sector *));

	for (x = 0; x < MAX_X; x ++) 
	{
		ret [x] = (Sector *) doalloc ((MAX_Y / 2) * sizeof (Sector));
		bzero ((char *) ret [x], (MAX_Y / 2) * sizeof (Sector));
/* 
 * 		for (y = 0; y < MAX_Y / 2; y++)
 * 			ret[x][y] = &NILSCT;
 */
	}

	return ret;
}

void SetDistPath (sct, path)
Sector sct;
char *path;
{
	if (s_pat (sct) != (char *) 0)
	{
		free (s_pat (sct));
		set_pat (sct, (char *) 0);
	}

	if (path == (char *) 0 || * path == '\0' || * path == '_')
		return;

	set_pat (sct, Str (path));
}

int GiveQuant (sct, item)
Sector sct;
char item;
{
	switch (item)
	{

	case 'c': return s_civ (sct);
	case 'm': return s_mil (sct);
	case 'u': return q_uw (sct);
	case 'f': return q_foo (sct);
	case 's': return q_she (sct);
	case 'g': return q_gun (sct);
	case 'p': return q_pet (sct);
	case 'i': return q_iro (sct);
	case 'd': return q_dus (sct);
	case 'b': return q_bar (sct);
	case 'o': return q_oil (sct);
	case 'l': return q_lcm (sct);
	case 'h': return q_hcm (sct);
	case 'r': return q_rad (sct);
	default:  return 0;

	}
}

bool Adjacent (sct1, sct2)
Sector sct1, sct2;
{
	register int x1, x2, y1, y2;

	x1 = s_xcd (sct1);
	x2 = s_xcd (sct2);
	y1 = s_ycd (sct1);
	y2 = s_ycd (sct2);

	/* to the left */

	return  (x1 == (EX (x2 - 2)) && y1 == y2)  ||
		(x1 == (EX (x2 + 2)) && y1 == y2)  ||
		(x1 == (EX (x2 + 1)) && y1 == (EY (y2 + 1))) ||
		(x1 == (EX (x2 + 1)) && y1 == (EY (y2 - 1))) ||
		(x1 == (EX (x2 - 1)) && y1 == (EY (y2 + 1))) ||
		(x1 == (EX (x2 - 1)) && y1 == (EY (y2 - 1)));
}

void SetQuant (sct, item, value)
Sector sct;
char item;
int value;
{
	switch (item)
	{

	case 'c': set_civ (sct, value); break;
	case 'm': set_mil (sct, value); break;
	case 'u': set_q_uw  (sct, value); break;
	case 'f': set_q_foo (sct, value); break;
	case 's': set_q_she (sct, value); break;
	case 'g': set_q_gun (sct, value); break;
	case 'p': set_q_pet (sct, value); break;
	case 'i': set_q_iro (sct, value); break;
	case 'd': set_q_dus (sct, value); break;
	case 'b': set_q_bar (sct, value); break;
	case 'o': set_q_oil (sct, value); break;
	case 'l': set_q_lcm (sct, value); break;
	case 'h': set_q_hcm (sct, value); break;
	case 'r': set_q_rad (sct, value); break;

	}
}

void SetThreshold (sct, item, value)
Sector sct;
char item;
int value;
{
	switch (item)
	{

	case 'u': set_t_uw  (sct, value); break;
	case 'f': set_t_foo (sct, value); break;
	case 's': set_t_she (sct, value); break;
	case 'g': set_t_gun (sct, value); break;
	case 'p': set_t_pet (sct, value); break;
	case 'i': set_t_iro (sct, value); break;
	case 'd': set_t_dus (sct, value); break;
	case 'b': set_t_bar (sct, value); break;
	case 'o': set_t_oil (sct, value); break;
	case 'l': set_t_lcm (sct, value); break;
	case 'h': set_t_hcm (sct, value); break;
	case 'r': set_t_rad (sct, value); break;

	case 'a':
		set_t_uw  (sct, value);
		set_t_foo (sct, value);
		set_t_she (sct, value);
		set_t_gun (sct, value);
		set_t_pet (sct, value);
		set_t_iro (sct, value);
		set_t_dus (sct, value);
		set_t_bar (sct, value);
		set_t_oil (sct, value);
		set_t_lcm (sct, value);
		set_t_hcm (sct, value);
		set_t_rad (sct, value);
		break;
	}
}

void SetCutoff (sct, item, value)
Sector sct;
char item;
int value;
{
	switch (item)
	{

	case 'u': set_c_uw  (sct, value); break;
	case 'f': set_c_foo (sct, value); break;
	case 's': set_c_she (sct, value); break;
	case 'g': set_c_gun (sct, value); break;
	case 'p': set_c_pet (sct, value); break;
	case 'i': set_c_iro (sct, value); break;
	case 'd': set_c_dus (sct, value); break;
	case 'b': set_c_bar (sct, value); break;
	case 'o': set_c_oil (sct, value); break;
	case 'l': set_c_lcm (sct, value); break;
	case 'h': set_c_hcm (sct, value); break;
	case 'r': set_c_rad (sct, value); break;

	}
}

int GetThreshold (sct, kind)
Sector sct;
char kind;
{
	switch (kind)
	{

	case 'u': return t_uw (sct);
	case 'f': return t_foo (sct);
	case 's': return t_she (sct);
	case 'g': return t_gun (sct);
	case 'p': return t_pet (sct);
	case 'i': return t_iro (sct);
	case 'd': return t_dus (sct);
	case 'b': return t_bar (sct);
	case 'o': return t_oil (sct);
	case 'l': return t_lcm (sct);
	case 'h': return t_hcm (sct);
	case 'r': return t_rad (sct);

	}
	/* NOTREACHED */
}

int GetCutoff (sct, kind)
Sector sct;
char kind;
{
	switch (kind)
	{

	case 'u': return c_uw (sct);
	case 'f': return c_foo (sct);
	case 's': return c_she (sct);
	case 'g': return c_gun (sct);
	case 'p': return c_pet (sct);
	case 'i': return c_iro (sct);
	case 'd': return c_dus (sct);
	case 'b': return c_bar (sct);
	case 'o': return c_oil (sct);
	case 'l': return c_lcm (sct);
	case 'h': return c_hcm (sct);
	case 'r': return c_rad (sct);

	}
	/* NOTREACHED */
}

void SetDelDir (sct, kind, dir)
Sector sct;
char kind, dir;
{	
	int value;
	char *ptr;

	ptr = index (chardirs, dir);
	if (ptr == (char *) 0)
		return;

	value = (int) (ptr - chardirs);

	switch (kind)
	{

	case 'u': set_d_uw  (sct, value); break;
	case 'f': set_d_foo (sct, value); break;
	case 's': set_d_she (sct, value); break;
	case 'g': set_d_gun (sct, value); break;
	case 'p': set_d_pet (sct, value); break;
	case 'i': set_d_iro (sct, value); break;
	case 'd': set_d_dus (sct, value); break;
	case 'b': set_d_bar (sct, value); break;
	case 'o': set_d_oil (sct, value); break;
	case 'l': set_d_lcm (sct, value); break;
	case 'h': set_d_hcm (sct, value); break;
	case 'r': set_d_rad (sct, value); break;

	}

	/* NOTREACHED */
}

char GetDelDir (sct, kind)
Sector sct;
char kind;
{
	switch (kind)
	{

	case 'u': return d_uw  (sct);
	case 'f': return d_foo (sct);
	case 's': return d_she (sct);
	case 'g': return d_gun (sct);
	case 'p': return d_pet (sct);
	case 'i': return d_iro (sct);
	case 'd': return d_dus (sct);
	case 'b': return d_bar (sct);
	case 'o': return d_oil (sct);
	case 'l': return d_lcm (sct);
	case 'h': return d_hcm (sct);
	case 'r': return d_rad (sct);

	}

	/* NOTREACHED */
}

struct s_neighb {
	int cur;
	int x;
	int y;
};

extern Sector **world;

void InitNeighbours (sct, neighb)
Sector sct;
Neighb * neighb;
{
	* neighb = (Neighb) doalloc ((unsigned) sizeof (struct s_neighb));
	(* neighb)-> cur = 1;
	(* neighb)-> x = s_xcd (sct);
	(* neighb)-> y = s_ycd (sct);
}

bool NextNeighbour (sct, known, neighb)
Sector *sct;
int known;
Neighb neighb;
{
	switch (neighb-> cur ++)
	{

	case 1:	*sct = World (neighb-> x + 1, neighb-> y - 1, known);
		return True;

	case 2:	*sct = World (neighb-> x + 2, neighb-> y, known);
		return True;

	case 3:	*sct = World (neighb-> x + 1, neighb-> y + 1, known);
		return True;

	case 4:	*sct = World (neighb-> x - 1, neighb-> y + 1, known);
		return True;

	case 5:	*sct = World (neighb-> x - 2, neighb-> y, known);
		return True;

	case 6:	*sct = World (neighb-> x - 1, neighb-> y - 1, known);
		return True;

	case 7:
		*sct = (Sector) 0;
		free ((char *) neighb);
		return False;

	default:
		PrintAtEmpire ("NextNeighbour called to often");
		Bell ();
		(void) EmpireMore ();
		return False;
	}
}

bool IsNeighbour (sct1, sct2)
Sector sct1, sct2;
{
	int dx, dy;

	dx = EX (s_xcd (sct2) - s_xcd (sct1));
	dy = EY (s_ycd (sct2) - s_ycd (sct1));
	
	return ((dx == -1 || dx == 1) || (dy == -1 && dy == 1)) ||
		(dy == 0 && (dx == -2 || dx == 2));
}

	/* Give char for moving from sct1 to sct2 */

char GiveDirChar (sct1, sct2)
Sector sct1, sct2;
{
	int dx, dy;

	dx = EX (s_xcd (sct2) - s_xcd (sct1));
	dy = EY (s_ycd (sct2) - s_ycd (sct1));

	if      ((dx ==  2) && (dy ==  0))	return 'j';
	else if ((dx == -2) && (dy ==  0))	return 'g';
	else if ((dx ==  1) && (dy ==  1))	return 'n';
	else if ((dx ==  1) && (dy == -1))	return 'u';
	else if ((dx == -1) && (dy ==  1))	return 'b';
	else if ((dx == -1) && (dy == -1))	return 'y';
	else if ((dx ==  0) && (dy ==  0))	return 'h';
	else
	{
		PrintAtEmpire (Fmt ("Bad dist (%d, %d) for %s and %s",
							dx, dy,
							CrdStr (sct1),
							CrdStr (sct2)));
						return '?';
	}
}

Sector MoveInDirection (sct, dir, flag)
Sector sct;
char dir;
int flag;
{
	int x, y;

	x = s_xcd (sct);
	y = s_ycd (sct);

	switch (dir)
	{

	case 'y':	return World (x - 1, y - 1, flag);
	case 'u':	return World (x + 1, y - 1, flag);
	case 'g':	return World (x - 2, y, flag);
	case 'j':	return World (x + 2, y, flag);
	case 'b':	return World (x - 1, y + 1, flag);
	case 'n':	return World (x + 1, y + 1, flag);
	default:	return sct;

	}
}

bool IsCoast (sct)
Sector sct;
{
	Sector nxt;
	Neighb neighb;

	if (s_des (sct) == '.' || s_des (sct) == '=')
		return False;

	InitNeighbours (sct, & neighb);

	while (NextNeighbour (&nxt, S_EXIST, neighb))
		if (nxt != (Sector) 0 &&
				(s_des (nxt) == '.' || s_des (nxt) == '='))
			return True;

	return False;
}

bool NearSeaOrHarbor (sct)
Sector sct;
{
	Sector nxt;
	Neighb neighb;

	InitNeighbours (sct, & neighb);
	while (NextNeighbour (&nxt, S_EXIST, neighb))
		if (nxt != (Sector) 0 && 
				(s_des (nxt) == '.' || s_des (nxt) == 'h'))
			return True;

	return False;
}


bool UpdateSectorDes (sct, des, force)
Sector sct;
char des;
bool force;
{
	if (DesignName (des) == (char *) 0)
	{
		PrintAtEmpire (
			Fmt ("Warning Illegal des %d (at %s, info 0x%x)",
			des, CrdStr (sct), s_inf (sct)));
		return False;
	}

	if (NO_INFO (sct))
	{
		set_des (sct, des);
		set_owner (sct, UNKNOWN_CNUM);
		SET_INFO_DES (sct);
		return True;
	}

  	if (des == '.' && force)
  	  /* Migth have been bridge span, but which is now collapsed */
	  /* rad scan gives . for ships places with force=false */
  	  /* KH 12-11-90 */
  	{
  	    set_des (sct, des);
  	    set_owner (sct, 0);
  	    SET_INFO_DES (sct);
  	    return True;
  	}

  	if ((des == '?') && (s_des (sct) == '.' ))
  	  /* Must be a new bridge span*/
  	  /* KH 12-11-90 */
  	{
  	    set_des (sct, '=');
  	    set_owner (sct, UNKNOWN_CNUM);
  	    SET_INFO_DES (sct);
  	    return True;
  	}
  
/*
 * kludge to make satellites work
 * if scanning_satellites set,then bail out, because we know
 * exactly what is here
 */
	if (s_owned (sct) && scanning_satellites && des == '?')
	   return True;

	if (s_owned (sct))
	{
		if (s_des (sct) != des && des != '.')
		{
				/* break sanctury */
			if (s_des (sct) == 's' && des == 'c')
			{
				set_des (sct, des);
				set_nds (sct, des);
				return True;
			}

			if (KNOW_ALL (sct) && des == s_nds (sct))
			{
				set_des (sct, des);
				return True;
			}

			set_owner (sct, UNKNOWN_CNUM);
			DEL_INFO (sct);
			SET_INFO_RES (sct);
			PrintAtEmpireMode (Fmt (
			       "Design form sector %s changed from %c to %c",
			       CrdStr (sct), s_des (sct), des), BOLD);
			PrintAtEmpireMode (
			       "Assuming it has been lost/captured", BOLD);
/* mta Sat Mar 16 17:38:11 EET 1991
 * we should make something that this is called once or twice...
 */
/*			Bell (); */
			set_des (sct, des);
			if (KNOW_ALL (sct))
				set_nds (sct, des);
		}
		return True;
	}

	if (des == '?')
	{
	        if ((s_des (sct) == '-' ) ||
		   (! KNOW_SPY (sct) && ! KNOW_LOO (sct)  && ! KNOW_DES (sct)))
			set_des (sct, des);
	}
	else if (des != '.' || force)
			set_des (sct, des);

	return True;
}


char *SelectRealm (mes1, mes2)
char *mes1, *mes2;
{
	Sector sct1, sct2;
	int x1, y1, x2, y2;
	int button;

	RaiseWindow (map_win);
	UnmarkSector (cursct);
	Message (Fmt ("Please Select %s sector", mes1));
	MesBut ("View", "Cancel", "Set");

	do {
		if (! SelectSctCrd (& x1, & y1, & button) ||
		    button == MIDDLE_BUTTON)
		{
			interrupt = False;
			MesClearBut ();
			MarkSector (cursct);
			ClearMes ();
			LowerWindow (map_win);
			return (char *) 0;
		}

		if (button == LEFT_BUTTON)
		{
			CensusSct (World (x1, y1, S_EXIST));
		} else
		{
			/* if it did'nt exists it will be created */
			sct1 = World (x1, y1, S_DESIG);
		}


	} while (button != RIGHT_BUTTON || sct1 == (Sector) 0);

	MarkSector (sct1);

	Message (Fmt ("(%d, %d) Please select %s sector", 
			s_xcd (sct1), s_ycd (sct1), mes2));

	do {
		if (! SelectSctCrd (& x2, & y2, & button) ||
		    button == MIDDLE_BUTTON)
		{
			interrupt = False;
			UnmarkSector (sct1);
			MarkSector (cursct);
			MesClearBut ();
			ClearMes ();
			if (NO_INFO (sct1))
				FreeSector (sct1);
			LowerWindow (map_win);
			return (char *) 0;
		}

		if (button == LEFT_BUTTON)
		{
			CensusSct (World (x2, y2, S_EXIST));
		} else
		{
			/* if it did'nt exists it will be created */
			sct2 = World (x2, y2, S_DESIG);
		}
	} while (button != RIGHT_BUTTON || sct2 == (Sector) 0);

	MarkSector (sct2);

	Message (Fmt ("Confirm %s %s sector and %s %s sector",
			CrdStr (sct1), mes1, CrdStr (sct2), mes2));

	MesBut ("DO", "Cancel", "DO");
	(void) WaitButtonPress (&button);

	ClearMes ();
	MesClearBut ();
	UnmarkSector (sct1);
	UnmarkSector (sct2);
	MarkSector (cursct);

	if (NO_INFO (sct1))
		FreeSector (sct1);
	if (NO_INFO (sct2))
		FreeSector (sct2);

	LowerWindow (map_win);

	if (button != MIDDLE_BUTTON && !interrupt)
		return Fmt ("%d:%d,%d:%d", x1, x2, y1, y2);
	else
	{
		interrupt = False;
		return (char *) 0;
	}
}

void RealmSetThreshold (mx, my)
int mx, my;
{
	char *realm, *itemname, *ptr;
	int newvalue;
	int sx, sy, ex, ey, x, y, nr1, nr2, length, width;
	int item;
	char itemchar;
	Sector sct;
	int changed;

	item = SelectSellItem (mx, my, "Threshold for ?");

	if (item < 0)
	{
		Message ("Setting threshold cancelled");
		return;
	}

	itemchar = ItemChar (item);
	itemname = ItemName (item);

	ptr = InputAtMessage (Fmt ("New threshold for %s ?", itemname),
			4, GS_PNUMBER);

	if (ptr == (char *) 0 || *ptr == '\0')
	{
		Message ("Setting threshold cancelled");
		return;
	}

	newvalue = atoi (ptr);

	realm = SelectRealm ("upper-left", "lower-right");
	if (realm == (char *) 0)
	{
		Message ("Setting threshold cancelled");
		return;
	}

	(void) sscanf (realm, "%d:%d,%d:%d", &sx, &ex, &sy, &ey);

	width = XDIST (sx, ex) + 1;
	length = YDIST (sy, ey) + 1;

	changed = 0;
	for (x = sx, nr1 = 0; nr1 < width; nr1++, x ++)
		for (y = sy, nr2 = 0; nr2 < length; nr2++, y++) 
			if ((x + y) % 2 == 0)
			{
				sct = World (x, y, S_EXIST);
				if (sct != (Sector) 0 && s_owned (sct))
				{
					SetThreshold (sct, itemchar, newvalue);
					DrawSector (sct);
					changed ++;
				}
			}

	if (changed == 0)
	{
		Message ("No tresholds changed");
		Bell ();
		return;
	}

	FeedCommand (Fmt ("threshold %c %s %d", itemchar, realm, newvalue),
						PRINT);

	Message (Fmt ("%d thresholds for %s %s",
		changed,
		itemname,
		(newvalue == 0) ? "deleted" : "changed"));
}

void WipeThreshold ()
{
	char *realm;
	int x, y, sx, ex, sy, ey, nr1, nr2, changed, length, width;
	Sector sct;

	realm = SelectRealm ("upper-left", "lower-right");
	if (realm == (char *) 0)
	{
		Message ("Wipe threshold cancelled");
		return;
	}

	(void) sscanf (realm, "%d:%d,%d:%d", &sx, &ex, &sy, &ey);

	width = XDIST (sx, ex) + 1;
	length = YDIST (sy, ey) + 1;

	changed = 0;
	for (x = sx, nr1 = 0; nr1 < width; nr1++, x ++)
		for (y = sy, nr2 = 0; nr2 < length; nr2++, y++) 
			if ((x + y) % 2 == 0)
			{
				sct = World (x, y, S_EXIST);
				if (sct != (Sector) 0 && s_owned (sct))
				{
					SetThreshold (sct, 'a', 0);
					changed ++;
				}
			}

	if (changed == 0)
	{
		Message ("No tresholds changed");
		Bell ();
		return;
	}

	FeedCommand (Fmt ("wipe %s", realm), PRINT);

	Message (Fmt ("%d sectors wiped", changed));

	DrawMap ();
}

void RedumpSector (sct, flag)
Sector sct;
int flag;
{
	(void) FScanDump (CrdStr (sct), flag);
	DrawSector (sct);
}

int origin_x = 0;
int origin_y = 0;

void ChangeOrigin (sct)
Sector sct;
{
	char *answer, *line;
	extern char *progname;
	extern bool save_data;

	Bell ();
	answer = InputAtMessage (Fmt
			("Are You sure you want to change origin to %s ?",
			CrdStr (sct)), 1, GS_NAME);
	
	if (interrupt || answer == (char *) 0 ||
				*answer != 'y' && *answer != 'Y')
	{
		interrupt = False;
		Message ("Origin command cancelled");
		return;
	}

	/* To difficult to adjust all coordinates 
	 * I know it's ugly but it is very easy this way
	 * Let player restart with emptool -n
	 */

	SetSignalsOff ();
	FeedEmpire (Fmt ("origin %s", CrdStr (cursct)), PRINT);
	line = ReadEmpire (PRINT);
	if (EmpireStatus () != E_PRINTING ||
					strncmp (line, "Origin at", 9) != 0)
	{
		PrintAtEmpire (line);
		Message ("Origin command failed");
		Bell ();
		return;
	}

	origin_x = s_xcd (sct);
	origin_y = s_ycd (sct);

	StoreData ();
	save_data = False;
	(void) fprintf (stderr, line);
	(void) fprintf (stderr, "\nFast restart with \"%s -N\"\n", progname);
	leave ();
}


static int last_owner;

void RedoChangeOwner ()
{

 	set_owner (cursct, last_owner);
	DrawSector (cursct);
	Census ();
	Message (Fmt ("%s is now marked to be owned by %s", CrdStr (cursct),
		      CountryName(last_owner)));
      }


void ChangeOwner (sct)
Sector sct;
/* we can guess the owner of the sector or we might have gotten the info
   from somebody */

{
	char *ptr;
	int  new;

	DeityChange (sct);
	
	ptr = AskCountry (10, 10, "New owner ?", True);
	
	if (interrupt || ptr == (char *) 0)
	  {
	    interrupt = False;
	    Message ("changing owner cancelled");
	    Census ();
	    return;
	  }
	
	new = CountryId (ptr);

	last_owner = new;
	SetAgain (RedoChangeOwner);
	
 	set_owner (sct, new);
	if (NO_INFO(sct))
	  {
	    sct->inf=DES; /* should make macro */
	    set_des (sct, SCT_UNKNOW);
	  }

	DrawSector (sct);
	Census ();
	Message (Fmt ("%s is now marked to be owned by %s", CrdStr (sct),
		      CountryName(new)));
	

}
/* Fast hack. - heinola 9/11/91. */
void MultiChangeOwner ()
/* we can guess the owner of the sector or we might have gotten the info
   from somebody */

{
	char *ptr;
	int  new;
        char *realm;
	int sx, sy, ex, ey;
	register int x, y;
	register Sector sct;
	int nr;


	Message ("Select realm, which owner is set");
	if ((realm = MySelRealm ()) == (char *) 0) 
	  {
	    return;	
	  }

	ptr = AskCountry (10, 10, "New owner ?", True);
	
	if (interrupt || ptr == (char *) 0)
	  {
	    interrupt = False;
	    Message ("Changing owner cancelled");
	    Census ();
	    return;
	  }
	
	new = CountryId (ptr);
	

	if (! ConvRealmToCoord (realm, & sx, & sy, & ex, & ey))
	{	
		Panic ("MultiChangeOwner", "mics/sector.c",
			"Illegal realm");
		return;
	}

	nr = 0;
	for (y = sy; y <= ey; y ++)
		for (x = sx; x <= ex; x++)
		{
			sct = World (x, y, S_EXIST);

			if (sct == (Sector) 0) {

			 /* we are editing map */
			  if ((x + y) % 2 == 0)
			    {
			      sct = World (x, y, S_DESIG);
			      set_owner (sct, new);
			      if (NO_INFO(sct))
				{
				  sct->inf=DES; /* should make macro */
				  set_des (sct, SCT_UNKNOW);
				}
			      continue;
			    }
			    else
			      {
				continue;
			      }
			}
			set_owner (sct, new);
			if (NO_INFO(sct))
			  {
			    sct->inf=DES; /* should make macro */
			    set_des (sct, SCT_UNKNOW);
			  }
			if (AtScreen (x, y))
			  DrawSector (sct);
		      }

	DrawMap;
	ClearMes ();
	Census ();
	Message (Fmt ("%s is now marked to be owned by %s", realm, CountryName(new)));
}

void Cede (sct)
Sector sct;

{
	char *ptr;
	int  new;

	DeityChange (sct);
	
	ptr = AskCountry (10, 10, "New owner ?", True);
	
	if (interrupt || ptr == (char *) 0)
	  {
	    interrupt = False;
	    Message ("cede cancelled");
	    Census ();
	    return;
	  }
	
	new = CountryId (ptr);
	if (CountryName (new) == CountryName (s_owner (sct))) {
		Message ("Huh... ");
		return;
	}

	last_owner = new;
	
	FeedCommand ( Fmt ("cede %s %s", CrdStr (sct), CountryName (new)), PRINT);
	RedumpSector (sct);
	DrawSector (sct);
	Census ();
	Message (Fmt ("%s is ceded to %s", CrdStr (sct),
		      CountryName(new)));
	

}

void SingleStart (sct)
Sector sct;
{
	FeedCommand ( Fmt ("start %s", CrdStr (sct)), PRINT);
	set_off (sct, False);
	Message ( Fmt ("%s at %s started", DesignName (s_des (sct)), CrdStr (sct)));
}

void SingleStop (sct)
Sector sct;
{
	FeedCommand ( Fmt ("stop %s", CrdStr (sct)), PRINT);
	set_off (sct, True);
	Message ( Fmt ("%s at %s stopped", DesignName (s_des (sct)), CrdStr (sct)));
	Bell();
}

Sector World (x, y, known)
int x, y;
int known;
{
	Sct2 sct2;
	Sct3 sct3;
	Sector sct;
	int ix, iy;

	/*
	 *	On a 64 by 64 world
	 *
	 *       -2  -1  0   1   2
	 *    +---------------------
	 *    |
	 * -2 | 62,31	0,31	2,31
	 *    |
	 * -1 |     63,31   1,31
	 *    |
	 *  0 | 62,0    0,0     2,0
	 *    |
	 *  1 |     63,0    1,0
	 *    |
	 *  2 | 62,1    0,1     2,1
	 *    +---------------------
	 */

	if ((x + y) % 2 != 0)
		return (Sector) 0;

	ix = WX (x);
	iy = WY (y) / 2;

	sct = world [ix] [iy];

	if (known == S_EXIST)
		return sct;

	if (world [ix] [iy] == (Sector) 0)
	{
			/* allocate sector */

		sct = (Sector) doalloc ((unsigned) sizeof (struct s_sector1));

		bzero ((char *) sct, sizeof (struct s_sector1));
			
		world [ix] [iy] = sct;
		set_xcd (sct, EX (x));
		set_ycd (sct, EY (y));
		set_des (sct, ' ');
		DEL_INFO (sct);
		set_owner (sct, UNKNOWN_CNUM);
	}

	if (known == S_DESIG)
		return sct;

	if (sct-> sct2 == (Sct2) 0)
	{
			/* allocate second part */

		sct2 = (Sct2) doalloc ((unsigned) sizeof (struct s_sector2));
		bzero ((char *) sct2, sizeof (struct s_sector2));
		sct-> sct2 = sct2;
	}

	if (known == S_RESOU)
		return sct;

	if (sct-> sct2-> sct3 == (Sct3) 0)
	{
			/* allocate third part */

		sct3 = (Sct3) doalloc ((unsigned) sizeof (struct s_sector3));
		bzero ((char *) sct3, sizeof (struct s_sector3));
		sct-> sct2-> sct3 = sct3;
		set_nds (sct, ' ');
	}

	return sct;
}

void FreeSector (sct)
Sector sct;
{
	int ix, iy;

	if (sct == (Sector) 0)
		return;

	ix = WX (s_xcd (sct));
	iy = WY (s_ycd (sct)) / 2;

	if ((ix + iy*2) % 2 != 0) /* impossible !! */
		return;

	if (KNOW_ALL (sct) || KNEW_ALL (sct))
		free (sct-> sct2-> sct3);
	
	if (KNOW_SPY (sct) || KNOW_LOO (sct))
		free (sct-> sct2);

	free (world [ix] [iy]);

	world [ix] [iy] = (Sector) 0;
}
	
void Check ()
{
	int x, y;
	double need;
	int pop;
	int nr;
	Strings strings;
	Strings plague;
	Strings happy;
	Strings empty_ships;
	Strings enemy_ships;
	Strings enemy_lands;
	Strings enemy_planes;
	Sector sct;
	Ship ship;
	Land land;
	double pch;

        int     newciv;
        int     newuw;
        int     new_birth;
        int     new_food;

        newciv = 0;
        newuw = 0;


	strings = InitStrings ();
	plague = InitStrings ();
	happy = InitStrings ();
	empty_ships = InitStrings ();
	enemy_ships = InitStrings ();
	enemy_lands = InitStrings ();
	enemy_planes = InitStrings ();

	Message ("Generating check list");

	AddString (strings, DateFmt (time ((time_t *) 0)));
	AddString (strings, "");
	AddString (strings, "Food in sectors:");
	AddString (strings, "----------------");
	AddString (strings, "");

	nr = 0;

	for (x = 0; x < MAX_X; x ++)
	for (y = x % 2; y < MAX_Y; y += 2)
	{
		sct = World (x, y, S_EXIST);

		if (sct == (Sector) 0 || ! KNOW_ALL (sct))
			continue;
		
		pop = q_uw (sct) + s_civ (sct) + s_mil (sct);

		need =  ((double) pop) * etu_per_update * eatrate;

		if (need <= 1.0)
			continue;

		if (((int) (need + .99)) > q_foo (sct))
		{
			nr ++;
			AddString (strings, Fmt (
				"%s @ %s: pop = %d, has %d, need %.2f food",
				DesignName (s_des (sct)),
				CrdStr (sct),
				pop,
				q_foo (sct), need));
		}

		if ((pch = PlagueChance (sct)) > 0.0)
			AddString (plague, Fmt ("%s @ %s: %.4f",
				DesignName (s_des (sct)),
				CrdStr (sct),
				pch));
		if (!IsHappy(sct) && ((s_civ (sct)/20)> s_mil (sct)))
			AddString (happy, Fmt ("%s @ %s",
				DesignName (s_des (sct)),
				CrdStr (sct)));
	}

	if (nr == 0)
		AddString (strings, "All sectors OK");
	AddString (strings, "");

	AddString (strings, "Civilian & UW Growth:");
	AddString (strings, "---------------");
	AddString (strings, "");

	nr = 0;

	for (x = 0; x < MAX_X; x ++)
	for (y = x % 2; y < MAX_Y; y += 2)
	{
                sct = World (x, y, S_EXIST);

                if (sct == (Sector) 0 || ! KNOW_ALL (sct))
                        continue;
        	if(s_civ(sct) == max_civ_uw) {
            		AddString(strings,
                      		  Fmt("Civilians in %s at %d will not grow.",
                           		CrdStr(sct), s_civ(sct)));
		nr ++;
        	}

        	if(q_uw(sct) == max_civ_uw) {
            		AddString(strings,
                      		  Fmt("Slaves in %s at %d will not grow.",
                           		CrdStr(sct), q_uw(sct)));
		nr ++;
        	}
        	if (s_civ (sct) < max_civ_uw)
        	{
                	new_birth = roundavg (obrate * (double) (etu_per_update * s_civ (sct)));
                	new_food = (int) (0.5 + q_foo (sct) / (2.0 * babyeat));
                	newciv = new_birth;
                	if (newciv > new_food) {
				  AddString(strings,
					Fmt("%s @ %s: maxciv = %d, has food for %d, need %.2f food",
					DesignName (s_des (sct)),
					CrdStr (sct),
					newciv,
					new_food,(new_food - newciv)));
                        	newciv = new_food;
				nr ++;
				}
			if((newciv + s_civ(sct)) > max_civ_uw) {
            			AddString(strings,
                      		  Fmt("Civs in %s at %d (max %d)",
                           		CrdStr(sct), (newciv+s_civ(sct)),max_civ_uw));
				nr ++;
				}
        	}

        	if (q_uw (sct) < max_civ_uw)
        	{
                	new_birth = roundavg (uwbrate * (double) (etu_per_update * q_uw (sct)));
                	new_food = (int) (0.5 + q_foo (sct) / (2.0 * babyeat));
                	newuw = new_birth;
                	if (newuw > new_food) {
				  AddString(strings,
					Fmt("%s @ %s: maxuw = %d, has food for %d, need %.2f food",
					DesignName (s_des (sct)),
					CrdStr (sct),
					newuw,
					new_food, (new_food - newuw)));
                        	newuw = new_food;
				nr ++;
				}
			if((newuw + q_uw(sct)) > max_civ_uw) {
            			AddString(strings,
                      		  Fmt("UWs in %s at %d.",
                           		CrdStr(sct), (newuw+q_uw(sct))));
				nr ++;
				}
        	}

	}
	if (nr == 0)
		AddString (strings, "All sectors OK");
	AddString (strings, "");

	AddString (strings, "Food at ships:");
	AddString (strings, "--------------");
	AddString (strings, "");

	nr = 0;

	for (ship = shiplist; ship != (Ship) 0; ship = sh_next (ship))
	{
		if (! sh_owned (ship))
		{
			AddString (enemy_ships, Fmt ("%s #%d @ %d,%d (%s)",
				ShipName (ship),
				sh_nr (ship),
				sh_xcd (ship),
				sh_ycd (ship),
				CountryName (sh_owner (ship))));

			continue;
		}

		pop = sh_uw (ship) + sh_civ (ship) + sh_mil (ship);

		sct = World (sh_xcd (ship), sh_ycd (ship), S_EXIST);

		if (pop == 0)
		{
			AddString (empty_ships, Fmt (
					"%s #%d %d%% eff @ %d,%d: crewless%s",
				ShipName (ship),
				sh_nr (ship),
				sh_eff (ship),
				sh_xcd (ship),
				sh_ycd (ship),
				sct == (Sector) 0 ? 
					" (sector unknown)" :
					s_des (sct) == 'h' ?
						" (docked)" :
						""));

				/* They don't eat that much */

			continue;
		}

		need =  ((double) pop) * etu_per_update * eatrate;

		if (((int) (need + .99)) > sh_foo (ship))
		{
			nr ++;
			AddString (strings, Fmt (
			     "%s #%d @ %d,%d: pop = %d, has %d, need %.2f food",
				ShipName (ship),
				sh_nr (ship),
				sh_xcd (ship), sh_ycd (ship),
				pop,
				sh_foo (ship), need));
		}
	}

	if (nr == 0)
		AddString (strings, "All ships OK");
	AddString (strings, "");

	if (land_units) {
		AddString (strings, "Food at Units:");
		AddString (strings, "--------------");
		AddString (strings, "");

		nr = 0;

		for (land = landlist; land != (Land) 0; land = ld_next (land))
		{
			if (! ld_owned (land))
			{
				AddString (enemy_lands,  Fmt ("%s #%d @ %d,%d (%s)",
					LandName (land),
					ld_nr (land),
					ld_xcd (land),
					ld_ycd (land),
					CountryName (ld_owner (land))));

				continue;
			}

			pop = landtypes [ ld_type (land)] .mil * 100 / ld_eff (land);

			sct = World (ld_xcd (land), ld_ycd (land), S_EXIST);

			need = ((double) pop) * etu_per_update * eatrate;

			if (((int) (need + .99)) > ld_foo (land))
			{
				nr ++;
				AddString (strings, Fmt (
				   "%s #%d @ %d,%d: pop = %d, has %d, need %.2f food",
					LandName (land),
					ld_nr (land),
					ld_xcd (land),
					ld_ycd (land),
					pop,
					ld_foo (land), need));
			}
		}
		if (nr == 0)
			AddString (strings, "All Units OK");
		AddString (strings, "");
	}

		/*
		 *	Plague
		 */

	AddString (strings, "Sectors with a plague chance:");
	AddString (strings, "-----------------------------");
	AddString (strings, "");

	if (StringsSize (plague) == 0)
		AddString (strings, "All sectors OK");
	else
		JoinStrings (strings, plague);

	FreeStrings (plague);
	AddString (strings, "");


		/*
		 *	happines
		 */

	AddString (strings, "Sectors with a possible uprising:");
	AddString (strings, "-----------------------------");
	AddString (strings, "");

	if (StringsSize (happy) == 0)
		AddString (strings, "All sectors OK");
	else
		JoinStrings (strings, happy);

	FreeStrings (happy);
	AddString (strings, "");

		/*
		 *	crewless ships
		 */

	AddString (strings, "Empty ships:");
	AddString (strings, "------------");
	AddString (strings, "");

	nr = 0;

	if (StringsSize (empty_ships) == 0)
		AddString (strings, "All ships OK");
	else
		JoinStrings (strings, empty_ships);

	AddString (strings, "");
	FreeStrings (empty_ships);

		/*
		 *	Enemy ships
		 */

	AddString (strings, "Enemy ships:");
	AddString (strings, "------------");
	AddString (strings, "");

	if (StringsSize (enemy_ships) == 0)
		AddString (strings, "No ships.");
	else
		JoinStrings (strings, enemy_ships);

	AddString (strings, ""); 
	FreeStrings (enemy_ships);

		/*
		 *      Enemy Units
		 */

	if (land_units) {
		AddString (strings, "Enemy Units:");
		AddString (strings, "------------");
		AddString (strings, "");

		if (StringsSize (enemy_lands) == 0)
			AddString (strings, "No units.");
		else
			JoinStrings (strings, enemy_lands);

		/* AddString (strings, ""); */
		FreeStrings (enemy_lands);
	}

		/*
		 *	Show it
		 */


	Message ("List ready");
	if (util_mode)
		ShowStrings (strings);
	else
#ifdef X_VERSION
		InitWMPager (strings, "World check");
#else 
		ShowStringsInPager (strings, "World check");
#endif /* X_VERSION */
		
}

void Goto (sct)
Sector sct;
{
	int x, y;
	int i;

	if (sct == (Sector) 0)
		return;

	x = s_xcd (sct);
	y = s_ycd (sct);

	SetCurrent (sct);

	if (! AtScreen (x, y))
		CenterMap (x, y);

	for (i = 5; i > 0; i --)
	{
#ifdef X_VERSION
		ShowBox (x - i,  y - i, x + i, y + i);
#endif /* X_VERSION */
		FlushWindow (map_win);
#ifdef X_VERSION
		ShowBox (x - i, y - i, x + i, y + i);
#endif /* X_VERSION */
		FlushWindow (map_win);
	}
}
		
	
void GotoStr (str)
char * str;
{
	Sector sct;
	char * ptr, * ptri;
	int x, y;

	ptr = index (str, ',');
	while (ptr != (char *) 0)
	{
		ptri = ptr - 1;
		while (ptri > str && isspace (* ptri))
			ptri --;
		while (ptri > str && isdigit (* ptri))
			ptri --;

		if (ptri > str && * ptri != '-')
			ptri ++;

		if (sscanf (ptri, " %d , %d ", & x, & y) == 2)
		{
			if ((x + y) % 2 == 1)
			{
				Message (Fmt ("Illegal sector: %d,%d", 
							x, y));
				return;
			}

			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
			{
				if (deity)
				{
					sct = World (x, y, S_DESIG);
					DeityChange (sct);
				}
				else
				{
					Message (Fmt ("No info about %d,%d",
							x, y));
					return;
				}
			}

			Goto (sct);
			return;
		}

		ptr = index (ptr + 1, ',');
	}
}
