/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/misc/RCS/path.c,v 5.1 93/03/14 16:49:37 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:49:37 $
    $Author: etienne $
    $Id: path.c,v 5.1 93/03/14 16:49:37 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	path.c,v $
 * Revision 5.1  93/03/14  16:49:37  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:49  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:37:47  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"

#define	MAX_DISTLEN	9
#define MAX_PATHLEN	70

/* I don't think DIST is right
 * take 0,0 and 4,4 on a 64x64 world
 * DIST :
 *	ABS (EX (4 - 0)) + ABS (EY (4 - 0))
 *	EX (4) = WX (4) > 64/2 ? WX (4) - 64 : WX(4);
 *	WX (4) = (4 + 2*64) % 64 = 132 % 64 = 4;
 *	EX (4) = 4 > 32 ? 4 - 64 : 4 = 4
 *
 *	ABS (4) + ABS (4) = 4 + 4 = 8 !!!
 * while actualy distance is 4 (4 times n in 0,0 takes you to 4, 4)
 *
 * actualy DIST would be a terribly complicated !!!
 * dist between -4, 4 and 0,0 = 4 sectors
 * but between  2, -4 and 0,0 = 4 sectors also !!
 *		    5 5 5 5 5 5
 *		   5 4 4 4 4 4 5
 *		  5 4 3 3 3 3 4 5
 *		 5 4 3 2 2 2 3 4 5
 *		5 4 3 2 1 1 2 3 4 5
 *	       5 4 3 2 1 0 1 2 3 4 5 6 7 8
 *		5 4 3 2 1 1 2 3 4 5 6 7 8
 *		 5 4 3 2 2 2 3 4 5 6 7 8
 *		  5 4 3 3 3 3 4 5 6 7 8
 *		   5 4 4 4 4 4 5 6 7 8
 *		    5 5 5 5 5 5 6 7 8
 *		   6 6 6 6 6 6 6 7 8
 *		    7 7 7 7 7 7 7 8
 *		   8 8 8 8 8 8 8 8 9 0
 *			      9 9 9 0
 *			       0 0 0
 *
 * ABS (y) < ABS (x) ? (ABS(x) + ABS(y))/2 : ABS(y)
 * shit dat koste 1.5 uur om uit te zoeken !!!!!!.
 * ahmmm, wasn't that complicated after all
 *
 * #define DIST(sct1,sct2) ABS (EX (s_xcd (sct1) - s_xcd (sct2))) + \
 * 			ABS (EY (s_ycd (sct1) - s_ycd (sct2)))
 * 
 */

typedef struct s_list *List;

struct s_list
{
	Sector sct;
	int dist;
	int length;
	double mcost;
	char path [MAX_PATHLEN];
	List next;
};

	/* Regard efficiency: */

#define BP_SCTEFF	0	/* s_eff (sct)				*/
#define	BP_MAXEFF	1	/* 100					*/

	/* static variables */

static Sector goal;	/* where are we heading for		*/
static List slist;	/* all the open sectors			*/
static int maxlength;	/* maxlength of the path		*/
static int eff;	/* regard efficiency ??			*/
static bool unknown = False;

static void FreeList ()
{
	List ptr, tofree;

	for (ptr = slist; ptr != (List) 0; )
	{
		tofree = ptr;
		ptr = ptr-> next;
		if (NO_INFO (tofree-> sct))
			FreeSector (tofree-> sct);
		free ((char *) tofree);
	}

	slist = (List) 0;
}

static void AddToList (sct, from)
Sector sct;
List from;
{
	List ptr, prv;
	List new;
	int x, y;
	register char *path;
	bool insert_here;
	double savemcost;

		/* Make new structure */

	new = (List) doalloc ((unsigned) sizeof (struct s_list));
	new-> sct = sct;

	if (from == (List) 0)
	{
		new-> mcost = 0.0;
		new-> length = 0;
		new-> dist = 0;
		new-> path [0] = '\0';
		new-> dist = 0;
	}
	else
	{
		(void) strcpy (new-> path, from-> path);
		new-> length = from-> length;
		new-> path [new-> length] = GiveDirChar (from-> sct, sct);
		new-> path [++ (new-> length)] = '\0';
		savemcost = KNOW_ALL (sct) ?
			((eff == BP_SCTEFF) ?
				MoveCost (s_des (sct), s_eff (sct)) :
				MoveCost (s_nds (sct), 100)) :
			MoveCost (s_des (sct), 100);

		new-> mcost = from-> mcost + savemcost;
	}


	if (slist == (List) 0)
	{
		slist = new;
		new-> next = (List) 0;
		return;
	}

	new-> dist = Distance (sct, goal);
				
	path = new-> path + new-> length;

	for (x = 0, y = 0, path = new-> path + new-> length - 1;
	     path >= new-> path;
	     path --)
        {
		switch (*path)
		{

		case 'g':
			x -= 2;
			break;

		case 'j':
			x += 2;
			break;

		case 'y':
			x --;
			y --;
			break;

		case 'u':
			x ++;
			y --;
			break;

		case 'b':
			x --;
			y ++;
			break;

		case 'n':
			x ++;
			y ++;
			break;
		}

		if (x == 0 && y == 0)
		{
			free ((char *) new);
			return;
		}
	}

	/* 
	 *	First scan the whole list:
	 *
	 *	If mcost (new sector) >= mcost (sector of list) &&
	 *	   length (new sector) >= length (sector of list)
	 *		then ignore this sector.
	 *
	 *	If mcost (new sector) <= mcost (sector in list) &&
	 *	   length (new sector) <= length (sector of list)
	 *		then delete this sector from the list 
	 *
	 *	After this add the sector at the proper place into the list.
	 */


	for (prv = (List) 0, ptr = slist; ptr != (List) 0; ptr = ptr-> next)
	{
		if (ptr-> sct == sct)
		{
			if (maxlength == MAX_DISTLEN)
			{
				if (new-> mcost >= ptr-> mcost && 
				    new-> length >= ptr->length)
			        {
					free ((char *) new);
					return;
				}


				if (new-> mcost <= ptr-> mcost &&
				    new-> length <= ptr-> length)
			    	{
					/* remove from list */
				
					if (prv == (List) 0)
						slist = ptr-> next;
					else
						prv-> next = ptr-> next;
	 
					free ((char *) ptr);
					break;
				}
			}
			else
			{
				if (new-> mcost > ptr-> mcost  ||
				    (new-> mcost == ptr-> mcost &&
				     new-> length >= ptr->length))
			        {
					free ((char *) new);
					return;
				}
				else
				{
					if (prv == (List) 0)
						slist = ptr-> next;
					else
						prv-> next = ptr-> next;
	 
					free ((char *) ptr);
					break;
				}
			}
		}
		prv = ptr;
	}

	prv = (List) 0;
	insert_here = False;
	for (ptr = slist; ptr != (List) 0; prv = ptr, ptr = ptr-> next)
	{
		if (new-> mcost > ptr-> mcost)
			continue;

		insert_here = new-> mcost < ptr-> mcost;

		if (! insert_here)
			insert_here = new-> length < ptr-> length;

		if (insert_here)
		{
			if (prv == (List) 0)
			{
				new-> next = ptr;
				slist = new;
				return;
			}
			else
			{
				prv-> next = new;
				new-> next = ptr;
				return;
			}
		}
	}

	if (prv == (List) 0) 
		slist = new;
	else
		prv-> next = new;

	new-> next = (List) 0;
}

static char *CheapestPath (from, to)
Sector from, to;
{
	List cur;
	Sector nxt;
	static char buf [MAX_PATHLEN];
	Neighb neighb;

	slist = (List) 0;
	goal = to;

	if (Distance (from, to) > maxlength)
		return (char *) 0;

	AddToList (from, (List) 0);

	while (slist != (List) 0)
	{
		cur = slist;
		slist = slist-> next;

#ifdef X_VERSION
		HandelWaitingEvents ();
#endif /* X_VERSION */
		if (interrupt)
		{
			free ((char *) cur);
			FreeList ();
#ifdef X_VERSION
			WaitRefresh (True);
#endif /* X_VERSION */
			return (char *) 0;
		}

		InitNeighbours (cur-> sct, & neighb);
		while (NextNeighbour (&nxt, unknown ? S_DESIG : S_EXIST,
								neighb))
		{
			if (nxt == (Sector) 0)
				continue;

			if (nxt == goal)
			{
				(void) strcpy (buf, cur-> path);

				buf [cur-> length] = GiveDirChar (cur-> sct,
									nxt);
				buf [cur-> length + 1] = 0;

				free ((char *) cur);
				FreeList ();
				if (NO_INFO (cur-> sct))
					FreeSector (cur-> sct);
				return buf;
			} 

			if (cur-> length < maxlength)
			{
				if ((s_owned (nxt) || deity) &&
						s_des (nxt) != '.')
					AddToList (nxt, cur);
				else if (NO_INFO (nxt))
					FreeSector (nxt);
			}
		}

		if (NO_INFO (cur-> sct))
			FreeSector (cur-> sct);

		free ((char *) cur);
	}

	/* When we get here, the list will be empty and no path found */

	ClearMes ();
	return (char *) 0;
}

	/*
	 *	Here are the procecures which all simply call CheapestPath ()
	 */

char *BestLandPath (from, to)
Sector from, to;
{
	maxlength = MAX_PATHLEN;
	unknown = False;
	eff = BP_SCTEFF;

	return CheapestPath (from, to);
}

char *BestDistPath (from, to)
Sector from, to;
{
	maxlength = MAX_DISTLEN;
	unknown = False;
	eff = BP_MAXEFF;

	return CheapestPath (from, to);
}

char *BestTmpDistPath (from, to)
Sector from, to;
{
	maxlength = MAX_DISTLEN;
	unknown = False;
	eff = BP_SCTEFF;

	return CheapestPath (from, to);
}

char * ReversePath (path)
char * path;
{
	static char new_path [MAX_PATHLEN];
	int ind;

	ind = strlen (path);

	new_path [ind --] = '\0';

	while (* path != '\0')
	{
		switch (* path ++)
		{

		case 'g':
			new_path [ind --] = 'j';
			break;

		case 'y':
			new_path [ind --] = 'n';
			break;

		case 'u':
			new_path [ind --] = 'b';
			break;

		case 'j':
			new_path [ind --] = 'g';
			break;

		case 'n':
			new_path [ind --] = 'y';
			break;

		case 'b':
			new_path [ind --] = 'u';
			break;
		}
	}

	return new_path;
}
