/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/land/RCS/set.c,v 5.1 93/03/14 16:48:39 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:48:39 $
    $Author: etienne $
    $Id: set.c,v 5.1 93/03/14 16:48:39 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	set.c,v $
 * Revision 5.1  93/03/14  16:48:39  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"

void SetLand (land)
Land land;
{
	char * ans;
	int price;
	double mult;
	int i;

	if (! s_owned (land))
	{
		Message (
		    "For some strange reason you can only sell your own units");
		Bell ();
		return;
	}

	price = landtypes [ld_type (land)]. cos * ld_eff (land) / 100;
	for (i = 1; i < V_MAX; i ++)
		price += ProdCost (i) * GiveLandQuant (land, ItemChar (i));

	Bell ();
	ans = InputAtMessage (
	       Fmt ("Set at what price [cost you $%d]: ", price),
	       5, "*.0-9");
	
	if (ans == (char *) 0 || interrupt)
	{
		Message ("Set cancelled");
		return;
	}

	if (* ans == '*')
	{
		if (sscanf (ans + 1, "%lf", & mult) != 1)
		{
			Message ("Illegal entry, usage: '* mult'");
			Bell ();
			return;
		}

		price = (int) (price * mult);
	}
	else if (*ans == '\0')
	  ; /* price is set to default already */
	else
		price = atoi (ans);
		

	FeedCommand (Fmt ("set land %d %d", ld_nr (land), price), PRINT);
	Message (Fmt ("%s #%d set at $%d",
					LandName (land), ld_nr (land), price));
}
