/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/land/RCS/mark.c,v 5.1 93/03/14 16:47:37 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:47:37 $
    $Author: etienne $
    $Id: mark.c,v 5.1 93/03/14 16:47:37 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	mark.c,v $
 * Revision 5.1  93/03/14  16:47:37  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:18:30  greyhelm
 * y
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:47:37  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "sector.h"
#include "var.h"
#include "land.h"

extern Land 	NrToLand();

void UnmarkAllLands ()
{
	Land ptr;

	for ALL_LANDS (ptr)
		set_ld_marked (ptr, False);
}

void MarkLands (form)
char * form;
{
	Land ptr;
	int sx, sy, ex, ey;
	int nr;

	if (strcmp (form, "*") == 0)
	{
		for ALL_LANDS (ptr)
			set_ld_marked (ptr, True);

		return;
	}

	if (strlen (form) == 1 && (isalpha (* form) || * form == '~'))
	{
		for ALL_LANDS (ptr)
			if (ld_army (ptr) == * form)
				set_ld_marked (ptr, True);
		return;
	}

	if (ConvRealmToCoord (form, & sx, & sy, & ex, & ey))
	{
		for ALL_LANDS (ptr)
			if (ld_xcd (ptr) >= sx && ld_xcd (ptr) <= ex &&
			    ld_ycd (ptr) >= sy && ld_ycd (ptr) <= ey)
				set_ld_marked (ptr, True);
		return;
	}

	while (ScanDigit (& form, & nr))
	{
		ptr = NrToLand (nr);
		if (ptr != (Land) 0)
			set_ld_marked (ptr, True);
		if (* form == '/')
			form ++;
	}
}

int MinMobMarkedLands (land)
Land * land;
{
	Land ptr;
	bool found;
	int min;

	if (land != (Land *) 0)
		* land = (Land) 0;

	found = False;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			if (! found)
			{
				found = True;
				if (land != (Land *) 0)
					* land = ptr;
				min = ld_mob (ptr);
			}
			else if (ld_mob (ptr) < min)
			{
				min = ld_mob (ptr);
				if (land != (Land *) 0)
					* land = ptr;
			}
	
	if (! found)
		return -1;
	else
		return min;
}

bool LMarkedColocated ()
{
	Land ptr;
	bool found;
	int x, y;

	found = False;
	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			if (! found)
			{
				found = True;
				x = ld_xcd (ptr);
				y = ld_ycd (ptr);
			}
			else
				if (x != ld_xcd (ptr) || y != ld_ycd (ptr))
					return False;
	
	return True;
}

bool ArmyHasEngineer ()
{
	Land ptr;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr) && LandHas (ptr, L_ENGINEER))
				return True;
	
	return False;
}

Sector SctMarkedLands ()
{
	Land ptr;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			return World (ld_xcd (ptr), ld_ycd (ptr),
						S_EXIST);
	
	return (Sector) 0;
}

void CheckLands (what)
char * what;
{
	Land ptr, next;
	char buffer [1024];
	bool first;

	if (command_state == TEST_STATE)
		return;

	UnmarkAllLands ();
	MarkLands (what);
	(void) DumpLand (what, DONT_PRINT);
	buffer [0] = '\0';
	first = True;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
		{
			if (first)
			{
				first = False;
				strcat (buffer, Fmt ("%d", ld_nr (ptr)));
			}
			else
				strcat (buffer, Fmt ("/%d", ld_nr (ptr)));
		}
	
	if (first)
		return;
			
	DumpLand (buffer, DONT_PRINT);

	ptr = landlist;
	while (ptr != (Land) 0)
		if (ld_marked (ptr))
		{
			Error (Fmt ("You seem to have lost %s #%d",
					LandName (ptr),
					ld_nr (ptr)));
			next = ld_next (ptr);
			DeleteLand (ptr);
			ptr = next;
		}
		else
			ptr = ld_next (ptr);
}

int MaxLRadarMarked (lndnr)
int * lndnr;
{
	Land ptr;
	int max;
	int landnr;

	max = -1;
	landnr = -1;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			if (landtypes [ld_type (ptr)]. spy > max)
			{
				max = landtypes [ld_type (ptr)]. spy;
				landnr = ld_nr (ptr);
			}
	
	if (lndnr != (int *) 0)
		* lndnr = landnr;
	
	return max;
}
	
void LMoveMarkedTo (sct)
Sector sct;
{
	Land ptr;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			MoveLand (ptr, sct);
}

int BestMarkedLRadar ()
{
	int max;
	Land ptr;
	int landnr;

	max = -1;
	landnr = -1;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			if (landtypes [ld_type (ptr)]. rad > max)
			{
				max = landtypes [ld_type (ptr)]. rad;
				landnr = ld_nr (ptr);
			}

	return landnr;
}

int FirstMarkedLandnr ()
{
	register Land ptr;

	for ALL_LANDS (ptr)
		if (ld_marked (ptr))
			return ld_nr (ptr);
	
	return -1;
}

void DeleteMarkedEnemyLands ()
{
	register Land ptr;
	Land next;

	ptr = landlist;
	while (ptr != (Land) 0)
		if (ld_marked (ptr) && ! ld_owned (ptr))
		{
			next = ld_next (ptr);
			DeleteLand (ptr);
			ptr = next;
		}
		else
			ptr = ld_next (ptr);
}
