/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/data/RCS/data.c,v 5.1 93/03/14 16:46:44 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:46:44 $
    $Author: etienne $
    $Id: data.c,v 5.1 93/03/14 16:46:44 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	data.c,v $
 * Revision 5.1  93/03/14  16:46:44  etienne
 * *** empty log message ***
 * 
 * Revision 5.0  93/02/06  09:22:34  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:35:48  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
	/*
	 *	Empire Tool,	file: data.c		<900212>
	 *
	 *	RetrieveData ()
	 */

#include "type.h"
#include "main.h"
#include "xrc.h"
#include "sector.h"
#include "nation.h"
#include <sys/file.h>
#include <errno.h>

bool save_data = False;
extern int capitol_x, capitol_y;

static void RestoreScts (fp, bin_dump)
FILE *fp;
bool bin_dump;
{
	char buffer [BUFSIZ];
	Sector sct;
	int x, y, info;
	int nr;
	int mines;

	uchar des;
	int owner, fer, min, gol, ura, oil, eff, civ, mil;
	time_t infotime;

			/* info | x | y */

	if (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (sscanf (buffer, "capitol at %hd,%hd",
						&capitol_x, &capitol_y) != 2) {
			Bell ();
			PrintAtEmpire ("Bad capitol info");
			PrintAtEmpire ("");
		}
	} else
		return;

	while (fgets (buffer, BUFSIZ, fp) != (char *) 0)
	{
		if (strncmp (buffer, "END OF DUMP LIST", 16) == 0)
			break;

		nr = sscanf (buffer,
     "%d %d %d %c %d %d %d %d %ld %d %d %d %d %d %d\n",
				& info, & x, & y,
				& des, & owner, & fer, & oil, & mines,
				& infotime, & min, & gol, & ura, & civ,
				& mil, & eff);

		if (! (nr == 15 ||
		       (nr == 8 && (info & (SPY | LOO | RES)) == 0)))
		{
			PrintAtEmpire ("Bad sector info in datafile");
			PrintAtEmpire (Fmt ("Skipping Line \"%s\"", buffer));
			PrintAtEmpire ("");
			fprintf (stderr, "Skipping Line \"%s\"", buffer);
			Bell ();
			continue;
		}

		if ((info & (ALL | KNEWALL)) != 0)
			sct = World (x, y, S_OWNED);
		else if ((info & (SPY | RES | LOO)) != 0)
			sct = World (x, y, S_RESOU);
		else
			sct = World (x, y, S_DESIG);

		s_inf (sct) = info;

			/* des | owner | fer | oil | time */

		set_des (sct, des);
		set_owner (sct, owner);
		set_fer (sct, fer);
		set_oil (sct, oil);
		set_mines (sct, mines);

		if ((info & (SPY | LOO | RES)) != 0)
		{
			/* min | gol | ura | civ | mil | eff */

			set_time (sct, infotime);
			set_min (sct, min);
			set_gol (sct, gol);
			set_ura (sct, ura);
			set_civ (sct, civ);
			set_mil (sct,  mil);
			set_eff (sct, eff);
		}

		if (KNOW_ALL (sct) && ! deity && ! bin_dump)
		{

		/* Don't assume sector is still ours, if it is it
		 * will be updated by dump
		 */
			DEL_INFO (sct);
			SET_INFO_KNEWALL (sct);
		} else if (KNOW_ALL (sct) && ! bin_dump)
			set_nds (sct, des);
	}
}

char *MakeDataFile (suffix)
char *suffix;
{
	char *home;
	char *fname;
	char *lead;

	if ((home = getenv ("HOME")) == (char *) 0)
	{
		(void) fprintf (stderr, "HOME not set, leaving...\n");
		leave ();
	}

	if (xrc.savefile) {
		fname = xrc. savefile;
		lead = "";
	}
	else {
		fname = cname;
		lead = ".";
	}
		
	if (xrc. savedir) {
		if(xrc. savedir[0] == '/' ||
		   strncmp(xrc. savedir, "./", 2) == 0 ||
		   strncmp (xrc.savedir, "../", 3) == 0 ||
		   strcmp(xrc.savedir, ".") == 0)
			return Fmt ("%s/%s%s%s", xrc.savedir, lead,
				    fname, suffix);
		else 
			return Fmt ("%s/%s/%s%s%s", home, xrc.savedir, lead,
				    fname, suffix);
	}
	else
		return Fmt ("%s/%s%s%s", home, lead, fname, suffix);
}

bool RetrieveData (bin_dump)
bool bin_dump;
{
	FILE *fp;
	char *fname;

	fname = MakeDataFile ("");

	if (xrc. compress) {
		Message ("Uncompressing datafile");
		system (Fmt ("%s %s > /dev/null 2>& 1", UNCOMP_BIN, fname));
	}

	if ((fp = fopen (fname, "r")) == (FILE *) 0)
	{
		PrintAtEmpire (Fmt ("No Datafile %s", fname));
		PrintAtEmpire ("");
		Bell ();
		(void) EmpireMore ();
		return False;
	}
	else if (access (fname, W_OK) != 0)
	{
		PrintAtEmpire (Fmt (
			"Warning can read but not write Datafile %s", fname));
		PrintAtEmpire ("");
		Bell ();
		(void) EmpireMore ();
		return False;
	}

#ifdef TERMC_VERSION
#define CheckRefreshEvents();
#endif /* TERMC_VERSION */
		/* Read sectors */

	Message ("Restoring....");
	RestoreVersion (fp);
	CheckRefreshEvents ();
	RestoreBridgeData (fp);
	CheckRefreshEvents ();
	RestoreCountries (fp);
	CheckRefreshEvents ();
	ReadBufCommands (fp);
	CheckRefreshEvents ();
	ReadFerries (fp);
	CheckRefreshEvents ();
	RestoreMail (fp);
	CheckRefreshEvents ();
	RestoreShowShip (fp);
	CheckRefreshEvents ();
	RestoreShowLand (fp);
	CheckRefreshEvents (); 
	RestoreShowPlane (fp);
	CheckRefreshEvents ();
	ReadHighlight (fp);
	CheckRefreshEvents ();
	LoadNukeShow (fp);
	CheckRefreshEvents ();
	LoadPlanOptions (fp);
	CheckRefreshEvents ();

	RestoreScts (fp, bin_dump);
	CheckRefreshEvents ();

	if (ferror (fp)) {
		perror ("Error reading datafile ");
		fclose (fp);
		leave ();
	}

	fclose (fp);

	Message ("Restore done");
	return True;
}

void StoreData ()
{
	FILE *fp, *fopen ();
	Sector sct;
	char *fname;
	char *home;
	int x, y;
	extern int origin_x, origin_y;
	extern char *sys_errlist[];

	if (command_state == FASTQUIT_STATE)
		return;

	if (command_state == STARTUP_STATE)
	{
		if (! xstarted)
			return;

		if (! Confirm ("Aborted while collecting data, save data ?",
								False))
			return;
	}
	else if (command_state == TEST_STATE)
	{
		Error ("You can't save data when you're in a test state");
		return;
	}

	BinDumpAll ();

	fname = MakeDataFile ("");

	fp = fopen (fname, "w");

	if (fp == (FILE *) 0)
	{
		(void) fprintf (stderr, "Can't open %s !!!\n", fname);
		return;
	}

		/* Write sectors to remember */

	Message ("Saving data");
	SaveVersion (fp);
	SaveBridgeData (fp);
	SaveCountries (fp);
	SaveBufCommands (fp);
	SaveFerries (fp);
	SaveMail (fp);
	SaveShowShip (fp);
	SaveShowLand (fp); 
	SaveShowPlane (fp);
	SaveHighlight (fp);
	SaveNukeShow (fp);
	SavePlanOptions (fp);

	fprintf (fp, "capitol at %d,%d\n", capitol_x, capitol_y);

	for (x = 0; x < MAX_X; x ++) 
	for (y = 0; y < MAX_Y; y++)
	{
		sct = World (x, y, S_EXIST);

		if (sct != (Sector) 0)
		{

		/* info | xcd | ycd | des | owner | fer | oil | mines | Time */

			fprintf (fp, "%hd %hd %hd %c %hd %hd %hd %hd",
				s_inf (sct),
				s_xcd (sct),
				s_ycd (sct),
				s_des (sct),
				s_owner (sct),
				s_fer (sct),
				s_oil (sct),
				s_mines (sct));

			if ((s_inf (sct) & (SPY | LOO | RES)) != 0)
			{
				/* min | gol | ura | civ | mil | eff */

				fprintf (fp, " %ld %hd %hd %hd %hd %hd %hd",
					s_time (sct),
					s_min (sct),
					s_gol (sct),
					s_ura (sct),
					s_civ (sct),
					s_mil (sct),
					s_eff (sct));
			}

			fprintf (fp, "\n");
		}
	}

	fprintf (fp, "END OF DUMP LIST\n");
	if (ferror (fp))
	{
		Message (Fmt ("Save data failed : %s", sys_errlist [errno]));
		fprintf (stderr, Fmt ("Save data failed : %s", sys_errlist [errno]));
	}

	fclose (fp);

	if (xrc. compress)
	{
		Message ("Compressing data");
		system (Fmt ("%s %s> /dev/null 2>& 1", COMP_BIN, fname));
	}

	Message ("Save data done");
}

void CheckDump ()
{
	int x, y;
	Sector sct;
	int nr = 0;

	for (x = 0; x < MAX_X; x++)
	for (y = 0; y < MAX_Y; y++)
	{
		sct = World (x, y, S_EXIST);

		if (sct == (Sector) 0)
			continue;

		if (KNEW_ALL (sct))
		{
			nr++;
			PrintAtEmpire (Fmt ("Sector %s has been lost !!",
					CrdStr (sct)));

			set_owner (sct, UNKNOWN_CNUM);

			DEL_INFO (sct);
			SET_INFO_RES (sct);
		}
	}

	if (nr)
	{
		Bell ();
		(void) EmpireMore ();
		PrintAtEmpire ("");
	}
}
