/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/census/RCS/sector.c,v 5.1 93/03/14 16:42:00 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:42:00 $
    $Author: etienne $
    $Id: sector.c,v 5.1 93/03/14 16:42:00 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	sector.c,v $
 * Revision 5.1  93/03/14  16:42:00  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "nation.h"
#include "census.h"
#include "var.h"
#include "ship.h"
#include "sector.h"
#include "production.h"
#include "version.h"


static char * comm_sname [12] = {
	"uw ",	"foo",	"she",	"gun",
	"pet",	"iro",	"bar",	"dus",
	"oil",	"lcm",	"hcm",	"rad"
};

extern char comm_chars [];

	/*
	 *	Display functions
	 */

static void CenDelivery (y, cut, dir)
int y;
int cut;
char dir;
{
	CenPuts (16, y, "        ");
	if (dir != '\0' && dir != '.')
	{
		CenPutShort (16, y, cut);
		DrawArrow (census_win, 22, y, dir);
	}
}
	
static void CenCom (y, com, thr, cut, dir)
int y;
int com, thr, cut;
char dir;
{
	CenPutPosit (6,  y, com);
	CenPutPosit (11, y, thr);
	CenDelivery (y, cut, dir);
}

void CensusTop (sct)
Sector sct;
{
	
	CenPutVal (4, NL_SY_SCT, Fmt ("%-22s", CrdStr (sct)));
	CenPutVal (4, NL_SY_SCT + 1, Fmt ("%-22s", DesignName (s_des (sct))));
	if (KNOW_ALL (sct) && ! deity && s_occ (sct) == '*')
			CenPutVal (23, NL_SY_SCT + 1, "[*]");

	ClearCols (NL_SY_CENSUS, 2);


	if (KNOW_ALL (sct) || KNOW_LOO_ONLY (sct) || KNOW_SPY_ONLY (sct))
	{
		CenPutVal   (4,  NL_SY_CENSUS,     Fmt ("%-3d%%", s_eff (sct)));
		CenPutShort (4,  NL_SY_CENSUS + 1, s_civ (sct));
		CenPutShort (13, NL_SY_CENSUS + 1, s_mil (sct));

		if (deity || ! s_owned (sct))
			if (KNOW_OWN (sct))
				CenPutVal (16, NL_SY_SCT, Fmt ("%.9s",
						CountryName (s_owner (sct))));
		else if (KNOW_ALL (sct) && s_des (sct) != s_nds (sct))
			CenPutVal (16, NL_SY_SCT + 1, Fmt ("(%c)",
					s_nds (sct)));
	}
	else if (s_des (sct) != '.')
			CenPutVal (16, NL_SY_SCT, "Own Unkn ");
	
	if (KNOW_ALL (sct))
	{
		CenPutShort (13, NL_SY_CENSUS, s_mob (sct));
		CenPutShort (22, NL_SY_CENSUS, s_ava (sct));
		CenPutVal (22, NL_SY_CENSUS + 1, Fmt ("%-3d%%", s_wor (sct)));	
	}
}

void CensusResources (sct)
Sector sct;
{
	CenClr (NL_SY_RESOUR + 1);

	if (s_des (sct) == '.' || s_des (sct) == '=')
	{
		CenClr (NL_SY_RESOUR + 1);
		CenPuts (0, NL_SY_RESOUR + 1, "# mines:");

		if (s_mines (sct) == 0)
			CenPutVal (9, NL_SY_RESOUR + 1, "None");
		else if (s_mines (sct) > 127)
			CenPutVal (9, NL_SY_RESOUR + 1, Fmt ("? (%d found)",
					s_mines (sct) - 127));
		else
			CenPutShort (9, NL_SY_RESOUR + 1, s_mines (sct));
	}
	else
	{
		CenPuts (0,  NL_SY_RESOUR + 1, "Gol      Ura");
		
		if (KNOW_RES (sct))
		{
			CenPutShort (4,  NL_SY_RESOUR + 1, s_gol (sct));
			CenPutShort (13, NL_SY_RESOUR + 1, s_ura (sct));
		}
		else
		{
			CenPuts (4,  NL_SY_RESOUR, "    ");
			CenPuts (13, NL_SY_RESOUR, "    ");
		}
	}

	if (KNOW_FER (sct))
		CenPutShort (22, NL_SY_RESOUR, s_fer (sct));
	else
		CenPuts (22, NL_SY_RESOUR, "   ");

	if (KNOW_OIL (sct))
		CenPutShort (13, NL_SY_RESOUR, s_oil (sct));
	else
		CenPuts (13, NL_SY_RESOUR, "   ");

	if (KNOW_RES (sct))
		CenPutShort (4, NL_SY_RESOUR, s_min (sct));
	else
		CenPuts (4, NL_SY_RESOUR, "   ");

}

void CensusCrafts (sct)
Sector sct;
{
	if (land_units) {
		CenPutShort (2,  NL_SY_CRAFTS, s_shi (sct));
		CenPutShort (9, NL_SY_CRAFTS, s_pla (sct));
		CenPutShort (16, NL_SY_CRAFTS, s_land (sct));
		CenPutShort (23, NL_SY_CRAFTS, s_nuk (sct));
	} else {
		CenPutShort (4,  NL_SY_CRAFTS, s_shi (sct));
		CenPutShort (13, NL_SY_CRAFTS, s_pla (sct));
		CenPutShort (22, NL_SY_CRAFTS, s_nuk (sct));
	}
}

void CensusCommodities (sct)
Sector sct;
{
	int i;
	Sector wareh;

	if (KNOW_ALL (sct))
	{
		CenCom (NL_SY_COMM + 1,
			q_uw  (sct), t_uw  (sct),  c_uw (sct), d_uw (sct));
		CenCom (NL_SY_COMM + 2,
			q_foo (sct), t_foo (sct),  c_foo(sct), d_foo(sct));
		CenCom (NL_SY_COMM + 3,
			q_she (sct), t_she (sct),  c_she(sct), d_she(sct));
		CenCom (NL_SY_COMM + 4,
			q_gun (sct), t_gun (sct),  c_gun(sct), d_gun(sct));
		CenCom (NL_SY_COMM + 5,
			q_pet (sct), t_pet (sct),  c_pet(sct), d_pet(sct));
		CenCom (NL_SY_COMM + 6,
			q_iro (sct), t_iro (sct),  c_iro(sct), d_iro(sct));
		CenCom (NL_SY_COMM + 7,
			q_bar (sct), t_bar (sct),  c_bar(sct), d_bar(sct));
		CenCom (NL_SY_COMM + 8,
			q_dus (sct), t_dus (sct),  c_dus(sct), d_dus(sct));
		CenCom (NL_SY_COMM + 9,
			q_oil (sct), t_oil (sct),  c_oil(sct), d_oil(sct));
		CenCom (NL_SY_COMM + 10,
			q_lcm (sct), t_lcm (sct),  c_lcm(sct), d_lcm(sct));
		CenCom (NL_SY_COMM + 11,
			q_hcm (sct), t_hcm (sct),  c_hcm(sct), d_hcm(sct));
		CenCom (NL_SY_COMM + 12,
			q_rad (sct), t_rad (sct),  c_rad(sct), d_rad(sct));
		

		CenClr (NL_SY_DISTR);
		if ((land_units && !(s_dxc (sct) == s_xcd (sct) && s_dyc (sct) == s_ycd (sct))) || (!land_units && s_pat (sct) != (char *) 0))
		{
			wareh = World (s_dxc (sct), s_dyc (sct), S_DESIG);
			CenPuts (0, NL_SY_DISTR, "Distribute to: ");
			CenPutVal (14, NL_SY_DISTR, Fmt ("%d,%d (%c)",
					s_dxc (sct), s_dyc (sct),
					s_owned (wareh) ? s_nds (wareh)
							: s_des (wareh)));
		}
		else 
			CenPuts (0, NL_SY_DISTR, "No distribution path");
	}
	else
	{
		for (i = 0; i < 12; i ++)
			CenPuts (4, i + 1 + NL_SY_COMM,
						"                      ");

		CenClr (NL_SY_DISTR);
		if (KNOW_SPY (sct))
		{
			CenCom (NL_SY_COMM + 2, q_foo (sct), 0, 0, '.');
			CenCom (NL_SY_COMM + 3, q_she (sct), 0, 0, '.');
			CenCom (NL_SY_COMM + 4, q_gun (sct), 0, 0, '.');
			CenCom (NL_SY_COMM + 5, q_pet (sct), 0, 0, '.');
			CenCom (NL_SY_COMM + 6, q_iro (sct), 0, 0, '.');
		}
	}
}

static void CensusButtons (sct)
Sector sct;
{
	if(!land_units) {
		if (s_shi (sct) > 0)
			CenButton (NL_SX_SHIP,  NL_SY_BUT, "Ship",  4,False);
		else
			CenButton (NL_SX_SHIP,  NL_SY_BUT, "----",  4,False);

		if (s_pla (sct) > 0)
			CenButton (NL_SX_PLANE, NL_SY_BUT, "Plane", 5, False);
		else
			CenButton (NL_SX_PLANE, NL_SY_BUT, "-----", 5, False);

		if (s_nuk (sct) > 0)
			CenButton (NL_SX_NUKE,  NL_SY_BUT, "Nuke",  4, False);
		else
			CenButton (NL_SX_NUKE,  NL_SY_BUT, "----",  4, False);
	} else {
		if (s_shi (sct) > 0)
			CenButton (NL_SX_SHIP3,  NL_SY_BUT, "Shp",  3,False);
		else
			CenButton (NL_SX_SHIP3,  NL_SY_BUT, "---",  3,False);

		if (s_pla (sct) > 0)
			CenButton (NL_SX_PLANE3, NL_SY_BUT, "Pln", 3, False);
		else
			CenButton (NL_SX_PLANE3, NL_SY_BUT, "---", 3, False);

		if (s_land (sct) > 0)
			CenButton (NL_SX_LAND3, NL_SY_BUT, "Lnd", 3, False);
		else
			CenButton (NL_SX_LAND3, NL_SY_BUT, "---", 3, False);

		if (s_nuk (sct) > 0)
			CenButton (NL_SX_NUKE3,  NL_SY_BUT, "Nuk",  3, False);
		else
			CenButton (NL_SX_NUKE3,  NL_SY_BUT, "---",  3, False);
	}

#ifdef TERMC_VERSION

	CenButton (NL_SX_INFO,  NL_SY_BUT, "Info",  4, False);

#endif /* TERMC_VERSION */

}

void CensusAddit (sct)
Sector sct;
{
	int i;
	time_t time ();
	double plague;
	double happy;
	int x, y;
	extern int capitol_x, capitol_y;
	int line;
	
	
	for (i = 0; i < NL_ADDIT_LINES; i ++)
		CenClr (NL_SY_ADDIT + i);

#ifdef TERMC_VERSION
	
	PrintN (census_win, NL_SY_ADDIT, "-------Information.-------");
	y = NL_SY_ADDIT + 1;

#else

	y = NL_SY_ADDIT;
#endif


	if (! KNOW_ALL (sct))
	{
		CenPuts (0, y, "Info:");
		x = 6;

		if (KNOW_SPY_ONLY (sct))
		{
			CenPutVal (x, y, "Spy ");
			x += 4;
		}
		else if (KNOW_LOO_ONLY (sct))
		{
			CenPutVal (x, y, "Lookout ");
			x += 8;
		}

		if (KNOW_RES (sct))
			CenPutVal (x, y, "Resources");
		else if (KNOW_OIL (sct))
			CenPutVal (x, y, "Oil Resources");
		else if (KNOW_FER (sct))
			CenPutVal (x, y, "Fertility");

		if ((KNOW_LOO_ONLY (sct)) || (KNOW_SPY_ONLY (sct)))
		{
			CenPutVal (0, y + 1, Fmt ("Dated : %s",
					DateFmt (s_time (sct))));

			CenPutVal (0, y + 2, Fmt ("Now   : %s",
					DateFmt (time ((time_t *) 0))));
		}

	}
	else
	{
		if (! no_food)
			CenPutVal (0, y ++, Fmt (
				"Food needed: %.1f", (double)
				(s_civ (sct) + s_mil (sct) + q_uw (sct)) *
					etu_per_update * eatrate));

		line = y;
		if (EMPOption(NO_PLAGUE))
			plague = 0;
		else
			plague = PlagueChance (sct);

		if (PlagueStage(sct) == PLG_INFECT || PlagueStage(sct) == PLG_INCUBATE)
			CenPutVal (0, line ++, "Plague infecting sector");
		else if (PlagueStage(sct) == PLG_DYING)
			CenPutVal (0, line ++, "Plague killing people");

		else if (plague > 0.0)
			CenPutVal (0, line ++,
				Fmt ( "Plague chance: %.4f", plague));

		if (HappinesState(sct) == HP_GUERRILLAS)
			CenPutVal (0, line ++, "Guerrila warfare");
		else if (HappinesState(sct) == HP_TERRORISTS)
			CenPutVal (0, line ++, "Terrorists");
		else if (HappinesState(sct) == HP_REVOLUTIONARIES)
			CenPutVal (0, line ++, "Revolutionaries");
		else if (HappinesState(sct) == HP_UNREST)
			CenPutVal (0, line ++, "Civil unrest");

		CensusProduce (sct, line);
	}

#ifdef TERMC_VERSION

	CenButton (AL_SX_SECTOR, AL_SY_BUT, "Sector", 6, False);

#endif TERMC_VERSION
}

#ifdef TERMC_VERSION

void AdditCensusBut (x, y)
int x, y;
{
	if (ButtonPressed (x, y, AL_SX_SECTOR, AL_SY_BUT, 6))
	{
		CensusSct (cursct);
		return;
	}
}

#endif TERMC_VERSION

void CensusLayNormal ()
{
	int i;

#ifdef TERMC_VERSION

	CenPuts (0, NL_SY_RESOUR,     "Min      Oil      Fer");
	CenPuts (0, NL_SY_RESOUR + 1, "Gol      Ura");
	CenPuts (0, NL_SY_CRAFTS,     "Shi      Pla      Nuk");

#endif /* TERMC_VERSION */

	CenPuts (0, NL_SY_COMM,       "      Com  Thr  Cut  Dir");

	for (i = 0; i < 12; i ++)
		CenPuts (0, NL_SY_COMM + 1 + i, comm_sname [i]);
	CenLine (NL_SY_BUT - 1);

#ifdef TERMC_VERSION
	CenButton (NL_SX_INFO, NL_SY_BUT, "Info", 4, False);
#endif /* TERMC_VERSION */

	CenLine (NL_SY_BUT + 1);
}

void SectorCensus (sct)
Sector sct;
{
#ifdef TERMC_VERSION

	CensusResources (sct);
	CensusCrafts (sct);

#endif /* TERMC_VERSION */

	CensusCommodities (sct);
	CensusButtons (sct);

#ifdef X_VERSION

	CensusAddit (sct);

#endif X_VERSION

}

void SectorCensusBut (x, y)
int x, y;
{
	bool s_cut, s_thresh;
	char * ans;
	int new;
	char ch;

	if (y == NL_SY_DISTR)
	{
		if (! s_owned (cursct) && ! deity)
		{
			Message ("You don't own that sector!");
			Bell ();
		}
		else
		{
			Distribute (cursct, 10, 10);
			CensusSct (cursct);
		}

		return;
	}

	if (y == NL_SY_BUT && !land_units)
	{
		if (ButtonPressed (x, y, NL_SX_SHIP, y, 4))
		{
			if (s_fship (cursct) != (Ship) 0)
				CensusShip (s_fship (cursct));
		}
		else if (ButtonPressed (x, y, NL_SX_PLANE, y, 5))
		{
			if (s_fplane (cursct) != (Plane) 0)
				CensusPlane (s_fplane (cursct));
		}
		else if (ButtonPressed (x, y, NL_SX_NUKE, y, 4))
		{
			if (s_stock (cursct) != (Stockp) 0)
				CensusNuke (s_stock (cursct));
		}

#ifdef TERMC_VERSION
		else if (ButtonPressed (x, y, NL_SX_INFO, y, 4))
			CensusInfo ();
#endif /* TERMC_VERSION */

		return;
	} 
        if (y == NL_SY_BUT && land_units)
        {
                if (ButtonPressed (x, y, NL_SX_SHIP3, y, 3))
                {
                        if (s_fship (cursct) != (Ship) 0)
                                CensusShip (s_fship (cursct));
                }
                else if (ButtonPressed (x, y, NL_SX_PLANE3, y, 3))
                {
                        if (s_fplane (cursct) != (Plane) 0)
                                CensusPlane (s_fplane (cursct));
                }
                else if (ButtonPressed (x, y, NL_SX_NUKE3, y, 3))
                {
                        if (s_stock (cursct) != (Stockp) 0)
                                CensusNuke (s_stock (cursct));
                }
		else if (ButtonPressed (x, y, NL_SX_LAND3, y, 3))
		{
			if (s_fland (cursct) != (Land) 0)
				CensusLand (s_fland (cursct));
		}

#ifdef TERMC_VERSION
                else if (ButtonPressed (x, y, NL_SX_INFO, y, 4))
                        CensusInfo ();
#endif /* TERMC_VERSION */

		return ;
	}

	if (! s_owned (cursct) && ! deity)
		return;

	if (y > NL_SY_COMM && y <= NL_SY_COMM + 12)
	{
		s_thresh = False;
		s_cut = False;

		if (x >= 11 && x <= 14)
		{
			s_thresh = True;
			x = 11;
		}
		else if (x >= 16 && x <= 19)
		{
			s_cut = True;
			x = 16;
		}

		if (! s_thresh && ! s_cut)
			return;

		PrintN (census_win, x, y, "    ");
		ans = GetString (census_win, x, y, 4, GS_PNUMBER);
		if (ans == (char *) 0 || interrupt || * ans == '\0')
		{
			Message (Fmt ("Set %s cancelled",
				s_cut ? "cutoff" : "threshold"));
			Census ();
			return;
		}

		new = atoi (ans);
		ch = comm_chars [y - NL_SY_COMM - 1];

		if (s_cut)
		{
			SetDelAgainCutoff (ch, new);
			SetCutoff (cursct, ch, new);
			FeedCommand (Fmt ("deliver %c %s +%d",
					ch,
					CrdStr (cursct),
					new), PRINT);
		}
		else
		{
			SetThreshold (cursct, ch, new);
			FeedCommand (Fmt ("threshold %c %s %d",
					ch,
					CrdStr (cursct),
					new), PRINT);
		}
		
		(void) WaitForPrompt (PRINT);
		DrawSector (cursct);
		Census ();
		return;
	}
}
