/*
    $Header: /usr/local/src/et/work/xemp5.0/lib/census/RCS/deity.c,v 5.1 93/03/14 16:41:33 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:41:33 $
    $Author: etienne $
    $Id: deity.c,v 5.1 93/03/14 16:41:33 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	deity.c,v $
 * Revision 5.1  93/03/14  16:41:33  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:16:27  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.5  1993/02/06  07:48:54  greyhelm
 * Added gnumake mods to allow checkin and Checkout
 *
 * Revision 4.4  1993/02/06  04:21:26  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#include "type.h"
#include "main.h"
#include "nation.h"
#include "census.h"
#include "var.h"
#include "ship.h"
#include "sector.h"

static void DeityChangeCom (x, y, ch)
int x, y;
char ch;
{
	char * ans;
	int new, old;

	CenPuts (x, y, "    ");
	ans = GetString (census_win, x, y, 4, GS_PNUMBER);
	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		Message ("Deity 'give' command cancelled.\n");
		interrupt = False;
	}
	else
	{
		old = GiveQuant (cursct, ch);
		new = atoi (ans);
		FeedEmpire (Fmt ("give %c %s %d", ch, CrdStr (cursct),
					new - old), PRINT);

		(void) WaitForPrompt (PRINT);
		SetQuant (cursct, ch, new);
	}

	Census ();
}

static char * comm_chars = "ufsgpibdolhr";

void CensusDeityButton (x, y)
int x, y;
{
	char * ptr;
	int new;
	int i;
	
	if (y == NL_SY_SCT)	/* change owner */
	{
		DeityChange (cursct);

		ptr = AskCountry (10, 10, "New owner ?", True);

		if (interrupt || ptr == (char *) 0)
		{
			interrupt = False;
			Message ("Changing owner cancelled");
			Census ();
			return;
		}

		new = CountryId (ptr);
		EditLand (cursct, 'o', new);
		EditLand (cursct, 'O', new);

		set_owner (cursct, new);
		DrawSector (cursct);
		Census ();
		return;
	}
		
	if (y == NL_SY_CENSUS)
	{
		if (ButtonPressed (x, y, 0, y, 8))
		{
			if (DeityChangeLand (4, y, 'e', & i))
				set_eff (cursct, i);
			Census ();
			return;
		}
		else if (ButtonPressed (x, y, 9, y, 8))	/* Mob */
		{
			if (DeityChangeLand (13, y, 'm', & i))
				set_min (cursct, i);
			Census ();
			return;
		}
		else if (ButtonPressed (x, y, 18, y, 8)) /* Ava */
		{
			if (DeityChangeLand (22, y, 'a', & i))
				set_ava (cursct, i);
			Census ();
			return;
		}
	}

	if (y == NL_SY_CENSUS + 1)
	{
		if (ButtonPressed (x, y,  0, y, 8))
			DeityChangeCom (4, y, 'c');
		else if (ButtonPressed (x, y, 9, y, 8))
			DeityChangeCom (13, y, 'm');
		else if (ButtonPressed (x, y, 18, y, 8))
		{
			if (DeityChangeLand (22, y, 'w', & i))
				set_wor (cursct, i);
			Census ();
		}

		return;
	}

#ifdef TERMC_VERSION

	if (last_layout != NORMAL_MODE)
		return;
	
#endif /* TERMC_VERSION */

	if (y == NL_SY_RESOUR)
	{
		if (ButtonPressed (x, y, 0, y, 8))
		{
			if (DeityChangeLand (4, y, 'i', & i))
				set_min (cursct, i);
			Census ();
		}
		else if (ButtonPressed (x, y, 9, y, 8))
		{
			if (DeityChangeLand (13, y, 'c', & i))
				set_oil (cursct, i);
			Census ();
		}
		else if (ButtonPressed (x, y, 18, y, 8))
		{
			if (DeityChangeLand (22, y, 'f', & i))
				set_fer (cursct, i);
			Census ();
		}

		return;
	}

	if (s_des (cursct) == '.' || s_des (cursct) == '=')
		return;

	if (y == NL_SY_RESOUR + 1)
	{
		if (ButtonPressed (x, y, 0, y, 8))
		{
			if (DeityChangeLand (4, y, 'g', & i))
				set_gol (cursct, i);
			Census ();
		}
		else if (ButtonPressed (x, y, 9, y, 8))
		{
			if (DeityChangeLand (13, y, 'u', & i))
				set_ura (cursct, i);
			Census ();
		}
	
		return;
	}

#ifdef X_VERSION
	
	if (last_layout != NORMAL_MODE)
		return;
	
#endif /* X_VERSION */

	if (x <= 8 && y > NL_SY_COMM && y <= NL_SY_COMM + 13)
		DeityChangeCom (6, y, * (comm_chars + y - NL_SY_COMM - 1));
}

bool DeityChangeShip (ship, x, y)
Ship ship;
int x, y;
{
	int i;
	char * ptr, ch;
	int max, new;

	static char * ship_chars = "EM cmT";

	if (y == SL_SY_OWNER)
	{
		ptr = AskCountry (10, 10, "New owner ?", True);
		if (ptr != (char *) 0)
		{
			new = CountryId (ptr);
			ch = 'O';
		}
	}
	else
	{
		if (x >= 0 && x <= 7)
			i = 0;
		else if (x >= 9 && x <= 16)
			i = 1;
		else if (x >= 18 && x <= 25)
			i = 2;
		else
			return False;

		x = 4 * i * 9;

		if (y >= SL_SY_COM && y <= SL_SY_COM + 3)
		{
			ch = comm_chars [(y - SL_SY_COM) * 3 + i];
			max = MaxShipCargo (curship, ch);
		}
		else if (y >= SL_SY_STATS && y <= SL_SY_STATS + 1)
		{
			ch = ship_chars [(y - SL_SY_STATS) * 3 + i];
			if (ch == 'E') max = 100;
			else if (ch == 'M') max = MAX_SHIPMOB;
			else if (ch == 'T') max = 9999;
			else max = MaxShipCargo (curship, ch);
		}

		if (max == 0)
		{
			Message (Fmt
			    ("The captain refuses to take %s on board",
			    ItemName (CharToItem (ch))));
			Bell ();
			return;
		}

		PrintN (census_win, x, y, "    ");
		ptr = GetString (census_win, x, y, 4, GS_PNUMBER);
		if (ptr != (char *) 0)
		{
			new = atoi (ptr);
			if (new > max)
				new = max;
		}
	}

	if (interrupt || ptr == (char *) 0 || *ptr == '\0')
	{
		interrupt = False;
		Message ("Edit ship cancelled");
		return;
	}

	EditShip (ship, ch, new);
	SetShipQuant (ship, ch, new);
	CensusShip (ship);
	return;
}
