/*
    $Header: /usr/local/src/et/work/xemp5.0/include/RCS/ship.h,v 5.1 93/03/14 16:39:58 etienne Exp Locker: etienne $
    $Date: 93/03/14 16:39:58 $
    $Author: etienne $
    $Id: ship.h,v 5.1 93/03/14 16:39:58 etienne Exp Locker: etienne $
    $Locker: etienne $
    $Log:	ship.h,v $
 * Revision 5.1  93/03/14  16:39:58  etienne
 * 
 * 
 * Revision 5.0  93/02/06  09:25:20  greyhelm
 * Fixed backward compatabilty with Merc/KSU
 * Changed MOTD to show new version and authors
 * 
 * Revision 4.4  1993/02/06  04:17:12  greyhelm
 * Added RCS headers - Karl Hagen
 *

*/
#ifndef _SHIP
#define _SHIP

#ifndef _VAR
#include "var.h"
#endif _VAR

#define MAXSHPNAMLEN    24	/* ksu option */

	/*
	 *	No need to add entries for the old coordinates of
	 *	an enemy ship. Let's take the lcm & hcm values 
	 */

#define	old_x	lcm
#define	old_y 	hcm

struct s_ship
{ 
	char name [MAXSHPNAMLEN];
	short nr;
	short type;
	short radar;			/* effective radar range */
	short sonar;			/* effective sonar range */
	short x, y;
	char fleet;
	short eff;
	short civ;
	short owner;	/* deity only */
	short mil;
	short uw;
	short food;
	short pln;
	short xpln;		/* xlight planes */
	short heli;		/* helicopters on ship */
	short fuel;		/* Fuel on ship */
	short land;             /* land units */
	short mob;
	uchar moves;
	short tech;
	short shell;
	short gun;
	short pet;
	short iron;
	short dust;
	short bar;
	short oil;
	short lcm;
	short hcm;
	short rad;
	time_t time;
	Ship nextsct, next;
	bool marked;
};

#define sh_nr(p)		(int) (p)-> nr
#define sh_type(p)		(int) (p)-> type
#define sh_name(p)		(p)-> name
#define sh_radar(p)		(int) (p)-> radar
#define sh_sonar(p)		(int) (p)-> sonar
#define sh_xcd(p)		(int) (p)-> x
#define sh_ycd(p)		(int) (p)-> y
#define sh_fleet(p)		(int) (p)-> fleet
#define sh_eff(p)		(int) (p)-> eff
#define sh_civ(p)		(int) (p)-> civ
#define sh_owner(p)		(int) (p)-> owner
#define sh_owned(p)		(int) ((p)-> owner == my_cnum)
#define sh_mil(p)		(int) (p)-> mil
#define sh_uw(p)		(int) (p)-> uw
#define sh_foo(p)		(int) (p)-> food
#define sh_pln(p)		(int) (p)-> pln
#define sh_xpln(p)		(int) (p)-> xpln
#define sh_heli(p)		(int) (p)-> heli 
#define sh_fuel(p)		(int) (p)-> fuel
#define sh_land(p)		(int) (p)-> land
#define sh_mob(p)		(int) (p)-> mob
#define sh_moves(p)		(int) (p)-> moves
#define sh_tech(p)		(int) (p)-> tech
#define sh_she(p)		(int) (p)-> shell
#define sh_gun(p)		(int) (p)-> gun
#define sh_pet(p)		(int) (p)-> pet
#define sh_iron(p)		(int) (p)-> iron
#define sh_dust(p)		(int) (p)-> dust
#define sh_bar(p)		(int) (p)-> bar
#define sh_oil(p)		(int) (p)-> oil
#define sh_lcm(p)		(int) (p)-> lcm
#define sh_hcm(p)		(int) (p)-> hcm
#define sh_rad(p)		(int) (p)-> rad
#define sh_next(p)		(p)-> next
#define sh_nxtsct(p)		(p)-> nextsct
#define sh_marked(p)		(p)-> marked
#define sh_time(p)		(p)-> time

#define	sh_oldx(p)		(p)-> old_x
#define	sh_oldy(p)		(p)-> old_y

#define set_sh_nr(p,q)		((p)-> nr	= (short) (q))
#define set_sh_type(p,q)	((p)-> type	= (short) (q))
#define set_sh_name(p,q)	(void) strcpy ((p)-> name, (q))
#define set_sh_radar(p,q)	((p)-> radar	= (short) (q))
#define set_sh_sonar(p,q)	((p)-> sonar	= (short) (q))
#define set_sh_xcd(p,q)		((p)-> x	= (short) (q))
#define set_sh_ycd(p,q)		((p)-> y	= (short) (q))
#define set_sh_fleet(p,q)	((p)-> fleet	= (char) (q))
#define set_sh_eff(p,q)		((p)-> eff	= (short) (q))
#define inc_sh_eff(p,q)		(p)-> eff 	+= (short) (q)
#define set_sh_civ(p,q)		((p)-> civ	= (short) (q))
#define set_sh_owner(p,q)	((p)-> owner	= (short) (q))
#define set_sh_mil(p,q)		((p)-> mil	= (short) (q))
#define set_sh_uw(p,q)		((p)-> uw	= (short) (q))
#define set_sh_foo(p,q)		((p)-> food	= (short) (q))
#define inc_sh_foo(p,q)		(p)-> food	+= (short) (q)
#define set_sh_pln(p,q)		((p)-> pln	= (short) (q))
#define set_sh_xpln(p,q)	((p)-> xpln	= (short) (q))
#define set_sh_heli(p,q)	((p)-> heli	= (short) (q))
#define set_sh_land(p,q)	((p)-> land	= (short) (q))
#define set_sh_fuel(p,q)	((p)-> fuel	= (short) (q))
#define set_sh_mob(p,q)		((p)-> mob	= (short) (q))
#define set_sh_tech(p,q)	((p)-> tech	= (short) (q))
#define set_sh_she(p,q)		((p)-> shell	= (short) (q))
#define set_sh_gun(p,q)		((p)-> gun	= (short) (q))
#define set_sh_pet(p,q)		((p)-> pet	= (short) (q))
#define set_sh_iron(p,q)	((p)-> iron	= (short) (q))
#define set_sh_dust(p,q)	((p)-> dust	= (short) (q))
#define set_sh_bar(p,q)		((p)-> bar	= (short) (q))
#define set_sh_oil(p,q)		((p)-> oil	= (short) (q))
#define inc_sh_oil(p,q)		(p)-> oil	+= (short) (q)
#define set_sh_lcm(p,q)		((p)-> lcm	= (short) (q))
#define set_sh_hcm(p,q)		((p)-> hcm	= (short) (q))
#define set_sh_rad(p,q)		((p)-> rad	= (short) (q))
#define set_sh_next(p,q)	((p)-> next	= (q))
#define set_sh_nxtsct(p,q)	((p)-> nextsct	= (q))
#define set_sh_marked(p,q)	((p)-> marked	= (q))

#define set_sh_oldx(p,q)	((p)-> old_x = (short) (q))
#define set_sh_oldy(p,q)	((p)-> old_y = (short) (q))
#define set_sh_oldpos(p,q,r)	{ set_sh_oldx(p, q); set_sh_oldy (p, r); }

#define set_sh_time(p,q)	((p)-> time = (q))
#define set_sh_moves(p,q)	((p)-> moves = (uchar) (q))

struct	s_shtype {
	int	lcm;		/* units of lcm to build */
	int	hcm;		/* units of hcm to build */
	int	def;		/* how well armored it is */
	int	spd;		/* how fast it can go */
	int	vis;		/* how well it can be seen */
	int	spy;		/* how well it can see */
	int	rng;		/* how far it can fire */
	int	fir;		/* how many guns it can fire */
	int 	hel;		/* how many helicopters on board */
	int 	xpl;		/* how many light planes on board */
	int 	fuse;		/* how much fuel on board */
	int 	fcar;		/* how much fuel on board */
	int	pla;		/* how many planes it can carry */
	int     land;		/* how many land units it can carry */
	char   *nam;		/* full name of type of ship */
	int	tec;		/* tech required to build */
	int	cos;		/* how much it costs to build */
	int	ava;		/* How may workers should be available */
	long	flags;		/* what special things can this ship do */
	int	car [V_MAX];
};

#define MAX_SHIPTYPES	100

#define M_FISH		0x00001	/* catch that fish */
#define M_TORP		0x00002	/* fire torpedoes */
#define M_DCHRG		0x00004	/* drop depth charges on subs */
#define M_PLANE		0x00008	/* launch and recover planes */
#define M_MISS		0x00010	/* launch missiles */
#define M_OIL		0x00020	/* drill for oil */
#define M_SONAR		0x00040	/* locate submarines */
#define M_MINE		0x00080	/* drop mines */
#define M_SWEEP		0x00100	/* clean up the mines */
#define M_SUB		0x00200	/* a submarine */
#define M_SPY		0x00400	/* gather intelligence info */
#define M_LAND		0x00800	/* allows full landing ability */
#define M_SUBT          0x01000
#define M_TRADE		0x02000  /* trade ships */
#define M_OILER		0x04000  /* Oiler Ships */
#define M_SEMILAND	0x08000
#define M_SUPPLY	0x10000 /* Allow supply ships */
#define M_KNOWN		0x20000	/* do I know the specs ? */

extern Ship shiplist;
extern ShType shiptypes[];

#define		ALL_SHIPS(p)	(p=shiplist; p != (Ship) 0; p = sh_next (p))

typedef enum
{
	ST_NAVIGATE,
	ST_SCRAP,
	ST_UPGRADE,
	ST_FLEETADD,
	ST_TEND,
	ST_LOADPLANE,
	ST_LOADXPLANE,
	ST_LOADHELI,
	ST_LOADLAND
}
    ShTask;

#define SCM_RADAR	0
#define SCM_SONAR	1
#define	SCM_LOOKOUT	2
#define	SCM_NAVIGATE	3
#define SCM_BOARD	4
#define	SCM_TEND	5
#define	SCM_FIRE	6	/* torpedo & fire */
#define SCM_MINE	7
#define SCM_TORPEDO	8	/* seperate torpedo button */
#define SCM_UPGRADE	9
#define	SCM_SCRAP	10
#define SCM_SET		11
#define SCM_SCUTTLE	12

#define	SCM_MAX		12

#endif /* _SHIP */
