#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "nation.h"

extern double upd_plane_eff;
extern double upd_plane_main;
extern double upd_milcost;

	/* ARGSUSED */
int UpdProdPlane(realm, etus, strings)
char * realm;
int etus;
Strings strings;
{
	Plane ptr;
	Sector sct;
	int	delta;
	int	mult;
	int	avail;
	int	w_p_eff;
	int	left;
	int	used;
	int sx, sy, ex, ey;

	(void) ConvRealmToCoord (realm, & sx, & sy, & ex, & ey);

	for ALL_PLANES (ptr)
	{
		if (! pl_owned (ptr) ||
		    pl_xcd (ptr) < sx || pl_xcd (ptr) > ex ||
		    pl_ycd (ptr) < sy || pl_ycd (ptr) > ey)
			continue;


			/*
			 *	Some checks deleted:
			 *
			 *	---	eff < 10
			 *	---	aircraft carrier still exists?
			 */

		upd_milcost += etus * (planetypes [pl_type (ptr)]. crew *
					money_mil * 5);
		
		mult = 1;
		if (n_tech (nation) < 0.85 * pl_tech (ptr))
			mult = 2;

		upd_plane_main += (double) mult * etus * dmin (-1.0,
				planetypes [pl_type (ptr)]. cost * money_plane);

		if (pl_launc (ptr))
			continue;

		left = 100 - pl_eff (ptr);
		if (left <= 0)
			continue;

		sct = PlaneSector (ptr);
		if (sct == (Sector) 0 || ! s_owned (sct))
			continue;

		avail = s_ava (sct) * 100;
		w_p_eff = 20 +
			planetypes [pl_type (ptr)]. lcm +
			2 * planetypes [pl_type (ptr)]. hcm;

		delta = roundavg((double) avail / w_p_eff);

		if (delta <= 0)
			continue;
		if (delta > etus)
			delta = etus;
		if (delta > left)
			delta = left;
		used = delta * w_p_eff;

		avail = (s_ava (sct) * 100 - used) / 100;
		if (avail < 0)
			avail = 0;
		set_ava (sct, avail);
		if (s_des (sct) != '*')
			delta /= 3;

		upd_plane_eff -= (double) mult * delta *
				planetypes [pl_type (ptr)]. cost / 100.0;

		set_pl_eff (ptr, pl_eff (ptr) + delta);
	}
}
