#include "type.h"
#include "main.h"
#include "sector.h"

void UpdDeliver (from, item, strings)
Sector from;
int item;
Strings strings;
{
	Sector to;
	char itemchar;
	char dir;
	int amt_scr, cutoff, amt_moved, amt_dst;
	int packing;
	double mcost;
	int mobility;
	int	n;

		/*
		 *	Calculate amount to move
		 */

	itemchar = ItemChar (item);
	dir = GetDelDir (from, itemchar);

	if (dir == '\0' || dir == '.')
		return;

	amt_scr = GiveQuant (from, itemchar);
	cutoff = GetCutoff (from, itemchar);
	amt_moved = amt_scr - cutoff;
	if (amt_moved <= 0)
		return;

	/*
	 * make sure delivery looks ok.  Check where its going,
	 * where its coming from, and see if there is more than
	 * the threshold amount
	 */

	to = MoveInDirection (from, dir, S_EXIST);
	if (to == (Sector) 0 || ! s_owned (to))
	{
		AddString (strings, Fmt ("%s delivery walkout at %s",
			ItemName (item), CrdStr (from)));
		return;
	}

	packing = SectorPacking (s_des (from));
	mobility = s_mob (from) / 2;
	mcost = MoveCost (s_des (to), s_eff (to)) * 
			ItemWeight (item, packing);

	if (mobility < (int) (mcost * amt_moved)) 
	{
		amt_moved = (int) (mobility / mcost);
		if (amt_moved <= 0)
			return;
	}

	amt_dst = GiveQuant (to, itemchar);

	if (amt_moved + amt_dst > 9990)
	{
		/* delivery backlog */
		if ((amt_moved = 9990 - amt_dst) <= 0)
			return;
	}

		/*
		 *	XXX:	???, didn't understand this part of the code
		 */

/* 
 * 	if (putvar(vtype, amt_moved + amt_dst, (char *)to, EF_SECTOR) < 0)
 * 	{
 * 		 "No room to deliver commodities 
 * 		wu(0, from->sct_own, fmt("no room for %s in %s\n",
 * 			ip->i_name, ownxy(to)));
 * 		return;
 * 	}
 */

		/*
		 *	XXX: Xemp doesn't handle plague (yet)
		 */

	n = s_mob (from) - (int) (mcost * amt_moved);
	if (n < 0)
		n = 0;
	set_mob (from, n);

	/* adjust quantities */
	SetQuant (from, itemchar, GiveQuant (from, itemchar) - amt_moved);
	SetQuant (to, itemchar, GiveQuant (to, itemchar) + amt_moved);
}
