#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#define MAXBUFSIZ 500

void doit (in, out)
int in, out;
{
	FILE * fin, * fout;
	char buf [MAXBUFSIZ];
	fd_set in_mask, out_mask;
	int n;
	int eof_stdin = 0;
	int eof_out = 0;

	fin = fdopen (in, "w");
	if (fin == (FILE *) 0)
	{
		fprintf (stderr, "fdopen failed\n");
		perror ("fdopen");
	}

	fout = fdopen (out, "r");
	if (fout == (FILE *) 0)
	{
		fprintf (stderr, "fdopen failed\n");
		perror ("fdopen");
	}

	while (fgets (buf, MAXBUFSIZ, fout) != (char *) 0)
	{
		fputs (buf, stdout);

		if (strncmp (buf, "DESTINATION?", 11) == 0)
		{
			fputs ("surfnet\n", stdout);
			fflush (stdout);
			fputs ("surfnet\n", fin);
			fflush (fin);
			break;
		}
	}	

	FD_ZERO (& out_mask);

	while (! eof_stdin && ! eof_out)
	{
		FD_ZERO (& in_mask);
		if (! eof_stdin)
			FD_SET (fileno (stdin), & in_mask);
		if (! eof_out)
			FD_SET (fileno (fout), & in_mask);

		n = select (fileno (fout) + 2,
			& in_mask, (fd_set *) 0, (fd_set *) 0,
			(struct timeval *) 0);

		if (n < 0)
		{	
			fprintf (stderr, "select failed.\n");
			perror ("select");
			exit (-1);
		}

		if (FD_ISSET (fileno (stdin), & in_mask))
		{
			/* FD_CLR (fileno (stdin), & in_mask); */

			if (fgets (buf, MAXBUFSIZ, stdin) == (char *) 0)
			{
				fclose (fin);
				eof_stdin = 1;
			}	
			else
			{
				fputs (buf, fin);
				fflush (fin);
			}
		}
		else if (FD_ISSET (fileno (fout), & in_mask))
		{
			/* FD_CLR (fileno (fout), & in_mask); */

			if (fgets (buf, BUFSIZ, fout) == (char *) 0)
				eof_out = 1;
			else
				fputs (buf, stdout);
		}
		else
		{
			fprintf (stderr, "Impossible (or end?)\n");
			exit (1);
		}
	}

	printf ("program terminated\n");
}

main (argc, argv)
int argc;
char ** argv;
{
	int p1 [2], p2 [2];
	int pid;

	if (pipe (p1) < 0)
	{
		fprintf (stderr, "pipe failed.\n");
		perror ("pipe");
		exit (-1);
	}

	if (pipe (p2) < 0)
	{
		fprintf (stderr, "pipe failed.\n");
		perror ("pipe");
		exit (-1);
	}

	pid = fork ();
	switch (pid)
	{

	case -1:
		fprintf (stderr, "fork failed.\n");
		perror ("fork");
		exit (-1);

	case 0:
		/* child */
		close (0);
		dup (p1 [0]);
		close (p1 [0]);
		close (p1 [1]);

		close (1);
		dup (p2 [1]);
		close (p2 [0]);
		close (p2 [1]);

		execlp ("telnet", "telnet", "sara-ts1.sara.nl",  (char *) 0);
		/*
		execlp ("cat", "cat", 0);
		*/
		fprintf (stderr, "execvp failed.\n");
		perror ("execvp");
		exit (-1);


	default:
		/* parent */
		close (p1 [0]);
		close (p2 [1]);

		doit (p1 [1], p2 [0]);
	}
}
