#include "type.h"
#include "main.h"
#include "func.h"

	/* ARGSUSED */
void WMPageCommand (x, y)
{
	char * ans;
	Strings strings;
	char * realm, * ptr;
	char comm [100];

	ans = InputAtMessage ("Command: ", 80, GS_TEXT);
	strings = InitStrings ();

	if (ans == (char *) 0 || interrupt || * ans == '\0')
	{
		ClearMes ();
		Bell ();
		interrupt = False;
		return;
	}

	strcpy (comm, ans);
	FeedEmpire (ans, PRINT);

	while ((ptr = ReadEmpireStrings (strings)) != (char *) 0)
	{
		if (StrEQ (ptr, "(sects)?"))
		{
			RaiseWindow (map_win);
			Message ("Select Realm");
			Bell ();
			realm = MySelRealm ();
			RaiseAll ();

			if (realm == (char *) 0)
			{
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
				FreeStrings (strings);
				Message ("Cancelled: No realm specified");
				return;
			}

			strcat (comm, " ");
			strcat (comm, realm);
			FeedEmpire (realm, PRINT);
			continue;
		}

		ans = InputAtMessage (ptr, 80, GS_TEXT);
		if (ans == (char *) 0 || interrupt)
		{
			interrupt = False;
			while (EmpireStatus () != E_COMMAND)
			{
				FeedEmpire ("aborted", PRINT);
				(void) WaitForPrompt (PRINT);
			}

			Message ("Command cancelled");
			FreeStrings (strings);
			return;
		}

		FeedEmpire (ans, PRINT);
		strcat (comm, " ");
		strcat (comm, ans);
	}

	(void) WaitForPrompt (PRINT);

	if (StringsSize (strings) == 0)
	{
		Message ("No output");
		Bell ();
		FreeStrings (strings);
		return;
	}

#ifdef TERMC_VERSION
	ShowStringsInPager (strings, comm);
#else /* TERMC_VERSION */
	InitWMPager (strings, comm);
#endif /* TERMC_VERSION */
}
