#include "main.h"
#include "tc_type.h"
#include "func.h"
#include "event.h"
#include "func.h"
#include "char.h"
#include "window.h"
#include "xrc.h"

#include <sys/types.h>
#include <sys/stat.h>

#define	MAX_BUTTONS	3
#define	MAX_FUNC	6

#define	HELP_STRLEN	4

typedef
struct s_pager
{
	char * header;

	Strings strings;

	int win1_width, win1_height;
	int win2_width, win2_height;

	int win2_start_y;

	int button_start_y;
	int func_start_y;

	int nr_lines;
	bool scrollbar;

	int scrolllines;

	WinInfo win1;
	WinInfo win2;

	int box;

	void (* proc) ();

	bool buttonsset;

	char * left_but, * middle_but, * right_but;

	bool select;
	bool edit;

	bool buttons_defined;
	int buttonIDs [MAX_BUTTONS];

	int nr_funcs;
	int * func_start_x;
	int func_ids [MAX_FUNC];
	char * func_names [MAX_FUNC];
	
	int last_x, last_y;

	int cols, col_width;
}
	PAGER;

Pager InitPager (strings, header)
Strings strings;
char * header;
{
	Pager new_pager;

	new_pager = (Pager) doalloc ((unsigned) sizeof (PAGER));
	bzero ((char *) new_pager, sizeof (struct s_pager));

	new_pager-> strings = strings;
	new_pager-> header = header;
	new_pager-> buttonIDs [0] = SELECT;
	new_pager-> buttonIDs [1] = CANCEL;
	new_pager-> buttonIDs [2] = CANCELALL;


	new_pager-> last_x = 0;
	new_pager-> last_y = 0;

	return new_pager;
}

void FreePager (pager)
Pager pager;
{
	int i;

	if (pager-> win2 != (WinInfo) 0)
		DestroyWindow (pager-> win2);
	
	if (pager-> win1 != (WinInfo) 0)
		DestroyWindow (pager-> win1);
	
	for (i = 0; i < pager-> nr_funcs; i++)
		if (pager-> func_names [i] != (char *) 0)
			free ((char *) pager-> func_names [i]);

	if (pager-> buttonsset)
        {
                if (pager-> left_but != (char *) 0)
                        free ((char *) pager-> left_but);
                if (pager-> middle_but != (char *) 0)
                        free ((char *) pager-> middle_but);
                if (pager-> right_but != (char *) 0)
                        free ((char *) pager-> right_but);
        }

	if (pager-> func_start_x != (int *) 0)
		free ((char *) pager-> func_start_x);

	free ((char *) pager);
}

void SetPagerSelect (pager)
Pager pager;
{
	pager-> select = True;
}

void SetPagerButtonIDs (pager, left, middle, right)
Pager pager;
int left, middle, right;
{
	pager-> buttonIDs [0] = (left == DEFAULTFUNC)   ? SELECT    : left;
	pager-> buttonIDs [1] = (middle == DEFAULTFUNC) ? CANCEL    : middle;
	pager-> buttonIDs [2] = (right == DEFAULTFUNC)  ? CANCELALL : right;
}

void SetPagerButtons (pager, left, middle, right)
Pager pager;
char *left, *middle, *right;
{
	if (right == (char *) 0)
	{
		right = middle;
		middle = (char *) 0;
	}

	pager-> left_but = Str (left);

	if (middle != (char *) 0)
		pager-> middle_but = Str (middle);

	pager-> right_but = Str (right);

	pager-> buttonsset = True;
}

void AddPagerFunc (pager, name, id)
Pager pager;
char *name;
int id;
{
	pager-> func_names [pager-> nr_funcs] = Str (Fmt ("%s", name));
	pager-> func_ids   [pager-> nr_funcs ++ ] = id;
}

void SetInfoOnPager (pager, proc)
Pager pager;
void (* proc) ();
{
	pager-> proc = proc;
}

static void ShowPagerFuncs (pager)
Pager pager;
{
	int i;

	if (pager-> nr_funcs > 0)
	{
		PrintMarkedN (pager-> win1, 0, pager-> func_start_y,
				Fmt ("%*s", pager-> win1_width, ""));

		for (i = 0; i < pager-> nr_funcs; i++)
			PrintMarkedB (pager-> win1,
					pager-> func_start_x [i],
					pager-> func_start_y,
					pager-> func_names [i]);
	}
}

void RemapPager (pager)
Pager pager;
{
	int i;
	bool flag;
	char * ptr;
	WinInfo win;

	win = pager-> win2;

	i = 0;
/*
	InitStringList (pager-> strings);
	while ((ptr = GetNextStringFlag (pager-> strings, & flag))!= (char *) 0)
*/
	while ( i < win-> si_height ) {
	    ptr = GiveIthString( pager-> strings, i + win-> wd_start_y);
	    flag = GiveIthFlag( pager-> strings, i + win-> wd_start_y);
	    
		Print (pager-> win2, 0, i ++, Fmt ("%-*.*s",
			pager-> win2_width, pager-> win2_width, ptr),
				flag ? BOLD : NORMAL);
	}

	DrawScrollBar (pager-> win2);
	RefreshWindow (pager-> win2);
}

void MapPager (pager, win, x, y, fromtop, towm)
Pager pager;
WinInfo win;
bool fromtop;
bool towm;
{
	int i, j, k, l, m;
	int min;
	int width;
	int id;
	char * ptr;
	int oldwidth;

	if (StringsSize (pager-> strings) == 0)
		AddString (pager-> strings, "(xemp: empty)");

	pager-> win1_width = MaxStringLen (pager-> strings);

	if (pager-> win1_width > screen_cols - 4)
		pager-> win1_width = screen_cols - 4;

	pager-> win2_width = pager-> win1_width;

	pager-> win2_start_y = 0;
	pager-> button_start_y = 0;

	pager-> box = LEFT_BOX | RIGHT_BOX;

	MakeStringIndex (pager-> strings);

	if (pager-> proc != (void (*) ()) 0)
	{
		oldwidth = pager-> win1_width;
		pager-> win2_width += HELP_STRLEN;
		pager-> win1_width += HELP_STRLEN;
	}

		/* calculate height of window */

	pager-> nr_lines = StringsSize (pager-> strings);

	if (pager-> nr_lines > map_height - 5)
	{
		pager-> scrollbar = True;
		pager-> win2_height = map_height - 5;
		pager-> scrolllines = pager-> nr_lines - (map_height - 5);
		pager-> win1_width ++;
	}
	else
	{
		pager-> win2_height = pager-> nr_lines;
		pager-> scrollbar = False;
		pager-> scrolllines = 0;
	}
	pager-> win1_height = pager-> win2_height;

	if (pager-> header != (char *) 0)
	{
		pager-> win1_height ++;
		pager-> win2_start_y ++;
		pager-> button_start_y ++;
	}
	else
		pager-> box |= UPPER_BOX;

	if (pager-> buttonsset)
	{
		pager-> win2_start_y ++;
		pager-> win1_height ++;
	}

	if (pager-> nr_funcs > 0)
	{
		pager-> func_start_y = pager-> win1_height;
		pager-> win1_height ++;
	}
	else
		pager-> box |= LOWER_BOX;

		/*
		 *	calculate min width
		 */

	width = pager-> win2_width;
	if (pager-> header != (char *) 0)
	{
		l = strlen (pager-> header) + 2;
		if (width < l)
			width = l;
	}

	if (pager-> nr_funcs > 0)
	{
		l = 0;
		for (i = 0; i < pager-> nr_funcs; i++)
			l += strlen (pager-> func_names [i]);
		
		l += (pager-> nr_funcs - 1); /* times 2 */
		if (width < l)
			width = l;
	}

	if (pager-> buttonsset)
	{
		l = strlen (pager-> right_but) + strlen (pager-> left_but) + 5;
		if (pager-> middle_but != (char *) 0)
			l += strlen (pager-> middle_but) + 3;
		
		if (width < l)
			width = l;
	}

	pager-> win1_width += (width - pager-> win2_width);
	pager-> win2_width = width;

	pager-> win1 = OpenRelToRoot (
		win,
		x,
		y,
		pager-> win1_width,
		pager-> win1_height,
		pager-> box,
		0);

	pager-> win2 = OpenWindow (
		pager-> win1,
		0, 
		pager-> win2_start_y,
		pager-> win2_width,
		pager-> win2_height,
		0,
		NO_BOX,
		pager-> scrolllines);

		/*
		 *	draw buttons
		 */

	if (pager-> buttonsset)
	{
		i = strlen (pager-> left_but);
		j = strlen (pager-> right_but);
		l = pager-> win1_width;

		if (pager-> middle_but == (char *) 0)
			PrintMarkedN (pager-> win1,
				0, pager-> button_start_y,
				Fmt ("[%s]%*s[%s]", pager-> left_but,
					l - i - j - 4, "",
					pager-> right_but));
		else
		{
			k = l - i - j - 6 - strlen (pager-> middle_but);
			m = k / 2;
			PrintMarkedN (pager-> win1,
				0, pager-> button_start_y,
				Fmt ("[%s]%*s[%s]%*s[%s]", 
					pager-> left_but,
					m, "",
					pager-> middle_but,
					k - m, "",
					pager-> right_but));
		}
	}

		/* header */

	if (pager-> header != (char *) 0)
	{
		l = strlen (pager-> header);
		i = (pager-> win1_width - l) / 2;
		PrintMarkedN (pager-> win1, 0, 0, 
			Fmt ("%*s%s%*s", i, "", pager-> header, 
				 pager-> win1_width - l - i, ""));
	}

	if (pager-> nr_funcs > 0) /* set starting coordinates of nr_funcs */
	{
		pager-> func_start_x = (int *) doalloc (
					pager-> nr_funcs * sizeof (int));

		l = pager-> win1_width;

		for (i = 0; i < pager-> nr_funcs; i ++)
			l -= strlen (pager-> func_names [i]);
		
		if (pager-> nr_funcs == 1)
			pager-> func_start_x [0] = (int) (l / 2);
		else
		{
			pager-> func_start_x [0] = 0;
			m = strlen (pager-> func_names [0]);
			for (i = 1; i < pager-> nr_funcs; i ++)
			{
				j = (int) (l / (pager-> nr_funcs - i));
				m += j;
				l -= j;
				pager-> func_start_x [i] = m;
				m += strlen (pager-> func_names [i]);
			}
		}
	}

	if (pager-> proc != (void (*) ()) 0)
	{
		/* adjust strings */

		InitStringList (pager-> strings);

		while ((ptr = GetNextStringID (pager-> strings, & id))
								!= (char *) 0)
			ChangeString (pager-> strings, id, Fmt ("%-*.*s [?]",
				pager-> win2_width - HELP_STRLEN,
				pager-> win2_width - HELP_STRLEN,
				ptr ));
	}


	ShowPagerFuncs (pager);
			
	if (fromtop)
		SetToTop (pager-> win2);
	else {
		SetToBot (pager-> win2);
		pager-> last_y = pager-> win2 -> savelines;
	}

	RefreshWindow (pager-> win1);
	RemapPager (pager);
	Refresh ();
}

void MapPagerFromTop (pager, win, x, y)
Pager pager;
WinInfo win;
int x, y;
{
	if (! pager-> edit)
		MapPager (pager, win, x, y, True, False);
}

void MapPagerFromBot (pager, win, x, y)
Pager pager;
WinInfo win;
int x, y;
{
	MapPager (pager, win, x, y, False, False);
}

static int FuncAtBottom (pager, ch)
Pager pager;
char ch;
{
	int i;
	char func_ch;

	if (pager-> nr_funcs == 0)
		return NOFUNC;

	if (ch > 'Z' || ch < 'A')
		return NOFUNC;

	for (i = 0; i < pager-> nr_funcs; i ++)
	{
		func_ch = pager-> func_names [i][0];
		if (func_ch >= 'a' && func_ch <= 'z')
			func_ch = func_ch - 'a' + 'A';
	
		if (func_ch == ch)
			return pager-> func_ids [i];
	}

	return NOFUNC;
}

static void SavePagerText (pager)
Pager pager;
{
	char * file;
	Strings stripped;

	PrintB (pager-> win1, 0, pager-> func_start_y, Fmt ("%*s",
			pager-> win1_width, ""));
	
	PrintMarked (pager-> win1, 0, pager-> func_start_y, "Filename: ");

	file = GetString (pager-> win1, 10, pager-> func_start_y,
			30, GS_TEXT);
		
	if (file != (char *) 0 && * file != '\0')
	{
		stripped = StripStrings (pager-> strings);

			/*
			 *	XXX:	Message: text saved
			 */

		(void) WriteStrings (stripped, file);
		FreeStrings (stripped);
	}

	ShowPagerFuncs (pager);
	RefreshWindow (pager-> win2);
	Refresh ();
}

static void ChangeMenuLine (pager, oldx, oldy, newx, newy)
Pager pager;
int oldx, oldy, newx, newy;
{
	WinInfo win;
	bool redraw;
	char * pch;
	int mode;

	win = pager-> win2;

	if (oldx != -1)
	{
		pch = GiveIthString( pager-> strings, oldy);
		mode = GiveIthFlag (pager-> strings, oldy) ? BOLD : NORMAL;
		Print (win, oldx * pager-> col_width,
			oldy - win-> wd_start_y,
			Fmt ("%-*.*s",
				pager-> col_width, pager-> col_width,
				& pch [oldx * pager-> col_width]),
				mode);
	}

/*	
	pch = GiveIthString ( pager-> strings, newy);
	PrintB (win, newx * pager-> col_width,
			newy - win-> wd_start_y,
			Fmt ("%-*.*s",
				pager-> col_width, pager-> col_width,
				& pch [newx * pager-> col_width]));
*/

	redraw = False;

	if (win-> wd_start_y + win-> si_height <= newy)
	{
		win-> wd_start_y += win-> si_height / 2;
		redraw = True;
	}
	
	if (win-> wd_start_y > newy)
	{
		win-> wd_start_y -= win-> si_height;
		redraw = True;
	}
	
	if (redraw)
	{
		if (win-> wd_start_y < 0)
			win-> wd_start_y = 0;
		else if (win-> wd_start_y > win-> savelines)
			win-> wd_start_y = win-> savelines;

		RemapPager (pager);
/*
		RefreshWindow (win);
		DrawScrollBar (win);
*/
	}

	pch = GiveIthString ( pager-> strings, newy);
	PrintB (win, newx * pager-> col_width,
			newy - win-> wd_start_y,
			Fmt ("%-*.*s",
				pager-> col_width, pager-> col_width,
				& pch [newx * pager-> col_width]));
	Refresh ();
}

int PagerMenuFunc (pager, ret, pcols)
Pager pager;
int * ret, * pcols;
{
	int cx, cy, ny;
	int cols, col_width;
	int choice;
	int button;
	char ch;

	col_width = pager-> win2_width;
	cols = (pcols == (int *) 0) ? 1 : * pcols;
	MakeStringIndex (pager-> strings);
	if (cols > 1)
	{
		char * ptr1, * ptr2;

		ptr1 = GiveIthString (pager-> strings, 1);
		ptr2 = ptr1;
		ScanWord (& ptr2, (char *) 0);
		SkipBlank (& ptr2);
		col_width = ptr2 - ptr1;
		/* 
		col_width = (col_width + cols - 1) / cols;
		*/
	}
	
	pager-> cols = cols;
	pager-> col_width = col_width;

	cx = pager-> last_x;
	cy = pager-> last_y;

	ChangeMenuLine (pager, -1, -1, cx, cy);

	for (;;)
	{
		ch = getchar ();

		if (StandardChar (ch, E_SCROLL | E_REDRAW))
			continue;

		if (ch == ESCAPE)
		{
			* ret = CANCELALL;
			return;
		}
			
		if (ch == move_chars [CH_UP])
		{
			if (cy == 0)
				Bell ();
			else
			{
				ChangeMenuLine (pager, cx, cy, cx, cy - 1);
				cy --;
			}
		}

		if (ch == move_chars [CH_DOWN])
		{
			if (cy == pager-> nr_lines - 1)
				Bell ();
			else
			{
				ChangeMenuLine (pager, cx, cy, cx, cy + 1);
				cy ++;
			}
		}

		if (ch == move_chars [CH_SH_UP])
		{
			if (cy == 0)
			{
				Bell ();
				continue;
			}
			ny = cy - 5;
			if (ny < 0)
				ny = 0;
			ChangeMenuLine (pager, cx, cy, cx, ny);
			cy = ny;
		}

		if (ch == move_chars [CH_SH_DOWN])
		{
			if (cy == pager-> nr_lines - 1)
			{
				Bell ();
				continue;
			}
			ny = cy + 5;
			if (ny >= pager-> nr_lines)
				ny = pager-> nr_lines - 1;
			ChangeMenuLine (pager, cx, cy, cx, ny);
			cy = ny;
		}

		if (ch == move_chars [CH_LEFT])
		{
			if (cx == 0)
				Bell ();
			else
			{
				ChangeMenuLine (pager, cx, cy, cx - 1, cy);
				cx --;
			}
		}

		if (ch == move_chars [CH_RIGHT])
		{
			if (cx == cols - 1)
				Bell ();
			else
			{
				ChangeMenuLine (pager, cx, cy, cx + 1, cy);
				cx ++;
			}
		}

		if (ch == '?')
		{
			if (pager-> proc == (void (*)()) 0)
				Bell ();
			else
			{
				(* pager-> proc) (10, 10, 
					GiveIthID (pager-> strings, cy));
							/* cy * cols + cx));*/

				Refresh ();
				continue;
			}
		}

		if ((choice = FuncAtBottom (pager, ch)) != NOFUNC)
		{
			if (choice == WRITEFUNC)
			{
				SavePagerText (pager);
				continue;
			}
			else if (choice == READFUNC)
			{
			}
			else if (choice == TOWMFUNC)
			{
				Bell ();
				continue;
			}

			pager-> last_x = cx;
			pager-> last_y = cy;
			* ret = choice;
			return -1;
		}

		button = CharToButton (ch);
		if (button != -1)
		{
			* ret = pager-> buttonIDs [button];
			pager-> last_x = cx;
			pager-> last_y = cy;

			if (pcols != (int *) 0)
				* pcols = cx;

			return GiveIthID (pager-> strings, cy);
		}
	}
}

void ChangePagerString (pager, id, str)
Pager pager;
int id;
char * str;
{
	if (pager-> proc != (void (*) ()) 0)
		ChangeString (pager-> strings, id, Fmt ("%-*.*s [?]",
			pager-> win2_width - HELP_STRLEN,
			pager-> win2_width - HELP_STRLEN,
			str));
	else
		ChangeString (pager-> strings, id, str);
}


int PagerMenu (pager)
Pager pager;
{
	int func;
	int i;

	i = PagerMenuFunc (pager, & func, (int *) 0);

	if (func != SELECT)
		return -1;
	else
		return i;
}

void FpDumpPager (fp, pager)
FILE * fp;
Pager pager;
{
	int i;

	fprintf (fp, "Header:        %s\n",
			pager-> header ? pager-> header : "");
	fprintf (fp, "Win1 size:     %dx%d\n", pager-> win1_width,
			pager-> win1_height);
	fprintf (fp, "Win2 size:      %dx%d\n", pager-> win2_width,
			pager-> win2_height);
	fprintf (fp, "Win2 start y:   %d\n", pager-> win2_start_y);
	fprintf (fp, "Button start y: %d\n", pager-> button_start_y);
	fprintf (fp, "Func start y:   %d\n", pager-> func_start_y);
	fprintf (fp, "Nr lines:       %d\n", pager-> nr_lines);
	fprintf (fp, "Scrollbar:      %s\n", pager-> scrollbar ? "Yes" : "No");
	if (pager-> scrollbar)
		fprintf (fp, "Scrolllines:    %d\n", pager-> scrolllines);
	fprintf (fp, "Win 1:          0x%0lx\n", pager-> win1);
	fprintf (fp, "Win 2:          0x%0lx\n", pager-> win2);
	fprintf (fp, "Box:            0x%0x\n", pager-> box);
	if (pager-> buttonsset)
		fprintf (fp, "Buttons:        { \"%s\", %s\"%s\" }\n",
		    pager-> right_but,
		    pager-> middle_but  ? Fmt ("\"%s\", ", pager-> middle_but)
					: "",
		    pager-> right_but);

	if (pager-> proc)
		fprintf (fp, "Help procedure set.\n");
	fprintf (fp, "Nr functs:      %d\n", pager-> nr_funcs);
	if (pager-> nr_funcs > 0)
	{
		char buf [100];

		(void) sprintf (buf, "{ ");
		for (i = 0 ; i < pager-> nr_funcs; i ++)
		{
			if (i != 0)
				strcat (buf, ", ");
			strcat (buf, Fmt ("%d", pager-> func_start_x [i]));
		}
		strcat (buf, " }");

		fprintf (fp, "Func start x's  %s\n", buf);
	}

	if (pager-> select)
		fprintf (fp, "Select pager");
}

void DumpPager (pager)
Pager pager;
{
	FILE * fp;


	fp = fopen ("pager.dump", "w");
	if (fp == (FILE *) 0)
		return;

	FpDumpPager (fp, pager);
}

void DumpPagerScreen (pager)
Pager pager;
{
	FpDumpPager (stdout, pager);
}

bool EditPager (pager)
Pager pager;
{
	FILE * fp;
	char * editor;
	int pid;
	int status;
	char * tmp_file;
	struct stat stat1, stat2;

	extern struct sgttyb tc_status, save_status;

	editor = getenv ("EDITOR");
	if (editor == (char *) 0)
		editor = DEFAULT_EDITOR;
	
	tmp_file = Fmt ("/tmp/xemp.%d", getpid ());
	WriteStrings (pager-> strings, tmp_file);

	stat (tmp_file, & stat1);

	pid = fork ();
	switch (pid)
	{

	case -1:
		Error ("Fork failed");
		return;

	case 0:		/* parent */
		stty (0, & save_status);
		execl (editor, editor, tmp_file, (char *) 0);
		Error ("execl failed");
		break;

	default:
		(void) wait (& status);
		stty (0, & tc_status);
		break;
	}

	Redraw ();
	if (stat (tmp_file, & stat2) == 0)
	{
		if (stat1. st_mtime != stat2. st_mtime)
		{
			fp = fopen (tmp_file, "r");
			FreeStrings (pager-> strings);
			pager-> strings = ReadStrings (fp);
			fclose (fp);
		}
		unlink (tmp_file);
		return True;
	}
	else
		return False;
}

void AddPagerToWMList (pager)
Pager pager;
{
	fprintf (stderr, "AddPagerTOWM called\n");
}

char * PagerMulti (pager, pfunc)
Pager pager;
int * pfunc;
{
	char *ptr;
	static char buf[256];
	int col, num;
	int y;

	ptr = GiveIdString (pager-> strings, 1);

	num = 0;
	while (ScanWord (& ptr, (char *) 0))
		num ++;
	
	for (;;)
	{
		col = num;
		y = PagerMenuFunc (pager, pfunc, & col);

		if (* pfunc != SELECT)
			return (char *) 0;
		
		if (y < 0)
		{
			* pfunc = CANCELALL;
			return (char *) 0;
		}

		ptr = GiveIdString (pager-> strings, y) +
					(col * pager-> col_width);
		if (ptr == (char *) 0 || ! ScanWord (& ptr, buf))
		{
			Error ("Bad Selection ?");
			continue;
		}

		return buf;
	}
}

char * InputPagerLine (pager, y)
Pager pager;
int y;
{
	char *ptr;

	Print (pager-> win2, 0, y, Fmt ("%-*s", pager-> win2_width, ""), 
				NORMAL);
	ptr =  GetString (pager-> win2, 0, y, pager-> win2_width - 4, GS_TEXT);

	return ptr;
}

int ShowPager (pager)
Pager pager;
{
	char ch;
	int choice;
	int button;

	for (;;)
	{
		ch = getchar ();

		if (StandardChar (ch, E_SCROLL | E_REDRAW))
			continue;

		if (ch == ESCAPE)
		{
			return CANCELALL;
		}
			
		if ((choice = FuncAtBottom (pager, ch)) != NOFUNC)
		{
			if (choice == WRITEFUNC)
			{
				SavePagerText (pager);
				continue;
			}
			else if (choice == READFUNC)
			{
			}
			else if (choice == TOWMFUNC)
			{
				Bell ();
				continue;
			}

			return choice;
		}


		if (ch == '\n')
			return SELECT;
		
		if (ch == ' ')	/* space -> down */
		{
			if (AtBottum (pager-> win2) && xrc. space_is_next)
				return SELECT;

			ScrollDown (pager-> win2, pager-> win2_height - 2);
/* krf */		RemapPager (pager);
			Refresh();
			continue;
		}
		
		if (ch == '\t')
		{
			ScrollUp (pager-> win2, pager-> win2_height - 2);
/* krf */		RemapPager (pager);
			Refresh();
			continue;
		}
			
		button = CharToButton (ch);
		if (button != -1)
		{
			choice = pager-> buttonIDs [button];

			if (choice == SELECT)
				continue;

			return choice;
		}
	}
}

void ShowStringsInPager (strings, header)
Strings strings;
char * header;
{
	Pager pager;

	pager = InitPager (strings, header);
	AddPagerFunc (pager, "Write", WRITEFUNC);
	AddPagerFunc (pager, "Cancel", CANCELFUNC);
	MapPager (pager, map_win, 2, 2);
	(void) ShowPager (pager);
	FreePager (pager);
}

void ShowPagerLine (pager, y)
Pager pager;
int y;
{
	if (GiveIthFlag (pager-> strings, y))
		PrintB (pager-> win2, 0, y, Fmt ("%-*s",
			pager-> win2_width,
			GiveIthString (pager-> strings, y)));
	else
		PrintN (pager-> win2, 0, y, Fmt ("%-*s",
			pager-> win2_width,
			GiveIthString (pager-> strings, y)));

	FlushWindow (pager-> win2);
}

void SetEditPager (pager)
Pager pager;
{
	pager-> edit = True;

}

Strings PagerStrings (pager)
Pager pager;
{
	return pager-> strings;
}
