#include <stdio.h>

#define BUFLEN	1024

#define MAX_CAPS	20

char * cs  [MAX_CAPS],
     * ce  [MAX_CAPS],
     * cns [MAX_CAPS],
     * cne [MAX_CAPS];

int nr_caps;

typedef int bool;
typedef char * String;

#ifndef True
#define	True	1
#define False	0
#endif

String CM;
String CL;
String IS;

char bp [BUFLEN];
char buf [BUFLEN];
String bptr;

extern String getenv ();

String term;

static void P (s)
char * s;
{
	puts (s);
}

void ShowInfo ()
{
	char buf [100];

	P ("this program will help you to select the capabilities for using");
	P ("xemp, by showing some combinations of different highlights.");
	P ("");
	P ("by capabilities I mean e.g.: 'reverse video', 'underlined'");
	P ("'blinking' or 'half intensity'.");
	P ("");
	P ("you should find two capabilities that give a different look for");
	P ("all different combinations."); 
	P ("");
	P ("example:");
	P ("buttons are simulated by displayed text in reverse video. to show");
	P ("they are enabled, I use the second capability");
	P ("");
	printf ("more: ");
	fflush (stdout);
	gets (buf);
	P ("");
}

String SearchEntry (id)
String id;
{
	int i;

	for (i = 0; i < nr_caps; i ++)
	{
		if (strcmp (cns [i], id) == 0)
			return cs [i];
		if (strcmp (cne [i], id) == 0)
			return ce [i];
	}

	return (String) 0;
}

void TGetStr (ptr, id, must)
String * ptr;
String id;
bool must;
{
	extern String tgetstr ();

	* ptr = tgetstr (id, & bptr);

	if ((* ptr == (char *) 0) && must)
	{
		fprintf (stderr, "Alas, you won't be able to run tcemp on ");
		fprintf (stderr, "this terminal (TERM=%s).\n", term);
		fprintf (stderr,
			"Reason: You don't have the \"%s\" capability.\n",
							id);
		exit (1);
	}
}

void GetCab (id1, id2)
String id1, id2;
{
	String ptr1, ptr2;

	ptr1 = SearchEntry (id1);
	if (ptr1 == (String) 0)
		ptr1 = tgetstr (id1, & bptr);
	ptr2 = SearchEntry (id2);
	if (ptr2 == (String) 0)
		ptr2 = tgetstr (id2, & bptr);

	if (ptr1 == (String) 0 || ptr2 == (String) 0)
		return;
	
	cs [nr_caps] = ptr1;
	ce [nr_caps] = ptr2;
	cns [nr_caps] = id1;
	cne [nr_caps] = id2;

	nr_caps ++;
}

void Put (ch)
char ch;
{
	putchar (ch);
}

void Goto (x, y)
int x, y;
{
	tputs (tgoto (CM, x, y), 1, Put);
}

void PutNameAt (x, y, id)
int x, y, id;
{
	Goto (x, y);
	printf ("%s:%s", cns [id], cne [id]);
}

void Update (s1, s2)
char * s1, * s2;
{
	char old [100], new [100];
	FILE * fp_old, * fp_new;
	int len;
	char buf [BUFLEN];
	char line [100];

	if (strlen (s1) != 5)
	{
		P ("update failed, illegal first capability");
		exit (1);
	}

	if (strlen (s2) != 5)
	{
		P ("update failed, illegal second capability");
		exit (1);
	}

	(void) sprintf (old, "%s/.xemprc", getenv ("HOME"));
	(void) sprintf (new, "%s/.xemprc.trynew", getenv ("HOME"));

	fp_old = fopen (old, "r");
	if (fp_old == (FILE *) 0)
	{
		fprintf (stderr, "Can't open %s for reading\n", old);
		perror ("fopen");
		exit (-1);
	}

	fp_new = fopen (new, "w");
	if (fp_new == (FILE *) 0)
	{
		fprintf (stderr, "Can't open %s for writing\n", new);
		perror ("fopen");
		exit (-1);
	}

	(void) sprintf (line, "TC Term (%s) Capab=", term);
	len = strlen (line);
	while (fgets (buf, BUFLEN, fp_old) != (char *) 0)
	{
		if (strncmp (buf, line, len) != 0)
			fputs (buf, fp_new);
		else
			P ("old entry deleted.");
	}
	fprintf (fp_new, "%s%s:%s\n", line, s1, s2);
	fclose (fp_old);
	fclose (fp_new);

	if (unlink (old) < 0)
	{
		fprintf (stderr, "Couldn't unlink %s\n", old);
		perror ("unlink");
		exit (-1);
	}

	if (rename (new, old) < 0)
	{
		fprintf (stderr, "Couldn't rename %s to %s\n", new, old);
		perror ("rename");
		exit (-1);
	}

	P ("new entry added.");
}
		
void ShowCaps ()
{
	int i, j;
	char * def1, * def2, * ans1, * ans2;
	char buf [100], buf1 [100], buf2 [100];

	if (IS != (char *) 0)
		tputs (IS, 1, Put);

	tputs (CL, 1, Put);
	fflush (stdout);

	for (i = 0; i < nr_caps; i ++)
		PutNameAt (7 + i * 7, 1, i);

	for (i = 0; i < nr_caps; i ++)
	{
		PutNameAt (1, i * 2 + 3, i);
		for (j = 0; j < nr_caps; j ++)
		{
			Goto (j * 7 + 7, i * 2 + 3);
			putchar ('"');
			tputs (cs [j], 1, Put);
			tputs (cs [i], 1, Put);
			printf ("Test");
			tputs (ce [i], 1, Put);
			tputs (ce [j], 1, Put);
			putchar ('"');
		}
	}

	Goto (0, nr_caps * 2 + 3);
	printf ("Selecting capabilities for terminal type: %s\n", term);
	P ("");
	def1 = (SearchEntry ("so") != (char *) 0) ? "so/se" : (char *) 0;
	if (SearchEntry ("so") != (char *) 0)
	{
		printf ("First  cap [so:se]: ");
		gets (buf1);
		if (buf1 [0] == '\0')
			ans1 = "so:se";
		else
			ans1 = buf1;
	}
	else
	{
		printf ("First  cap: ");
		gets (buf1);
		if (buf1 [0] == '\0')
		{
			P ("Needs a first capability.");
			exit (0);
		}
		ans1 = buf1;
	}
	if (SearchEntry ("us") != (char *) 0)
	{
		printf ("Second cap [us:ue]: ");
		gets (buf2);
		if (buf2 [0] == '\0')
			ans2 = "us:ue";
		else
			ans2 = buf2;
	}
	else
	{
		printf ("Second cap: ");
		gets (buf2);
		if (buf2 [0] == '\0')
		{
			P ("Needs a second capability.");
			exit (0);
		}
		ans2 = buf2;
	}

	P ("");
	printf ("Update .xemprc [y]: ");
	gets (buf);
	if (buf [0] == '\0' || buf [0] == 'y' || buf [0] == 'Y')
		Update (ans1, ans2);
	else
	{
		P ("");
		P ("Now you must add the following line to your .xemprc:");
		printf ("TC term (%s) CAPAB=%s:%s\n", term, ans1, ans2);
	}
}

main (argc, argv)
int argc;
char * argv [];
{
	char ans [100];
	char buf [100];

	nr_caps = 0;
	ShowInfo ();

	term = getenv ("TERM");
	if (term == (char *) 0)
	{
		fprintf (stderr,
			"You didn't set the TERM environment variable\n");
		fprintf (stderr,
			"tcemp can't run without knowing what kind of ");
		fprintf (stderr,
			"escape code to send.\n");
		fprintf (stderr,
			"You can set the TERM variable as follows: \n\n");
		fprintf (stderr,
			"sh$ TERM=vt100\n");
		fprintf (stderr,
			"sh$ export TERM\n\n");
		fprintf (stderr,
			"csh% setenv TERM vt100\n\n");
		fprintf (stderr,
			"(Assuming you're working on a vt100 teminal).\n");
		exit (-1);
	}

	switch (tgetent (bp, term))
	{

	case -1:
		fprintf (stderr, "Can't open termcap file (%s).\n",
			getenv ("TERMCAP") == (char *) 0 ?
				"/etc/termcap": getenv ("TERMCAP"));
		exit (1);
	
	case 0:
		fprintf (stderr, "Can't find termcap entry for \"%s\".\n", 
					term);
		exit (1);
		
	default:
		break;
	}
	bptr = buf;

	TGetStr (& CM, "cm", True);
	TGetStr (& CL, "cl", True);
	TGetStr (& IS, "is", False);

	cs  [0] = "";
	ce  [0] = "";
	cns [0] = "--";
	cne [0] = "--";
	nr_caps = 1;

	GetCab ("so", "se");
	GetCab ("hi", "he");
	GetCab ("us", "ue");
	GetCab ("mb", "me");
	GetCab ("md", "me");
	GetCab ("mh", "me");
	GetCab ("mp", "me");
	GetCab ("mr", "me");

		/* nr_caps contains none */

	if (nr_caps == 1)
	{
		P ("Alas, I couldn't find any highlight at all. I suggest you");
		P ("you try to find some capabilites (check you terminal");
		P ("reference manual). Or try to run trycap (& tcemp) on ");
		P ("another terminal.");
		exit (0);
	}
	else if (nr_caps == 2)
	{
		P ("Alas, you only have one highlight. This will");
		P ("give you a less efficient tcemp, so I suggest you");
		P ("try to find other capabilites (check you terminal");
		P ("reference manual). Or try to run trycap (& tcemp) on ");
		P ("another terminal.");
		P ("");

		printf ("Do you want me to update your .xemprc [y]: ");
		gets (ans);

		(void) sprintf (buf, "%s:%s", cns [1], cne [1]);
		if (* ans == '\0' || * ans == 'y' || * ans == 'Y')
		     Update (buf, buf);
		else
		{
		     P ("Now you must add the following line to your .xemprc:");
		     printf ("TC term (%s) CAPAB=%s:%s\n", term, buf, buf);
		}
		exit (0);
	}

	ShowCaps ();
}
