#include "type.h"
#include "main.h"
#include "xrc.h"
#include "plane.h"
#include "sector.h"
#include "func.h"
   
#define BOGUS_PLANENR		32123
   
   char * SelectPlanes (x, y, sct, mission, quest)
int x, y;
Sector sct;
Mission mission;
char * quest;
{
   Strings strings;
   Sector from;
   Pager pager;
   Plane ptr, plane;
   int i;
   bool ok;
   bool first;
   int func;
   bool flag;
   int nr;
   int dist;
   static char buffer [200];
   extern int last_layout;
   char * cptr;
   
   strings = InitStrings ();
   AddStringID (strings,
		"Plane                     Eff  Ran  Mob  Tec   Loa  Att Def Dist",
		BOGUS_PLANENR);
   
   for ALL_PLANES (ptr)
      {
	 if ((mission == MIS_WINGADD) || (mission==MIS_TRANSPORT))
	    {
	       if (s_xcd (sct) != pl_xcd (ptr) ||
		   s_ycd (sct) != pl_ycd (ptr))
		  continue;
	       
	       AddStringID (strings, Fmt (
					  "%-4d %-16.16s  %c  %-3d  %-3d  %-3d  %-4d  %-3d  %-3d %-3d  -",
					  pl_nr (ptr),
					  PlaneName (ptr),
					  pl_wing (ptr),
					  pl_eff (ptr),
					  pl_range (ptr),
					  pl_mob (ptr),
					  pl_tech (ptr),
					  planetypes [pl_type (ptr)]. load,
					  pl_att (ptr),
					  pl_def (ptr)),
			    pl_nr (ptr));
	       continue;
	    }
	 
	 if (pl_mob (ptr) <= 0 || pl_marked (ptr))
	    continue;
	 
	 if (PlaneHas (ptr, P_M) || PlaneHas (ptr, P_O))
	    continue;
	 
	 ok = False;
	 
	 switch (mission)
	    {
	       
	    case MIS_FLY:
	       ok = True;
	       break;
	       
	    case MIS_BOMB:
	       ok = ! PlaneHas (ptr, P_C)
		  && planetypes [pl_type (ptr)]. load > 0;
	       break;
	       
	    case MIS_DROP:
	    case MIS_PARADROP:
	       ok = (MaxPlaneLoad (ptr) > 0) && PlaneHas (ptr, P_C);
	       break;
	       
	    case MIS_ESCORT:
	       ok = PlaneHas (ptr, P_F);
	       break;
	       
	    case MIS_RECON:
	       ok = True; /*PlaneHas (ptr, P_S);*/
	       break;
	       
	    }
	 
	 if (! ok)
	    continue;
	 
	 dist = Dist (s_xcd (sct), pl_xcd (ptr),
		      s_ycd (sct), pl_ycd (ptr));
	 
	 if (dist > 3)
	    continue;
	 
	 if (! xrc. dist_planes && dist > 0)
	    continue;
	 
	 if (! PlaneHas (ptr, P_V))
	    {
	       from = PlaneSector (ptr);
	       if (s_des (from) == '.')
		  continue;
	       if (s_des (from) != '.' && (s_des (from) != '*' ||
					   s_eff (from) < 60))
		  continue;
	    }
	 
	 AddStringID (strings, Fmt (
				    "%-4d %-16.16s  %c  %-3d  %-3d  %-3d  %-4d  %-3d  %-3d %-3d %d",
				    pl_nr (ptr),
				    PlaneName (ptr),
				    pl_wing (ptr),
				    pl_eff (ptr),
				    pl_range (ptr),
				    pl_mob (ptr),
				    pl_tech (ptr),
				    MaxPlaneLoad (ptr),
				    pl_att (ptr),
				    pl_def (ptr),
				    dist),
		      pl_nr (ptr));
      }
   
   if (StringsSize (strings) == 1)
      {
	 if (mission == MIS_ESCORT)
	    {
	       FreeStrings (strings);
	       return ".";
	    }
	 
	 switch (mission)
	    {
	       
	    case MIS_FLY:
	       cptr = "flying";
	       break;
	       
	    case MIS_BOMB:
	       cptr = "bombing";
	       break;
	       
	    case MIS_PARADROP:
	       cptr = "paradrop";
	       break;
	       
	    case MIS_DROP:
	       cptr = "dropping";
	       break;
	       
	    case MIS_RECON:
	       cptr = "recon";
	       break;
	       
	    default:
	       cptr = "unrecognized";
	       break;
	       
	    }
	 
	 Message (Fmt ("No planes to select for this %s mission", cptr));
	 Bell ();
	 return ".";
      }
   
   if (mission != MIS_ESCORT)
      {
	 if (last_layout == WING_MODE)
	    {
	       for ALL_PLANES (ptr)
		  if (pl_wing (ptr) == curwing)
		     SetStringFlag (strings, pl_nr (ptr), True);
	    }
	 else if (last_layout == PLANE_MODE)
	    SetStringFlag (strings, pl_nr (curplane), True);
      }
   
   pager = InitPager (strings, quest);
   AddPagerFunc (pager, "Cancel", CANCELFUNC);
   AddPagerFunc (pager, "Done", DONEFUNC);
   SetPagerButtons (pager, "Toggle", "Toggle Wing", "Done");
   SetPagerButtonIDs (pager, TOGGLEFUNC, TOGGLEWINGFUNC, DONEFUNC);
   SetPagerSelect (pager);
   
   MapPagerFromTop (pager, map_win, x, y);
   
   for (;;)
      {
	 i = PagerMenuFunc (pager, & func, (int *) 0);
	 
	 if (i < 0)
	    {
	       FreePager (pager);
	       FreeStrings (strings);
	       return (char * ) 0;
	    }
	 
	 switch (func)
	    {
	       
	    case TOGGLEFUNC:
	       if (i == BOGUS_PLANENR)
		  continue;
	       ToggleStringFlag (strings, i);
	       RemapPager (pager);
	       continue;
	       
	    case TOGGLEWINGFUNC:
	       if (i == BOGUS_PLANENR)
		  continue;
	       flag = ! GiveStringFlag (strings, i);
	       plane = NrToPlane (i);
	       for ALL_PLANES (ptr)
		  if (pl_wing (ptr) == pl_wing (plane))
		     SetStringFlag (strings, pl_nr (ptr),
				    flag);
	       RemapPager (pager);
	       continue;
	       
	    case DONEFUNC:
	       FreePager (pager);
	       InitStringList (strings);
	       buffer [0] = '\0';
	       first = True;
	       while ((nr = GetNextSelectedId (strings)) != -1)
		  {
		     if (first)
			first = False;
		     else
			strcat (buffer, "/");
		     
		     strcat (buffer, Fmt ("%d", nr));
		  }
	       
	       FreeStrings (strings);
	       if (first)
		  return ".";
	       else
		  return buffer;
	       
	    case CANCELFUNC:
	       FreePager (pager);
	       FreeStrings (strings);
	       return (char * ) 0;
	    }
      }
}
